/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.dao.RemoteProcessGroupDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRemoteProcessGroupDAO
extends ComponentDAO
implements RemoteProcessGroupDAO {
    private static final Logger logger = LoggerFactory.getLogger(StandardRemoteProcessGroupDAO.class);
    private FlowController flowController;

    private RemoteProcessGroup locateRemoteProcessGroup(String remoteProcessGroupId) {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        RemoteProcessGroup remoteProcessGroup = rootGroup.findRemoteProcessGroup(remoteProcessGroupId);
        if (remoteProcessGroup == null) {
            throw new ResourceNotFoundException(String.format("Unable to find remote process group with id '%s'.", remoteProcessGroupId));
        }
        return remoteProcessGroup;
    }

    public boolean hasRemoteProcessGroup(String remoteProcessGroupId) {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        return rootGroup.findRemoteProcessGroup(remoteProcessGroupId) != null;
    }

    public RemoteProcessGroup createRemoteProcessGroup(String groupId, RemoteProcessGroupDTO remoteProcessGroupDTO) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        if (remoteProcessGroupDTO.getParentGroupId() != null && !this.flowController.areGroupsSame(groupId, remoteProcessGroupDTO.getParentGroupId())) {
            throw new IllegalArgumentException("Cannot specify a different Parent Group ID than the Group to which the Remote Process Group is being added.");
        }
        String rawTargetUri = remoteProcessGroupDTO.getTargetUri();
        if (rawTargetUri == null) {
            throw new IllegalArgumentException("Cannot add a Remote Process Group without specifying the Target URI");
        }
        RemoteProcessGroup remoteProcessGroup = this.flowController.createRemoteProcessGroup(remoteProcessGroupDTO.getId(), rawTargetUri);
        this.updateRemoteProcessGroup(remoteProcessGroup, remoteProcessGroupDTO);
        group.addRemoteProcessGroup(remoteProcessGroup);
        return remoteProcessGroup;
    }

    public RemoteProcessGroup getRemoteProcessGroup(String remoteProcessGroupId) {
        RemoteProcessGroup remoteProcessGroup = this.locateRemoteProcessGroup(remoteProcessGroupId);
        return remoteProcessGroup;
    }

    public Set<RemoteProcessGroup> getRemoteProcessGroups(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        Set remoteProcessGroups = group.getRemoteProcessGroups();
        return remoteProcessGroups;
    }

    public void verifyUpdate(RemoteProcessGroupDTO remoteProcessGroup) {
        this.verifyUpdate(this.locateRemoteProcessGroup(remoteProcessGroup.getId()), remoteProcessGroup);
    }

    private void verifyUpdate(RemoteProcessGroup remoteProcessGroup, RemoteProcessGroupDTO remoteProcessGroupDto) {
        List requestValidation;
        if (this.isNotNull((Object)remoteProcessGroupDto.isTransmitting())) {
            if (!remoteProcessGroup.isTransmitting() && remoteProcessGroupDto.isTransmitting().booleanValue()) {
                remoteProcessGroup.verifyCanStartTransmitting();
            } else if (remoteProcessGroup.isTransmitting() && !remoteProcessGroupDto.isTransmitting().booleanValue()) {
                remoteProcessGroup.verifyCanStopTransmitting();
            }
        }
        if (!(requestValidation = this.validateProposedRemoteProcessGroupConfiguration(remoteProcessGroupDto)).isEmpty()) {
            throw new ValidationException(requestValidation);
        }
        if (this.isAnyNotNull((Object[])new Serializable[]{remoteProcessGroupDto.getYieldDuration(), remoteProcessGroupDto.getCommunicationsTimeout(), remoteProcessGroupDto.getProxyHost(), remoteProcessGroupDto.getProxyPort(), remoteProcessGroupDto.getProxyUser(), remoteProcessGroupDto.getProxyPassword()})) {
            remoteProcessGroup.verifyCanUpdate();
        }
    }

    public void verifyUpdateInputPort(String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDto) {
        RemoteProcessGroup remoteProcessGroup = this.locateRemoteProcessGroup(remoteProcessGroupId);
        RemoteGroupPort port = remoteProcessGroup.getInputPort(remoteProcessGroupPortDto.getId());
        if (port == null) {
            throw new ResourceNotFoundException(String.format("Unable to find remote process group input port with id '%s'.", remoteProcessGroupPortDto.getId()));
        }
        this.verifyUpdatePort(port, remoteProcessGroupPortDto);
    }

    public void verifyUpdateOutputPort(String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDto) {
        RemoteProcessGroup remoteProcessGroup = this.locateRemoteProcessGroup(remoteProcessGroupId);
        RemoteGroupPort port = remoteProcessGroup.getOutputPort(remoteProcessGroupPortDto.getId());
        if (port == null) {
            throw new ResourceNotFoundException(String.format("Unable to find remote process group output port with id '%s'.", remoteProcessGroupPortDto.getId()));
        }
        this.verifyUpdatePort(port, remoteProcessGroupPortDto);
    }

    private void verifyUpdatePort(RemoteGroupPort port, RemoteProcessGroupPortDTO remoteProcessGroupPortDto) {
        List requestValidation;
        if (this.isNotNull((Object)remoteProcessGroupPortDto.isTransmitting())) {
            if (!port.isRunning() && remoteProcessGroupPortDto.isTransmitting().booleanValue()) {
                port.verifyCanStart();
            } else if (port.isRunning() && !remoteProcessGroupPortDto.isTransmitting().booleanValue()) {
                port.verifyCanStop();
            }
        }
        if (!(requestValidation = this.validateProposedRemoteProcessGroupPortConfiguration(port, remoteProcessGroupPortDto)).isEmpty()) {
            throw new ValidationException(requestValidation);
        }
        if (this.isAnyNotNull((Object[])new Serializable[]{remoteProcessGroupPortDto.getConcurrentlySchedulableTaskCount(), remoteProcessGroupPortDto.getUseCompression()})) {
            port.verifyCanUpdate();
        }
    }

    private List<String> validateProposedRemoteProcessGroupPortConfiguration(RemoteGroupPort remoteGroupPort, RemoteProcessGroupPortDTO remoteProcessGroupPortDTO) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.isNotNull((Object)remoteProcessGroupPortDTO.getConcurrentlySchedulableTaskCount()) && remoteProcessGroupPortDTO.getConcurrentlySchedulableTaskCount() <= 0) {
            validationErrors.add(String.format("Concurrent tasks for port '%s' must be a positive integer.", remoteGroupPort.getName()));
        }
        return validationErrors;
    }

    private List<String> validateProposedRemoteProcessGroupConfiguration(RemoteProcessGroupDTO remoteProcessGroupDTO) {
        Matcher yieldMatcher;
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.isNotNull((Object)remoteProcessGroupDTO.getCommunicationsTimeout()) && !(yieldMatcher = FormatUtils.TIME_DURATION_PATTERN.matcher(remoteProcessGroupDTO.getCommunicationsTimeout())).matches()) {
            validationErrors.add("Communications timeout is not a valid time duration (ie 30 sec, 5 min)");
        }
        if (this.isNotNull((Object)remoteProcessGroupDTO.getYieldDuration()) && !(yieldMatcher = FormatUtils.TIME_DURATION_PATTERN.matcher(remoteProcessGroupDTO.getYieldDuration())).matches()) {
            validationErrors.add("Yield duration is not a valid time duration (ie 30 sec, 5 min)");
        }
        String proxyPassword = remoteProcessGroupDTO.getProxyPassword();
        String proxyUser = remoteProcessGroupDTO.getProxyUser();
        String proxyHost = remoteProcessGroupDTO.getProxyHost();
        if (this.isNotNull((Object)remoteProcessGroupDTO.getProxyPort()) && StringUtils.isEmpty((String)proxyHost)) {
            validationErrors.add("Proxy port was specified, but proxy host was empty.");
        }
        if (!StringUtils.isEmpty((String)proxyUser)) {
            if (StringUtils.isEmpty((String)proxyHost)) {
                validationErrors.add("Proxy user name was specified, but proxy host was empty.");
            }
            if (StringUtils.isEmpty((String)proxyPassword)) {
                validationErrors.add("User password should be specified if Proxy server needs user authentication.");
            }
        }
        if (!StringUtils.isEmpty((String)proxyPassword)) {
            if (StringUtils.isEmpty((String)proxyHost)) {
                validationErrors.add("Proxy user password was specified, but proxy host was empty.");
            }
            if (StringUtils.isEmpty((String)proxyPassword)) {
                validationErrors.add("User name should be specified if Proxy server needs user authentication.");
            }
        }
        return validationErrors;
    }

    public RemoteGroupPort updateRemoteProcessGroupInputPort(String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDto) {
        Boolean isTransmitting;
        RemoteProcessGroup remoteProcessGroup = this.locateRemoteProcessGroup(remoteProcessGroupId);
        RemoteGroupPort port = remoteProcessGroup.getInputPort(remoteProcessGroupPortDto.getId());
        if (port == null) {
            throw new ResourceNotFoundException(String.format("Unable to find remote process group input port with id '%s'.", remoteProcessGroupPortDto.getId()));
        }
        this.verifyUpdatePort(port, remoteProcessGroupPortDto);
        if (this.isNotNull((Object)remoteProcessGroupPortDto.getConcurrentlySchedulableTaskCount())) {
            port.setMaxConcurrentTasks(remoteProcessGroupPortDto.getConcurrentlySchedulableTaskCount().intValue());
        }
        if (this.isNotNull((Object)remoteProcessGroupPortDto.getUseCompression())) {
            port.setUseCompression(remoteProcessGroupPortDto.getUseCompression().booleanValue());
        }
        if (this.isNotNull((Object)(isTransmitting = remoteProcessGroupPortDto.isTransmitting()))) {
            if (!port.isRunning() && isTransmitting.booleanValue()) {
                remoteProcessGroup.startTransmitting(port);
            } else if (port.isRunning() && !isTransmitting.booleanValue()) {
                remoteProcessGroup.stopTransmitting(port);
            }
        }
        return port;
    }

    public RemoteGroupPort updateRemoteProcessGroupOutputPort(String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDto) {
        Boolean isTransmitting;
        RemoteProcessGroup remoteProcessGroup = this.locateRemoteProcessGroup(remoteProcessGroupId);
        RemoteGroupPort port = remoteProcessGroup.getOutputPort(remoteProcessGroupPortDto.getId());
        if (port == null) {
            throw new ResourceNotFoundException(String.format("Unable to find remote process group output port with id '%s'.", remoteProcessGroupId));
        }
        this.verifyUpdatePort(port, remoteProcessGroupPortDto);
        if (this.isNotNull((Object)remoteProcessGroupPortDto.getConcurrentlySchedulableTaskCount())) {
            port.setMaxConcurrentTasks(remoteProcessGroupPortDto.getConcurrentlySchedulableTaskCount().intValue());
        }
        if (this.isNotNull((Object)remoteProcessGroupPortDto.getUseCompression())) {
            port.setUseCompression(remoteProcessGroupPortDto.getUseCompression().booleanValue());
        }
        if (this.isNotNull((Object)(isTransmitting = remoteProcessGroupPortDto.isTransmitting()))) {
            if (!port.isRunning() && isTransmitting.booleanValue()) {
                remoteProcessGroup.startTransmitting(port);
            } else if (port.isRunning() && !isTransmitting.booleanValue()) {
                remoteProcessGroup.stopTransmitting(port);
            }
        }
        return port;
    }

    public RemoteProcessGroup updateRemoteProcessGroup(RemoteProcessGroupDTO remoteProcessGroupDTO) {
        RemoteProcessGroup remoteProcessGroup = this.locateRemoteProcessGroup(remoteProcessGroupDTO.getId());
        return this.updateRemoteProcessGroup(remoteProcessGroup, remoteProcessGroupDTO);
    }

    private RemoteProcessGroup updateRemoteProcessGroup(RemoteProcessGroup remoteProcessGroup, RemoteProcessGroupDTO remoteProcessGroupDTO) {
        Boolean isTransmitting;
        this.verifyUpdate(remoteProcessGroup, remoteProcessGroupDTO);
        String name = remoteProcessGroupDTO.getName();
        String comments = remoteProcessGroupDTO.getComments();
        String communicationsTimeout = remoteProcessGroupDTO.getCommunicationsTimeout();
        String yieldDuration = remoteProcessGroupDTO.getYieldDuration();
        String proxyHost = remoteProcessGroupDTO.getProxyHost();
        Integer proxyPort = remoteProcessGroupDTO.getProxyPort();
        String proxyUser = remoteProcessGroupDTO.getProxyUser();
        String proxyPassword = remoteProcessGroupDTO.getProxyPassword();
        String transportProtocol = remoteProcessGroupDTO.getTransportProtocol();
        if (this.isNotNull((Object)name)) {
            remoteProcessGroup.setName(name);
        }
        if (this.isNotNull((Object)comments)) {
            remoteProcessGroup.setComments(comments);
        }
        if (this.isNotNull((Object)communicationsTimeout)) {
            remoteProcessGroup.setCommunicationsTimeout(communicationsTimeout);
        }
        if (this.isNotNull((Object)yieldDuration)) {
            remoteProcessGroup.setYieldDuration(yieldDuration);
        }
        if (this.isNotNull((Object)remoteProcessGroupDTO.getPosition())) {
            remoteProcessGroup.setPosition(new Position(remoteProcessGroupDTO.getPosition().getX().doubleValue(), remoteProcessGroupDTO.getPosition().getY().doubleValue()));
        }
        if (this.isNotNull((Object)transportProtocol)) {
            remoteProcessGroup.setTransportProtocol(SiteToSiteTransportProtocol.valueOf((String)transportProtocol.toUpperCase()));
            remoteProcessGroup.setProxyHost(proxyHost);
            remoteProcessGroup.setProxyPort(proxyPort);
            remoteProcessGroup.setProxyUser(proxyUser);
            if (this.isNotNull((Object)proxyPassword) && !"********".equals(proxyPassword)) {
                remoteProcessGroup.setProxyPassword(proxyPassword);
            }
        }
        if (this.isNotNull((Object)(isTransmitting = remoteProcessGroupDTO.isTransmitting()))) {
            if (!remoteProcessGroup.isTransmitting() && isTransmitting.booleanValue()) {
                remoteProcessGroup.startTransmitting();
            } else if (remoteProcessGroup.isTransmitting() && !isTransmitting.booleanValue()) {
                remoteProcessGroup.stopTransmitting();
            }
        }
        return remoteProcessGroup;
    }

    public void verifyDelete(String remoteProcessGroupId) {
        RemoteProcessGroup remoteProcessGroup = this.locateRemoteProcessGroup(remoteProcessGroupId);
        remoteProcessGroup.verifyCanDelete();
    }

    public void deleteRemoteProcessGroup(String remoteProcessGroupId) {
        RemoteProcessGroup remoteProcessGroup = this.locateRemoteProcessGroup(remoteProcessGroupId);
        remoteProcessGroup.getProcessGroup().removeRemoteProcessGroup(remoteProcessGroup);
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

