/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.Set;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.dao.FunnelDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;

public class StandardFunnelDAO
extends ComponentDAO
implements FunnelDAO {
    private FlowController flowController;

    private Funnel locateFunnel(String funnelId) {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        Funnel funnel = rootGroup.findFunnel(funnelId);
        if (funnel == null) {
            throw new ResourceNotFoundException(String.format("Unable to find funnel with id '%s'.", funnelId));
        }
        return funnel;
    }

    public boolean hasFunnel(String funnelId) {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        return rootGroup.findFunnel(funnelId) != null;
    }

    public Funnel createFunnel(String groupId, FunnelDTO funnelDTO) {
        if (funnelDTO.getParentGroupId() != null && !this.flowController.areGroupsSame(groupId, funnelDTO.getParentGroupId())) {
            throw new IllegalArgumentException("Cannot specify a different Parent Group ID than the Group to which the Funnel is being added.");
        }
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        Funnel funnel = this.flowController.createFunnel(funnelDTO.getId());
        if (funnelDTO.getPosition() != null) {
            funnel.setPosition(new Position(funnelDTO.getPosition().getX().doubleValue(), funnelDTO.getPosition().getY().doubleValue()));
        }
        group.addFunnel(funnel);
        group.startFunnel(funnel);
        return funnel;
    }

    public Funnel getFunnel(String funnelId) {
        return this.locateFunnel(funnelId);
    }

    public Set<Funnel> getFunnels(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        return group.getFunnels();
    }

    public Funnel updateFunnel(FunnelDTO funnelDTO) {
        Funnel funnel = this.locateFunnel(funnelDTO.getId());
        if (this.isNotNull((Object)funnelDTO.getPosition()) && funnelDTO.getPosition() != null) {
            funnel.setPosition(new Position(funnelDTO.getPosition().getX().doubleValue(), funnelDTO.getPosition().getY().doubleValue()));
        }
        return funnel;
    }

    public void verifyDelete(String funnelId) {
        Funnel funnel = this.locateFunnel(funnelId);
        funnel.verifyCanDelete();
    }

    public void deleteFunnel(String funnelId) {
        Funnel funnel = this.locateFunnel(funnelId);
        funnel.getProcessGroup().removeFunnel(funnel);
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

