/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.contextlistener;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.repository.RepositoryPurgeException;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.NiFiCoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ApplicationStartupContextListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationStartupContextListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
        NiFiProperties properties = (NiFiProperties)ctx.getBean("nifiProperties", NiFiProperties.class);
        FlowService flowService = null;
        try {
            flowService = (FlowService)ctx.getBean("flowService", FlowService.class);
            FlowController flowController = (FlowController)ctx.getBean("flowController", FlowController.class);
            if (!properties.isNode()) {
                logger.info("Starting Flow Controller...");
                flowService.start();
                flowService.load(null);
                flowController.onFlowInitialized(properties.getAutoResumeState());
                logger.info("Flow Controller started successfully.");
            }
        }
        catch (IOException | RepositoryPurgeException | BeansException e) {
            RequestReplicator requestReplicator;
            if (flowService != null && flowService.isRunning()) {
                flowService.stop(false);
            }
            if ((requestReplicator = (RequestReplicator)ctx.getBean("requestReplicator", RequestReplicator.class)) != null) {
                requestReplicator.shutdown();
            }
            throw new NiFiCoreException("Unable to start Flow Controller.", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
        try {
            RequestReplicator requestReplicator;
            logger.info("Initiating shutdown of flow service...");
            FlowService flowService = (FlowService)ctx.getBean("flowService", FlowService.class);
            if (flowService.isRunning()) {
                flowService.stop(false);
            }
            if ((requestReplicator = (RequestReplicator)ctx.getBean("requestReplicator", RequestReplicator.class)) != null) {
                requestReplicator.shutdown();
            }
            logger.info("Flow service termination completed.");
        }
        catch (Exception e) {
            String msg = "Problem occurred ensuring flow controller or repository was properly terminated due to " + e;
            if (logger.isDebugEnabled()) {
                logger.warn(msg, (Throwable)e);
            }
            logger.warn(msg);
        }
    }
}

