/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AbstractPolicyBasedAuthorizer;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.TenantDTO;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.entity.ClusterSearchResultsEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.api.entity.TenantsEntity;
import org.apache.nifi.web.api.entity.UserEntity;
import org.apache.nifi.web.api.entity.UserGroupEntity;
import org.apache.nifi.web.api.entity.UserGroupsEntity;
import org.apache.nifi.web.api.entity.UsersEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="tenants")
@Api(value="tenants", description="Endpoint for managing users and user groups.")
public class TenantsResource
extends ApplicationResource {
    private final NiFiServiceFacade serviceFacade;
    private final Authorizer authorizer;

    public TenantsResource(NiFiServiceFacade serviceFacade, Authorizer authorizer, NiFiProperties properties, RequestReplicator requestReplicator, ClusterCoordinator clusterCoordinator) {
        this.serviceFacade = serviceFacade;
        this.authorizer = authorizer;
        this.setProperties(properties);
        this.setRequestReplicator(requestReplicator);
        this.setClusterCoordinator(clusterCoordinator);
    }

    public Set<UserEntity> populateRemainingUserEntitiesContent(Set<UserEntity> userEntities) {
        for (UserEntity userEntity : userEntities) {
            this.populateRemainingUserEntityContent(userEntity);
        }
        return userEntities;
    }

    public UserEntity populateRemainingUserEntityContent(UserEntity userEntity) {
        userEntity.setUri(this.generateResourceUri(new String[]{"tenants", "users", userEntity.getId()}));
        return userEntity;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="users")
    @ApiOperation(value="Creates a user", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UserEntity.class, authorizations={@Authorization(value="Write - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createUser(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The user configuration details.", required=true) UserEntity requestUserEntity) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (requestUserEntity == null || requestUserEntity.getComponent() == null) {
            throw new IllegalArgumentException("User details must be specified.");
        }
        if (requestUserEntity.getRevision() == null || requestUserEntity.getRevision().getVersion() == null || requestUserEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new User.");
        }
        if (requestUserEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("User ID cannot be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestUserEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestUserEntity, lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, userEntity -> {
            userEntity.getComponent().setId(this.generateUuid());
            RevisionDTO revisionDTO = userEntity.getRevision();
            Revision revision = new Revision(revisionDTO.getVersion(), revisionDTO.getClientId(), userEntity.getComponent().getId());
            UserEntity entity = this.serviceFacade.createUser(revision, userEntity.getComponent());
            this.populateRemainingUserEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="users/{id}")
    @ApiOperation(value="Gets a user", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UserEntity.class, authorizations={@Authorization(value="Read - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getUser(@ApiParam(value="The user id.", required=true) @PathParam(value="id") String id) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        UserEntity entity = this.serviceFacade.getUser(id);
        this.populateRemainingUserEntityContent(entity);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="users")
    @ApiOperation(value="Gets all users", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UsersEntity.class, authorizations={@Authorization(value="Read - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getUsers() {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set users = this.serviceFacade.getUsers();
        UsersEntity entity = new UsersEntity();
        entity.setGenerated(new Date());
        entity.setUsers((Collection)this.populateRemainingUserEntitiesContent(users));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="users/{id}")
    @ApiOperation(value="Updates a user", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UserEntity.class, authorizations={@Authorization(value="Write - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateUser(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The user id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The user configuration details.", required=true) UserEntity requestUserEntity) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (requestUserEntity == null || requestUserEntity.getComponent() == null) {
            throw new IllegalArgumentException("User details must be specified.");
        }
        if (requestUserEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        UserDTO requestUserDTO = requestUserEntity.getComponent();
        if (!id.equals(requestUserDTO.getId())) {
            throw new IllegalArgumentException(String.format("The user id (%s) in the request body does not equal the user id of the requested resource (%s).", requestUserDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestUserEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestUserEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestUserEntity, requestRevision, lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, userEntity) -> {
            UserEntity entity = this.serviceFacade.updateUser(revision, userEntity.getComponent());
            this.populateRemainingUserEntityContent(entity);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="users/{id}")
    @ApiOperation(value="Deletes a user", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UserEntity.class, authorizations={@Authorization(value="Write - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeUser(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The user id.", required=true) @PathParam(value="id") String id) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        UserEntity requestUserEntity = new UserEntity();
        requestUserEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestUserEntity, requestRevision, lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, userEntity) -> {
            UserEntity entity = this.serviceFacade.deleteUser(revision, userEntity.getId());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    public Set<UserGroupEntity> populateRemainingUserGroupEntitiesContent(Set<UserGroupEntity> userGroupEntities) {
        for (UserGroupEntity userGroupEntity : userGroupEntities) {
            this.populateRemainingUserGroupEntityContent(userGroupEntity);
        }
        return userGroupEntities;
    }

    public UserGroupEntity populateRemainingUserGroupEntityContent(UserGroupEntity userGroupEntity) {
        userGroupEntity.setUri(this.generateResourceUri(new String[]{"tenants", "user-groups", userGroupEntity.getId()}));
        return userGroupEntity;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="user-groups")
    @ApiOperation(value="Creates a user group", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UserGroupEntity.class, authorizations={@Authorization(value="Write - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createUserGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The user group configuration details.", required=true) UserGroupEntity requestUserGroupEntity) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (requestUserGroupEntity == null || requestUserGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("User group details must be specified.");
        }
        if (requestUserGroupEntity.getRevision() == null || requestUserGroupEntity.getRevision().getVersion() == null || requestUserGroupEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new User Group.");
        }
        if (requestUserGroupEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("User group ID cannot be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestUserGroupEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestUserGroupEntity, lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, userGroupEntity -> {
            userGroupEntity.getComponent().setId(this.generateUuid());
            RevisionDTO revisionDTO = userGroupEntity.getRevision();
            Revision revision = new Revision(revisionDTO.getVersion(), revisionDTO.getClientId(), userGroupEntity.getComponent().getId());
            UserGroupEntity entity = this.serviceFacade.createUserGroup(revision, userGroupEntity.getComponent());
            this.populateRemainingUserGroupEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="user-groups/{id}")
    @ApiOperation(value="Gets a user group", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UserGroupEntity.class, authorizations={@Authorization(value="Read - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getUserGroup(@ApiParam(value="The user group id.", required=true) @PathParam(value="id") String id) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        UserGroupEntity entity = this.serviceFacade.getUserGroup(id);
        this.populateRemainingUserGroupEntityContent(entity);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="user-groups")
    @ApiOperation(value="Gets all user groups", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UserGroupsEntity.class, authorizations={@Authorization(value="Read - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getUserGroups() {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set users = this.serviceFacade.getUserGroups();
        UserGroupsEntity entity = new UserGroupsEntity();
        entity.setUserGroups((Collection)this.populateRemainingUserGroupEntitiesContent(users));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="user-groups/{id}")
    @ApiOperation(value="Updates a user group", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UserGroupEntity.class, authorizations={@Authorization(value="Write - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateUserGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The user group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The user group configuration details.", required=true) UserGroupEntity requestUserGroupEntity) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (requestUserGroupEntity == null || requestUserGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("User group details must be specified.");
        }
        if (requestUserGroupEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        UserGroupDTO requestUserGroupDTO = requestUserGroupEntity.getComponent();
        if (!id.equals(requestUserGroupDTO.getId())) {
            throw new IllegalArgumentException(String.format("The user group id (%s) in the request body does not equal the user group id of the requested resource (%s).", requestUserGroupDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestUserGroupEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestUserGroupEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestUserGroupEntity, requestRevision, lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, userGroupEntity) -> {
            UserGroupEntity entity = this.serviceFacade.updateUserGroup(revision, userGroupEntity.getComponent());
            this.populateRemainingUserGroupEntityContent(entity);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="user-groups/{id}")
    @ApiOperation(value="Deletes a user group", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=UserGroupEntity.class, authorizations={@Authorization(value="Write - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeUserGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The user group id.", required=true) @PathParam(value="id") String id) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        UserGroupEntity requestUserGroupEntity = new UserGroupEntity();
        requestUserGroupEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestUserGroupEntity, requestRevision, lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, userGroupEntity) -> {
            UserGroupEntity entity = this.serviceFacade.deleteUserGroup(revision, userGroupEntity.getId());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="search-results")
    @ApiOperation(value="Searches the cluster for a node with the specified address", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ClusterSearchResultsEntity.class, authorizations={@Authorization(value="Read - /tenants", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response searchCluster(@ApiParam(value="Node address to search for.", required=true) @QueryParam(value="q") @DefaultValue(value="") String value) {
        TenantEntity entity;
        TenantDTO tenant;
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable tenants = lookup.getTenant();
            tenants.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ArrayList<TenantEntity> userMatches = new ArrayList<TenantEntity>();
        ArrayList<TenantEntity> userGroupMatches = new ArrayList<TenantEntity>();
        for (UserEntity userEntity : this.serviceFacade.getUsers()) {
            UserDTO user = userEntity.getComponent();
            if (!StringUtils.isBlank((CharSequence)value) && !StringUtils.containsIgnoreCase((CharSequence)user.getIdentity(), (CharSequence)value)) continue;
            tenant = new TenantDTO();
            tenant.setId(user.getId());
            tenant.setIdentity(user.getIdentity());
            entity = new TenantEntity();
            entity.setPermissions(userEntity.getPermissions());
            entity.setId(userEntity.getId());
            entity.setComponent(tenant);
            userMatches.add(entity);
        }
        for (UserGroupEntity userGroupEntity : this.serviceFacade.getUserGroups()) {
            UserGroupDTO userGroup = userGroupEntity.getComponent();
            if (!StringUtils.isBlank((CharSequence)value) && !StringUtils.containsIgnoreCase((CharSequence)userGroup.getIdentity(), (CharSequence)value)) continue;
            tenant = new TenantDTO();
            tenant.setId(userGroup.getId());
            tenant.setIdentity(userGroup.getIdentity());
            entity = new TenantEntity();
            entity.setPermissions(userGroupEntity.getPermissions());
            entity.setId(userGroupEntity.getId());
            entity.setComponent(tenant);
            userGroupMatches.add(entity);
        }
        TenantsEntity results = new TenantsEntity();
        results.setUsers(userMatches);
        results.setUserGroups(userGroupMatches);
        return this.noCache(Response.ok((Object)results)).build();
    }
}

