/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.persistence.TemplateSerializer;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.TemplateEntity;

@Path(value="/templates")
@Api(value="/templates", description="Endpoint for managing a Template.")
public class TemplateResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<TemplateEntity> populateRemainingTemplateEntitiesContent(Set<TemplateEntity> templateEntities) {
        for (TemplateEntity templateEntity : templateEntities) {
            if (templateEntity.getTemplate() == null) continue;
            this.populateRemainingTemplateContent(templateEntity.getTemplate());
        }
        return templateEntities;
    }

    public TemplateDTO populateRemainingTemplateContent(TemplateDTO template) {
        template.setUri(this.generateResourceUri(new String[]{"templates", template.getId()}));
        return template;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/xml"})
    @Path(value="{id}/download")
    @ApiOperation(value="Exports a template", response=TemplateDTO.class, authorizations={@Authorization(value="Read - /templates/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response exportTemplate(@ApiParam(value="The template id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable template = lookup.getTemplate(id);
            template.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        TemplateDTO template = this.serviceFacade.exportTemplate(id);
        template.setId(null);
        String attachmentName = template.getName();
        attachmentName = StringUtils.isBlank((CharSequence)attachmentName) ? "template" : attachmentName.replaceAll("\\s", "_");
        String serializedTemplate = new String(TemplateSerializer.serialize((TemplateDTO)template), StandardCharsets.UTF_8);
        return this.generateOkResponse((Object)serializedTemplate).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s.xml\"", attachmentName)).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a template", response=TemplateEntity.class, authorizations={@Authorization(value="Write - /templates/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeTemplate(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The template id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        TemplateEntity requestTemplateEntity = new TemplateEntity();
        requestTemplateEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestTemplateEntity, lookup -> {
            Authorizable template = lookup.getTemplate(id);
            template.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, templateEntity -> {
            this.serviceFacade.deleteTemplate(templateEntity.getId());
            TemplateEntity entity = new TemplateEntity();
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

