/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.net.URI;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupPortEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/remote-process-groups")
@Api(value="/remote-process-groups", description="Endpoint for managing a Remote Process Group.")
public class RemoteProcessGroupResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<RemoteProcessGroupEntity> populateRemainingRemoteProcessGroupEntitiesContent(Set<RemoteProcessGroupEntity> remoteProcessGroupEntities) {
        for (RemoteProcessGroupEntity remoteProcessEntities : remoteProcessGroupEntities) {
            this.populateRemainingRemoteProcessGroupEntityContent(remoteProcessEntities);
        }
        return remoteProcessGroupEntities;
    }

    public RemoteProcessGroupEntity populateRemainingRemoteProcessGroupEntityContent(RemoteProcessGroupEntity remoteProcessGroupEntity) {
        remoteProcessGroupEntity.setUri(this.generateResourceUri(new String[]{"remote-process-groups", remoteProcessGroupEntity.getId()}));
        return remoteProcessGroupEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a remote process group", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Read - /remote-process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRemoteProcessGroup(@ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable remoteProcessGroup = lookup.getRemoteProcessGroup(id);
            remoteProcessGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        RemoteProcessGroupEntity entity = this.serviceFacade.getRemoteProcessGroup(id);
        this.populateRemainingRemoteProcessGroupEntityContent(entity);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a remote process group", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeRemoteProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        RemoteProcessGroupEntity requestRemoteProcessGroupEntity = new RemoteProcessGroupEntity();
        requestRemoteProcessGroupEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupEntity, requestRevision, lookup -> {
            Authorizable remoteProcessGroup = lookup.getRemoteProcessGroup(id);
            remoteProcessGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyDeleteRemoteProcessGroup(id), (revision, remoteProcessGroupEntity) -> {
            RemoteProcessGroupEntity entity = this.serviceFacade.deleteRemoteProcessGroup(revision, remoteProcessGroupEntity.getId());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/input-ports/{port-id}")
    @ApiOperation(value="Updates a remote port", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=RemoteProcessGroupPortEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroupInputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The remote process group port id.", required=true) @PathParam(value="port-id") String portId, @ApiParam(value="The remote process group port.", required=true) RemoteProcessGroupPortEntity requestRemoteProcessGroupPortEntity) {
        if (requestRemoteProcessGroupPortEntity == null || requestRemoteProcessGroupPortEntity.getRemoteProcessGroupPort() == null) {
            throw new IllegalArgumentException("Remote process group port details must be specified.");
        }
        if (requestRemoteProcessGroupPortEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        RemoteProcessGroupPortDTO requestRemoteProcessGroupPort = requestRemoteProcessGroupPortEntity.getRemoteProcessGroupPort();
        if (!portId.equals(requestRemoteProcessGroupPort.getId())) {
            throw new IllegalArgumentException(String.format("The remote process group port id (%s) in the request body does not equal the remote process group port id of the requested resource (%s).", requestRemoteProcessGroupPort.getId(), portId));
        }
        if (!id.equals(requestRemoteProcessGroupPort.getGroupId())) {
            throw new IllegalArgumentException(String.format("The remote process group id (%s) in the request body does not equal the remote process group id of the requested resource (%s).", requestRemoteProcessGroupPort.getGroupId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemoteProcessGroupPortEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestRemoteProcessGroupPortEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupPortEntity, requestRevision, lookup -> {
            Authorizable remoteProcessGroupInputPort = lookup.getRemoteProcessGroupInputPort(id, portId);
            remoteProcessGroupInputPort.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroupInputPort(id, requestRemoteProcessGroupPort), (revision, remoteProcessGroupPortEntity) -> {
            RemoteProcessGroupPortDTO remoteProcessGroupPort = remoteProcessGroupPortEntity.getRemoteProcessGroupPort();
            RemoteProcessGroupPortEntity controllerResponse = this.serviceFacade.updateRemoteProcessGroupInputPort(revision, remoteProcessGroupPort.getId(), remoteProcessGroupPort);
            RevisionDTO updatedRevision = controllerResponse.getRevision();
            RemoteProcessGroupPortEntity entity = new RemoteProcessGroupPortEntity();
            entity.setRevision(updatedRevision);
            entity.setRemoteProcessGroupPort(controllerResponse.getRemoteProcessGroupPort());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/output-ports/{port-id}")
    @ApiOperation(value="Updates a remote port", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=RemoteProcessGroupPortEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroupOutputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The remote process group port id.", required=true) @PathParam(value="port-id") String portId, @ApiParam(value="The remote process group port.", required=true) RemoteProcessGroupPortEntity requestRemoteProcessGroupPortEntity) {
        if (requestRemoteProcessGroupPortEntity == null || requestRemoteProcessGroupPortEntity.getRemoteProcessGroupPort() == null) {
            throw new IllegalArgumentException("Remote process group port details must be specified.");
        }
        if (requestRemoteProcessGroupPortEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        RemoteProcessGroupPortDTO requestRemoteProcessGroupPort = requestRemoteProcessGroupPortEntity.getRemoteProcessGroupPort();
        if (!portId.equals(requestRemoteProcessGroupPort.getId())) {
            throw new IllegalArgumentException(String.format("The remote process group port id (%s) in the request body does not equal the remote process group port id of the requested resource (%s).", requestRemoteProcessGroupPort.getId(), portId));
        }
        if (!id.equals(requestRemoteProcessGroupPort.getGroupId())) {
            throw new IllegalArgumentException(String.format("The remote process group id (%s) in the request body does not equal the remote process group id of the requested resource (%s).", requestRemoteProcessGroupPort.getGroupId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemoteProcessGroupPortEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestRemoteProcessGroupPortEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupPortEntity, requestRevision, lookup -> {
            Authorizable remoteProcessGroupOutputPort = lookup.getRemoteProcessGroupOutputPort(id, portId);
            remoteProcessGroupOutputPort.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroupOutputPort(id, requestRemoteProcessGroupPort), (revision, remoteProcessGroupPortEntity) -> {
            RemoteProcessGroupPortDTO remoteProcessGroupPort = remoteProcessGroupPortEntity.getRemoteProcessGroupPort();
            RemoteProcessGroupPortEntity controllerResponse = this.serviceFacade.updateRemoteProcessGroupOutputPort(revision, remoteProcessGroupPort.getId(), remoteProcessGroupPort);
            RevisionDTO updatedRevision = controllerResponse.getRevision();
            RemoteProcessGroupPortEntity entity = new RemoteProcessGroupPortEntity();
            entity.setRevision(updatedRevision);
            entity.setRemoteProcessGroupPort(controllerResponse.getRemoteProcessGroupPort());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a remote process group", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The remote process group.", required=true) RemoteProcessGroupEntity requestRemoteProcessGroupEntity) {
        if (requestRemoteProcessGroupEntity == null || requestRemoteProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Remote process group details must be specified.");
        }
        if (requestRemoteProcessGroupEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        RemoteProcessGroupDTO requestRemoteProcessGroup = requestRemoteProcessGroupEntity.getComponent();
        if (!id.equals(requestRemoteProcessGroup.getId())) {
            throw new IllegalArgumentException(String.format("The remote process group id (%s) in the request body does not equal the remote process group id of the requested resource (%s).", requestRemoteProcessGroup.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemoteProcessGroupEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestRemoteProcessGroupEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getRemoteProcessGroup(id);
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroup(requestRemoteProcessGroup), (revision, remoteProcessGroupEntity) -> {
            RemoteProcessGroupDTO remoteProcessGroup = remoteProcessGroupEntity.getComponent();
            if (remoteProcessGroup.getTargetUri() != null) {
                URI uri;
                try {
                    uri = URI.create(remoteProcessGroup.getTargetUri());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("The specified remote process group URL is malformed: " + remoteProcessGroup.getTargetUri());
                }
                if (uri.getScheme() == null || uri.getHost() == null) {
                    throw new IllegalArgumentException("The specified remote process group URL is malformed: " + remoteProcessGroup.getTargetUri());
                }
                if (!uri.getScheme().equalsIgnoreCase("http") && !uri.getScheme().equalsIgnoreCase("https")) {
                    throw new IllegalArgumentException("The specified remote process group URL is invalid because it is not http or https: " + remoteProcessGroup.getTargetUri());
                }
                String controllerUri = uri.toString();
                if (controllerUri.endsWith("/")) {
                    controllerUri = StringUtils.substringBeforeLast((String)controllerUri, (String)"/");
                }
                remoteProcessGroup.setTargetUri(controllerUri);
            }
            RemoteProcessGroupEntity entity = this.serviceFacade.updateRemoteProcessGroup(revision, remoteProcessGroup);
            this.populateRemainingRemoteProcessGroupEntityContent(entity);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

