/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ControllerServiceReferencingComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentsEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.UpdateControllerServiceReferenceRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/controller-services")
@Api(value="/controller-services", description="Endpoint for managing a Controller Service.")
public class ControllerServiceResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ControllerServiceResource.class);
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    @Context
    private ServletContext servletContext;

    public Set<ControllerServiceEntity> populateRemainingControllerServiceEntitiesContent(Set<ControllerServiceEntity> controllerServiceEntities) {
        for (ControllerServiceEntity controllerServiceEntity : controllerServiceEntities) {
            this.populateRemainingControllerServiceEntityContent(controllerServiceEntity);
        }
        return controllerServiceEntities;
    }

    public ControllerServiceEntity populateRemainingControllerServiceEntityContent(ControllerServiceEntity controllerServiceEntity) {
        controllerServiceEntity.setUri(this.generateResourceUri(new String[]{"controller-services", controllerServiceEntity.getId()}));
        if (controllerServiceEntity.getComponent() != null) {
            this.populateRemainingControllerServiceContent(controllerServiceEntity.getComponent());
        }
        return controllerServiceEntity;
    }

    public ControllerServiceDTO populateRemainingControllerServiceContent(ControllerServiceDTO controllerService) {
        UiExtensionMapping uiExtensionMapping = (UiExtensionMapping)this.servletContext.getAttribute("nifi-ui-extensions");
        if (uiExtensionMapping.hasUiExtension(controllerService.getType())) {
            List uiExtensions = uiExtensionMapping.getUiExtension(controllerService.getType());
            for (UiExtension uiExtension : uiExtensions) {
                if (!UiExtensionType.ControllerServiceConfiguration.equals((Object)uiExtension.getExtensionType())) continue;
                controllerService.setCustomUiUrl(uiExtension.getContextPath() + "/configure");
            }
        }
        return controllerService;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Read - /controller-services/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerService(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ControllerServiceEntity entity = this.serviceFacade.getControllerService(id);
        this.populateRemainingControllerServiceEntityContent(entity);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/descriptors")
    @ApiOperation(value="Gets a controller service property descriptor", response=PropertyDescriptorEntity.class, authorizations={@Authorization(value="Read - /controller-services/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getPropertyDescriptor(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The property name to return the descriptor for.", required=true) @QueryParam(value="propertyName") String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        PropertyDescriptorDTO descriptor = this.serviceFacade.getControllerServicePropertyDescriptor(id, propertyName);
        PropertyDescriptorEntity entity = new PropertyDescriptorEntity();
        entity.setPropertyDescriptor(descriptor);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state")
    @ApiOperation(value="Gets the state for a controller service", response=ComponentStateDTO.class, authorizations={@Authorization(value="Write - /controller-services/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getState(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        ComponentStateDTO state = this.serviceFacade.getControllerServiceState(id);
        ComponentStateEntity entity = new ComponentStateEntity();
        entity.setComponentState(state);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state/clear-requests")
    @ApiOperation(value="Clears the state for a controller service", response=ComponentStateDTO.class, authorizations={@Authorization(value="Write - /controller-services/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response clearState(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ControllerServiceEntity requestControllerServiceEntity = new ControllerServiceEntity();
        requestControllerServiceEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanClearControllerServiceState(id), controllerServiceEntity -> {
            this.serviceFacade.clearControllerServiceState(controllerServiceEntity.getId());
            ComponentStateEntity entity = new ComponentStateEntity();
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/references")
    @ApiOperation(value="Gets a controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Read - /controller-services/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerServiceReferences(@ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ControllerServiceReferencingComponentsEntity entity = this.serviceFacade.getControllerServiceReferencingComponents(id);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/references")
    @ApiOperation(value="Updates a controller services references", response=ControllerServiceReferencingComponentsEntity.class, authorizations={@Authorization(value="Write - /{component-type}/{uuid} - For each referencing component specified", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateControllerServiceReferences(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The controller service request update request.", required=true) UpdateControllerServiceReferenceRequestEntity requestUpdateReferenceRequest) {
        if (requestUpdateReferenceRequest.getId() == null) {
            throw new IllegalArgumentException("The controller service identifier must be specified.");
        }
        if (requestUpdateReferenceRequest.getReferencingComponentRevisions() == null) {
            throw new IllegalArgumentException("The controller service referencing components revisions must be specified.");
        }
        ControllerServiceState requestControllerServiceState = null;
        try {
            requestControllerServiceState = ControllerServiceState.valueOf((String)requestUpdateReferenceRequest.getState());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ScheduledState requestScheduledState = null;
        try {
            requestScheduledState = ScheduledState.valueOf((String)requestUpdateReferenceRequest.getState());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (requestScheduledState == null && requestControllerServiceState == null) {
            throw new IllegalArgumentException("Must specify the updated state. To update referencing Processors and Reporting Tasks the state should be RUNNING or STOPPED. To update the referencing Controller Services the state should be ENABLED or DISABLED.");
        }
        if (requestControllerServiceState != null && (ControllerServiceState.ENABLING.equals((Object)requestControllerServiceState) || ControllerServiceState.DISABLING.equals((Object)requestControllerServiceState))) {
            throw new IllegalArgumentException("Cannot set the referencing services to ENABLING or DISABLING");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestUpdateReferenceRequest);
        }
        Map<String, Revision> requestReferencingRevisions = requestUpdateReferenceRequest.getReferencingComponentRevisions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            RevisionDTO rev = (RevisionDTO)e.getValue();
            return new Revision(rev.getVersion(), rev.getClientId(), (String)e.getKey());
        }));
        HashSet<Revision> requestRevisions = new HashSet<Revision>(requestReferencingRevisions.values());
        ScheduledState verifyScheduledState = requestScheduledState;
        ControllerServiceState verifyControllerServiceState = requestControllerServiceState;
        return this.withWriteLock(this.serviceFacade, (Entity)requestUpdateReferenceRequest, requestRevisions, lookup -> requestReferencingRevisions.entrySet().stream().forEach(e -> {
            Authorizable controllerService = lookup.getControllerServiceReferencingComponent(id, (String)e.getKey());
            controllerService.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }), () -> this.serviceFacade.verifyUpdateControllerServiceReferencingComponents(requestUpdateReferenceRequest.getId(), verifyScheduledState, verifyControllerServiceState), (revisions, updateReferenceRequest) -> {
            ScheduledState scheduledState = null;
            try {
                scheduledState = ScheduledState.valueOf((String)updateReferenceRequest.getState());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ControllerServiceState controllerServiceState = null;
            try {
                controllerServiceState = ControllerServiceState.valueOf((String)updateReferenceRequest.getState());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Map<String, Revision> referencingRevisions = updateReferenceRequest.getReferencingComponentRevisions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                RevisionDTO rev = (RevisionDTO)e.getValue();
                return new Revision(rev.getVersion(), rev.getClientId(), (String)e.getKey());
            }));
            ControllerServiceReferencingComponentsEntity entity = this.serviceFacade.updateControllerServiceReferencingComponents(referencingRevisions, updateReferenceRequest.getId(), scheduledState, controllerServiceState);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Write - /controller-services/{uuid}", type=""), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateControllerService(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The controller service configuration details.", required=true) ControllerServiceEntity requestControllerServiceEntity) {
        if (requestControllerServiceEntity == null || requestControllerServiceEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller service details must be specified.");
        }
        if (requestControllerServiceEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ControllerServiceDTO requestControllerServiceDTO = requestControllerServiceEntity.getComponent();
        if (!id.equals(requestControllerServiceDTO.getId())) {
            throw new IllegalArgumentException(String.format("The controller service id (%s) in the request body does not equal the controller service id of the requested resource (%s).", requestControllerServiceDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestControllerServiceEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestControllerServiceEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, requestRevision, lookup -> {
            ControllerServiceReferencingComponentAuthorizable authorizable = lookup.getControllerService(id);
            authorizable.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestControllerServiceDTO.getProperties(), (ControllerServiceReferencingComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
        }, () -> this.serviceFacade.verifyUpdateControllerService(requestControllerServiceDTO), (revision, controllerServiceEntity) -> {
            ControllerServiceDTO controllerService = controllerServiceEntity.getComponent();
            ControllerServiceEntity entity = this.serviceFacade.updateControllerService(revision, controllerService);
            this.populateRemainingControllerServiceEntityContent(entity);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Write - /controller-services/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeControllerService(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The controller service id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        ControllerServiceEntity requestControllerServiceEntity = new ControllerServiceEntity();
        requestControllerServiceEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, requestRevision, lookup -> {
            Authorizable controllerService = lookup.getControllerService(id).getAuthorizable();
            controllerService.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyDeleteControllerService(id), (revision, controllerServiceEntity) -> {
            ControllerServiceEntity entity = this.serviceFacade.deleteControllerService(revision, controllerServiceEntity.getId());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

