/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.AbstractPolicyBasedAuthorizer;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/policies")
@Api(value="/policies", description="Endpoint for managing access policies.")
public class AccessPolicyResource
extends ApplicationResource {
    private final NiFiServiceFacade serviceFacade;
    private final Authorizer authorizer;

    public AccessPolicyResource(NiFiServiceFacade serviceFacade, Authorizer authorizer, NiFiProperties properties, RequestReplicator requestReplicator, ClusterCoordinator clusterCoordinator) {
        this.serviceFacade = serviceFacade;
        this.authorizer = authorizer;
        this.setProperties(properties);
        this.setRequestReplicator(requestReplicator);
        this.setClusterCoordinator(clusterCoordinator);
    }

    public AccessPolicyEntity populateRemainingAccessPolicyEntityContent(AccessPolicyEntity accessPolicyEntity) {
        accessPolicyEntity.setUri(this.generateResourceUri(new String[]{"policies", accessPolicyEntity.getId()}));
        return accessPolicyEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{action}/{resource: .+}")
    @ApiOperation(value="Gets an access policy for the specified action and resource", notes="Will return the effective policy if no component specific policy exists for the specified action and resource. Must have Read permissions to the policy with the desired action and resource. Permissions for the policy that is returned will be indicated in the response. This means the client could be authorized to get the policy for a given component but the effective policy may be inherited from an ancestor Process Group. If the client does not have permissions to that policy, the response will not include the policy and the permissions in the response will be marked accordingly. If the client does not have permissions to the policy of the desired action and resource a 403 response will be returned.", response=AccessPolicyEntity.class, authorizations={@Authorization(value="Read - /policies/{resource}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getAccessPolicyForResource(@ApiParam(value="The request action.", allowableValues="read, write", required=true) @PathParam(value="action") String action, @ApiParam(value="The resource of the policy.", required=true) @PathParam(value="resource") String rawResource) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        RequestAction requestAction = RequestAction.valueOfValue((String)action);
        String resource = "/" + rawResource;
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable accessPolicy = lookup.getAccessPolicyByResource(resource);
            accessPolicy.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        AccessPolicyEntity entity = this.serviceFacade.getAccessPolicy(requestAction, resource);
        this.populateRemainingAccessPolicyEntityContent(entity);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates an access policy", response=AccessPolicyEntity.class, authorizations={@Authorization(value="Write - /policies/{resource}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createAccessPolicy(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The access policy configuration details.", required=true) AccessPolicyEntity requestAccessPolicyEntity) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (requestAccessPolicyEntity == null || requestAccessPolicyEntity.getComponent() == null) {
            throw new IllegalArgumentException("Access policy details must be specified.");
        }
        if (requestAccessPolicyEntity.getRevision() == null || requestAccessPolicyEntity.getRevision().getVersion() == null || requestAccessPolicyEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Policy.");
        }
        AccessPolicyDTO requestAccessPolicy = requestAccessPolicyEntity.getComponent();
        if (requestAccessPolicy.getId() != null) {
            throw new IllegalArgumentException("Access policy ID cannot be specified.");
        }
        if (requestAccessPolicy.getResource() == null) {
            throw new IllegalArgumentException("Access policy resource must be specified.");
        }
        RequestAction.valueOfValue((String)requestAccessPolicy.getAction());
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestAccessPolicyEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestAccessPolicyEntity, lookup -> {
            Authorizable accessPolicies = lookup.getAccessPolicyByResource(requestAccessPolicy.getResource());
            accessPolicies.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, accessPolicyEntity -> {
            AccessPolicyDTO accessPolicy = accessPolicyEntity.getComponent();
            accessPolicy.setId(this.generateUuid());
            RevisionDTO revisionDTO = accessPolicyEntity.getRevision();
            Revision revision = new Revision(revisionDTO.getVersion(), revisionDTO.getClientId(), accessPolicyEntity.getComponent().getId());
            AccessPolicyEntity entity = this.serviceFacade.createAccessPolicy(revision, accessPolicyEntity.getComponent());
            this.populateRemainingAccessPolicyEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets an access policy", response=AccessPolicyEntity.class, authorizations={@Authorization(value="Read - /policies/{resource}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getAccessPolicy(@ApiParam(value="The access policy id.", required=true) @PathParam(value="id") String id) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable authorizable = lookup.getAccessPolicyById(id);
            authorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        AccessPolicyEntity entity = this.serviceFacade.getAccessPolicy(id);
        this.populateRemainingAccessPolicyEntityContent(entity);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a access policy", response=AccessPolicyEntity.class, authorizations={@Authorization(value="Write - /policies/{resource}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateAccessPolicy(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The access policy id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The access policy configuration details.", required=true) AccessPolicyEntity requestAccessPolicyEntity) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (requestAccessPolicyEntity == null || requestAccessPolicyEntity.getComponent() == null) {
            throw new IllegalArgumentException("Access policy details must be specified.");
        }
        if (requestAccessPolicyEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        AccessPolicyDTO requestAccessPolicyDTO = requestAccessPolicyEntity.getComponent();
        if (!id.equals(requestAccessPolicyDTO.getId())) {
            throw new IllegalArgumentException(String.format("The access policy id (%s) in the request body does not equal the access policy id of the requested resource (%s).", requestAccessPolicyDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestAccessPolicyEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestAccessPolicyEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestAccessPolicyEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getAccessPolicyById(id);
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, accessPolicyEntity) -> {
            AccessPolicyDTO accessPolicyDTO = accessPolicyEntity.getComponent();
            AccessPolicyEntity entity = this.serviceFacade.updateAccessPolicy(revision, accessPolicyDTO);
            this.populateRemainingAccessPolicyEntityContent(entity);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes an access policy", response=AccessPolicyEntity.class, authorizations={@Authorization(value="Write - /policies/{resource}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeAccessPolicy(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The access policy id.", required=true) @PathParam(value="id") String id) {
        if (!(this.authorizer instanceof AbstractPolicyBasedAuthorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, and policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        AccessPolicyEntity requestAccessPolicyEntity = new AccessPolicyEntity();
        requestAccessPolicyEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestAccessPolicyEntity, requestRevision, lookup -> {
            Authorizable accessPolicy = lookup.getAccessPolicyById(id);
            accessPolicy.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, accessPolicyEntity) -> {
            AccessPolicyEntity entity = this.serviceFacade.deleteAccessPolicy(revision, accessPolicyEntity.getId());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }
}

