/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.flow;

import java.util.List;
import java.util.Map;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.stateless.flow.StatelessDataflowValidation;

public class StandardStatelessDataflowValidation
implements StatelessDataflowValidation {
    private final Map<ComponentNode, List<ValidationResult>> validationResults;

    public StandardStatelessDataflowValidation(Map<ComponentNode, List<ValidationResult>> validationResults) {
        this.validationResults = validationResults;
    }

    public boolean isValid() {
        return this.validationResults.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("The following components are not valid:\n");
        for (ComponentNode component : this.validationResults.keySet()) {
            sb.append(component.getComponentType()).append(" ").append(component.getName()).append(" (id=").append(component.getIdentifier()).append("):\n");
            List<ValidationResult> results = this.validationResults.get(component);
            for (ValidationResult result : results) {
                sb.append("\t").append(result.toString()).append("\n");
            }
        }
        return sb.toString();
    }
}

