/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.config;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.security.ssl.StandardKeyManagerBuilder;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.apache.nifi.security.ssl.StandardTrustManagerBuilder;
import org.apache.nifi.security.util.TlsPlatform;
import org.apache.nifi.stateless.config.SslContextDefinition;
import org.apache.nifi.stateless.config.StatelessConfigurationException;
import org.apache.nifi.web.client.ssl.TlsContext;

public class SslConfigurationUtil {
    public static TlsContext createTlsContext(SslContextDefinition sslContextDefinition) throws StatelessConfigurationException {
        X509ExtendedKeyManager keyManager;
        if (sslContextDefinition.getKeystoreFile() == null) {
            keyManager = null;
        } else {
            KeyStore keyStore = SslConfigurationUtil.getKeyStore(sslContextDefinition);
            char[] keyStorePass = sslContextDefinition.getKeystorePass().toCharArray();
            keyManager = new StandardKeyManagerBuilder().keyStore(keyStore).keyPassword(keyStorePass).build();
        }
        KeyStore trustStore = SslConfigurationUtil.getTrustStore(sslContextDefinition);
        final X509ExtendedTrustManager trustManager = new StandardTrustManagerBuilder().trustStore(trustStore).build();
        return new TlsContext(){

            public String getProtocol() {
                return TlsPlatform.getLatestProtocol();
            }

            public X509TrustManager getTrustManager() {
                return trustManager;
            }

            public Optional<X509KeyManager> getKeyManager() {
                return Optional.ofNullable(keyManager);
            }
        };
    }

    public static SSLContext createSslContext(SslContextDefinition sslContextDefinition) throws StatelessConfigurationException {
        if (sslContextDefinition == null) {
            return null;
        }
        if (sslContextDefinition.getTruststoreFile() == null) {
            return null;
        }
        StandardSslContextBuilder sslContextBuilder = new StandardSslContextBuilder();
        KeyStore trustStore = SslConfigurationUtil.getTrustStore(sslContextDefinition);
        X509ExtendedTrustManager trustManager = new StandardTrustManagerBuilder().trustStore(trustStore).build();
        sslContextBuilder.trustManager((TrustManager)trustManager);
        if (sslContextDefinition.getKeystoreFile() != null) {
            KeyStore keyStore = SslConfigurationUtil.getKeyStore(sslContextDefinition);
            char[] keyStorePass = sslContextDefinition.getKeystorePass().toCharArray();
            X509ExtendedKeyManager keyManager = new StandardKeyManagerBuilder().keyStore(keyStore).keyPassword(keyStorePass).build();
            sslContextBuilder.keyManager((KeyManager)keyManager);
        }
        return sslContextBuilder.build();
    }

    private static KeyStore getTrustStore(SslContextDefinition sslContextDefinition) throws StatelessConfigurationException {
        KeyStore keyStore;
        block8: {
            char[] trustStorePass = sslContextDefinition.getTruststorePass().toCharArray();
            StandardKeyStoreBuilder builder = new StandardKeyStoreBuilder().type(sslContextDefinition.getTruststoreType()).password(trustStorePass);
            Path trustStorePath = Paths.get(sslContextDefinition.getTruststoreFile(), new String[0]);
            InputStream inputStream = Files.newInputStream(trustStorePath, new OpenOption[0]);
            try {
                builder.inputStream(inputStream);
                keyStore = builder.build();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatelessConfigurationException("Load Trust Store [%s] failed".formatted(trustStorePath), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return keyStore;
    }

    private static KeyStore getKeyStore(SslContextDefinition sslContextDefinition) throws StatelessConfigurationException {
        KeyStore keyStore;
        block8: {
            char[] keyStorePass = sslContextDefinition.getKeystorePass().toCharArray();
            StandardKeyStoreBuilder builder = new StandardKeyStoreBuilder().type(sslContextDefinition.getKeystoreType()).password(keyStorePass);
            Path keyStorePath = Paths.get(sslContextDefinition.getKeystoreFile(), new String[0]);
            InputStream inputStream = Files.newInputStream(keyStorePath, new OpenOption[0]);
            try {
                builder.inputStream(inputStream);
                keyStore = builder.build();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatelessConfigurationException("Load Key Store [%s] failed".formatted(keyStorePath), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return keyStore;
    }
}

