/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.datasources;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.analytics.ConnectionStatusPredictions;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.datasources.GroupStatusCache;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.IterableRowStream;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;

public class ConnectionStatusPredictionDataSource
implements ResettableDataSource {
    private static final NiFiTableSchema SCHEMA = new NiFiTableSchema(List.of(new ColumnSchema("connectionId", String.class, false), new ColumnSchema("predictedQueuedBytes", Long.TYPE, true), new ColumnSchema("predictedQueuedCount", Integer.TYPE, true), new ColumnSchema("predictedPercentBytes", Integer.TYPE, true), new ColumnSchema("predictedPercentCount", Integer.TYPE, true), new ColumnSchema("predictedTimeToBytesBackpressureMillis", Long.TYPE, true), new ColumnSchema("predictedTimeToCountBackpressureMillis", Long.TYPE, true), new ColumnSchema("predictionIntervalMillis", Long.TYPE, true)));
    private final ReportingContext reportingContext;
    private final GroupStatusCache groupStatusCache;
    private ProcessGroupStatus lastFetchedStatus = null;
    private List<ConnectionStatus> lastConnectionStatuses = null;

    public ConnectionStatusPredictionDataSource(ReportingContext reportingContext, GroupStatusCache groupStatusCache) {
        this.reportingContext = reportingContext;
        this.groupStatusCache = groupStatusCache;
    }

    public NiFiTableSchema getSchema() {
        return SCHEMA;
    }

    public RowStream reset() {
        ProcessGroupStatus groupStatus = this.groupStatusCache.getGroupStatus(this.reportingContext);
        List<ConnectionStatus> connectionStatuses = groupStatus == this.lastFetchedStatus ? this.lastConnectionStatuses : (this.lastConnectionStatuses = this.gatherConnectionStatuses(groupStatus));
        this.lastFetchedStatus = groupStatus;
        return new IterableRowStream(connectionStatuses, this::toArray);
    }

    private List<ConnectionStatus> gatherConnectionStatuses(ProcessGroupStatus groupStatus) {
        ArrayList<ConnectionStatus> allStatuses = new ArrayList<ConnectionStatus>();
        this.gatherConnectionStatuses(groupStatus, allStatuses);
        return allStatuses;
    }

    private void gatherConnectionStatuses(ProcessGroupStatus groupStatus, List<ConnectionStatus> connectionStatuses) {
        connectionStatuses.addAll(groupStatus.getConnectionStatus());
        for (ProcessGroupStatus childStatus : groupStatus.getProcessGroupStatus()) {
            this.gatherConnectionStatuses(childStatus, connectionStatuses);
        }
    }

    private Object[] toArray(ConnectionStatus status) {
        ConnectionStatusPredictions predictions = status.getPredictions();
        if (predictions == null) {
            return new Object[8];
        }
        return new Object[]{status.getId(), predictions.getNextPredictedQueuedBytes(), predictions.getNextPredictedQueuedCount(), predictions.getPredictedPercentBytes(), predictions.getPredictedPercentCount(), predictions.getPredictedTimeToBytesBackpressureMillis(), predictions.getPredictedTimeToCountBackpressureMillis(), predictions.getPredictionIntervalMillis()};
    }
}

