/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.datasources;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.datasources.GroupStatusCache;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.IterableRowStream;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;

public class ConnectionStatusDataSource
implements ResettableDataSource {
    private static final NiFiTableSchema SCHEMA = new NiFiTableSchema(List.of(new ColumnSchema("id", String.class, false), new ColumnSchema("groupId", String.class, false), new ColumnSchema("name", String.class, false), new ColumnSchema("sourceId", String.class, false), new ColumnSchema("sourceName", String.class, true), new ColumnSchema("destinationId", String.class, false), new ColumnSchema("destinationName", String.class, true), new ColumnSchema("backPressureDataSizeThreshold", String.class, true), new ColumnSchema("backPressureBytesThreshold", Long.class, true), new ColumnSchema("backPressureObjectThreshold", Long.class, true), new ColumnSchema("isBackPressureEnabled", Boolean.TYPE, false), new ColumnSchema("inputCount", Long.TYPE, false), new ColumnSchema("inputBytes", Long.TYPE, false), new ColumnSchema("queuedCount", Integer.TYPE, false), new ColumnSchema("queuedBytes", Long.TYPE, false), new ColumnSchema("outputCount", Long.TYPE, false), new ColumnSchema("outputBytes", Long.TYPE, false), new ColumnSchema("maxQueuedCount", Integer.class, true), new ColumnSchema("maxQueuedBytes", Long.class, true)));
    private final ReportingContext reportingContext;
    private final GroupStatusCache groupStatusCache;
    private ProcessGroupStatus lastFetchedStatus = null;
    private List<ConnectionStatus> lastConnectionStatuses = null;

    public ConnectionStatusDataSource(ReportingContext reportingContext, GroupStatusCache groupStatusCache) {
        this.reportingContext = reportingContext;
        this.groupStatusCache = groupStatusCache;
    }

    public NiFiTableSchema getSchema() {
        return SCHEMA;
    }

    public RowStream reset() {
        ProcessGroupStatus groupStatus = this.groupStatusCache.getGroupStatus(this.reportingContext);
        List<ConnectionStatus> connectionStatuses = groupStatus == this.lastFetchedStatus ? this.lastConnectionStatuses : (this.lastConnectionStatuses = this.gatherConnectionStatuses(groupStatus));
        this.lastFetchedStatus = groupStatus;
        return new IterableRowStream(connectionStatuses, this::toArray);
    }

    private List<ConnectionStatus> gatherConnectionStatuses(ProcessGroupStatus groupStatus) {
        ArrayList<ConnectionStatus> allStatuses = new ArrayList<ConnectionStatus>();
        this.gatherConnectionStatuses(groupStatus, allStatuses);
        return allStatuses;
    }

    private void gatherConnectionStatuses(ProcessGroupStatus groupStatus, List<ConnectionStatus> connectionStatuses) {
        connectionStatuses.addAll(groupStatus.getConnectionStatus());
        for (ProcessGroupStatus childStatus : groupStatus.getProcessGroupStatus()) {
            this.gatherConnectionStatuses(childStatus, connectionStatuses);
        }
    }

    private Object[] toArray(ConnectionStatus status) {
        return new Object[]{status.getId(), status.getGroupId(), status.getName(), status.getSourceId(), status.getSourceName(), status.getDestinationId(), status.getDestinationName(), status.getBackPressureDataSizeThreshold(), status.getBackPressureBytesThreshold(), status.getBackPressureObjectThreshold(), status.getBackPressureObjectThreshold() > 0L && status.getBackPressureObjectThreshold() <= (long)status.getQueuedCount() || status.getBackPressureBytesThreshold() > 0L && status.getBackPressureBytesThreshold() <= status.getQueuedBytes(), status.getInputCount(), status.getInputBytes(), status.getQueuedCount(), status.getQueuedBytes(), status.getOutputCount(), status.getOutputBytes(), status.getMaxQueuedCount(), status.getMaxQueuedBytes()};
    }
}

