/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.CachedStatement;
import org.apache.nifi.reporting.sql.MetricsQueryService;
import org.apache.nifi.reporting.sql.QueryResult;
import org.apache.nifi.reporting.sql.datasources.BulletinDataSource;
import org.apache.nifi.reporting.sql.datasources.ConnectionStatusDataSource;
import org.apache.nifi.reporting.sql.datasources.ConnectionStatusPredictionDataSource;
import org.apache.nifi.reporting.sql.datasources.FlowConfigHistoryDataSource;
import org.apache.nifi.reporting.sql.datasources.GroupStatusCache;
import org.apache.nifi.reporting.sql.datasources.JvmMetricsDataSource;
import org.apache.nifi.reporting.sql.datasources.ProcessGroupStatusDataSource;
import org.apache.nifi.reporting.sql.datasources.ProcessorStatusDataSource;
import org.apache.nifi.reporting.sql.datasources.ProvenanceDataSource;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.ResultSetRecordSet;
import org.apache.nifi.sql.CalciteDatabase;
import org.apache.nifi.sql.NiFiTable;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.util.db.JdbcCommon;

public class MetricsSqlQueryService
implements MetricsQueryService {
    private final ComponentLog logger;
    private final int defaultPrecision;
    private final int defaultScale;
    private final Cache<String, BlockingQueue<CachedStatement>> statementQueues = Caffeine.newBuilder().maximumSize(25L).removalListener(this::onCacheEviction).build();

    public MetricsSqlQueryService(ComponentLog logger, int defaultPrecision, int defaultScale) {
        this.defaultPrecision = defaultPrecision;
        this.defaultScale = defaultScale;
        this.logger = logger;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    @Override
    public QueryResult query(ReportingContext context, final String sql) throws Exception {
        Supplier<CachedStatement> statementBuilder = () -> {
            try {
                return this.buildCachedStatement(sql, context);
            }
            catch (Exception e) {
                throw new PreparedStatementException(e);
            }
        };
        final CachedStatement cachedStatement = this.getStatement(sql, statementBuilder, this.statementQueues);
        PreparedStatement stmt = cachedStatement.getStatement();
        final ResultSet rs = stmt.executeQuery();
        return new QueryResult(){

            @Override
            public void close() throws IOException {
                BlockingQueue statementQueue = (BlockingQueue)MetricsSqlQueryService.this.statementQueues.getIfPresent((Object)sql);
                if (statementQueue == null || !statementQueue.offer(cachedStatement)) {
                    try {
                        cachedStatement.getConnection().close();
                    }
                    catch (SQLException e) {
                        throw new IOException("Failed to close statement", e);
                    }
                }
            }

            @Override
            public ResultSet getResultSet() {
                return rs;
            }

            @Override
            public int getRecordsRead() {
                return 0;
            }
        };
    }

    @Override
    public ResultSetRecordSet getResultSetRecordSet(QueryResult queryResult) throws Exception {
        ResultSet rs = queryResult.getResultSet();
        ResultSetRecordSet recordSet = null;
        RecordSchema writerSchema = AvroTypeUtil.createSchema((Schema)JdbcCommon.createSchema((ResultSet)rs));
        try {
            recordSet = new ResultSetRecordSet(rs, writerSchema, this.defaultPrecision, this.defaultScale);
        }
        catch (SQLException e) {
            this.getLogger().error("Error creating record set from query results due to {}", new Object[]{e.getMessage(), e});
        }
        return recordSet;
    }

    private synchronized CachedStatement getStatement(String sql, Supplier<CachedStatement> statementBuilder, Cache<String, BlockingQueue<CachedStatement>> statementQueues) {
        CachedStatement cachedStmt;
        BlockingQueue statementQueue = (BlockingQueue)statementQueues.get((Object)sql, key -> new LinkedBlockingQueue());
        if (statementQueue != null && (cachedStmt = (CachedStatement)statementQueue.poll()) != null) {
            return cachedStmt;
        }
        return statementBuilder.get();
    }

    private CachedStatement buildCachedStatement(String sql, ReportingContext context) throws Exception {
        CalciteDatabase database = new CalciteDatabase();
        GroupStatusCache groupStatusCache = new GroupStatusCache(Duration.ofSeconds(60L));
        ConnectionStatusDataSource connectionStatusDataSource = new ConnectionStatusDataSource(context, groupStatusCache);
        NiFiTable connectionStatusTable = new NiFiTable("CONNECTION_STATUS", (ResettableDataSource)connectionStatusDataSource, this.getLogger());
        database.addTable(connectionStatusTable);
        ConnectionStatusPredictionDataSource predictionDataSource = new ConnectionStatusPredictionDataSource(context, groupStatusCache);
        NiFiTable connectionStatusPredictionsTable = new NiFiTable("CONNECTION_STATUS_PREDICTIONS", (ResettableDataSource)predictionDataSource, this.getLogger());
        database.addTable(connectionStatusPredictionsTable);
        if (!context.isAnalyticsEnabled()) {
            this.getLogger().info("Analytics is not enabled, CONNECTION_STATUS_PREDICTIONS table will not contain any rows");
        }
        ProcessorStatusDataSource processorStatusDataSource = new ProcessorStatusDataSource(context, groupStatusCache);
        NiFiTable processorStatusTable = new NiFiTable("PROCESSOR_STATUS", (ResettableDataSource)processorStatusDataSource, this.getLogger());
        database.addTable(processorStatusTable);
        ProcessGroupStatusDataSource processGroupStatusDataSource = new ProcessGroupStatusDataSource(context, groupStatusCache);
        NiFiTable processGroupStatusTable = new NiFiTable("PROCESS_GROUP_STATUS", (ResettableDataSource)processGroupStatusDataSource, this.getLogger());
        database.addTable(processGroupStatusTable);
        JvmMetricsDataSource jvmMetricsDataSource = new JvmMetricsDataSource();
        NiFiTable jvmMetricsTable = new NiFiTable("JVM_METRICS", (ResettableDataSource)jvmMetricsDataSource, this.getLogger());
        database.addTable(jvmMetricsTable);
        BulletinDataSource bulletinDataSource = new BulletinDataSource(context);
        NiFiTable bulletinTable = new NiFiTable("BULLETINS", (ResettableDataSource)bulletinDataSource, this.getLogger());
        database.addTable(bulletinTable);
        ProvenanceDataSource provenanceDataSource = new ProvenanceDataSource(context);
        NiFiTable provenanceTable = new NiFiTable("PROVENANCE", (ResettableDataSource)provenanceDataSource, this.getLogger());
        database.addTable(provenanceTable);
        FlowConfigHistoryDataSource flowConfigHistoryDataSource = new FlowConfigHistoryDataSource(context);
        NiFiTable flowConfigHistoryTable = new NiFiTable("FLOW_CONFIG_HISTORY", (ResettableDataSource)flowConfigHistoryDataSource, this.getLogger());
        database.addTable(flowConfigHistoryTable);
        Connection connection = database.getConnection();
        PreparedStatement stmt = connection.prepareStatement(sql);
        return new CachedStatement(stmt, database);
    }

    private void clearQueue(BlockingQueue<CachedStatement> statementQueue) {
        CachedStatement stmt;
        while ((stmt = (CachedStatement)statementQueue.poll()) != null) {
            this.closeQuietly(new AutoCloseable[]{stmt.getStatement(), stmt.getDatabase()});
        }
    }

    @Override
    public void closeQuietly(AutoCloseable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to close SQL resource", (Throwable)e);
            }
        }
    }

    private void onCacheEviction(String key, BlockingQueue<CachedStatement> queue, RemovalCause cause) {
        this.clearQueue(queue);
    }

    private static class PreparedStatementException
    extends RuntimeException {
        public PreparedStatementException(Throwable cause) {
            super(cause);
        }
    }
}

