/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.smb;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.apache.nifi.processor.util.list.ListableEntity;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class SmbListableEntity
implements ListableEntity {
    public static final String FILENAME = "filename";
    public static final String SHORT_NAME = "shortName";
    public static final String PATH = "path";
    public static final String SERVICE_LOCATION = "serviceLocation";
    public static final String CREATION_TIME = "creationTime";
    public static final String LAST_ACCESS_TIME = "lastAccessTime";
    public static final String CHANGE_TIME = "changeTime";
    public static final String LAST_MODIFIED_TIME = "lastModifiedTime";
    public static final String SIZE = "size";
    public static final String ALLOCATION_SIZE = "allocationSize";
    private final String name;
    private final String shortName;
    private final String path;
    private final long lastModifiedTime;
    private final long creationTime;
    private final long lastAccessTime;
    private final long changeTime;
    private final boolean directory;
    private final long size;
    private final long allocationSize;
    private final URI serviceLocation;

    private SmbListableEntity(String name, String shortName, String path, long lastModifiedTime, long creationTime, long lastAccessTime, long changeTime, boolean directory, long size, long allocationSize, URI serviceLocation) {
        this.name = name;
        this.shortName = shortName;
        this.path = path;
        this.lastModifiedTime = lastModifiedTime;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.changeTime = changeTime;
        this.directory = directory;
        this.size = size;
        this.allocationSize = allocationSize;
        this.serviceLocation = serviceLocation;
    }

    public static SimpleRecordSchema getRecordSchema() {
        List<RecordField> fields = Arrays.asList(new RecordField(FILENAME, RecordFieldType.STRING.getDataType(), false), new RecordField(SHORT_NAME, RecordFieldType.STRING.getDataType(), false), new RecordField(PATH, RecordFieldType.STRING.getDataType(), false), new RecordField(LAST_MODIFIED_TIME, RecordFieldType.LONG.getDataType(), false), new RecordField(CREATION_TIME, RecordFieldType.LONG.getDataType(), false), new RecordField(LAST_ACCESS_TIME, RecordFieldType.LONG.getDataType(), false), new RecordField(CHANGE_TIME, RecordFieldType.LONG.getDataType(), false), new RecordField(SIZE, RecordFieldType.LONG.getDataType(), false), new RecordField(ALLOCATION_SIZE, RecordFieldType.LONG.getDataType(), false));
        return new SimpleRecordSchema(fields);
    }

    public static SmbListableEntityBuilder builder() {
        return new SmbListableEntityBuilder();
    }

    public String getShortName() {
        return this.shortName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getChangeTime() {
        return this.changeTime;
    }

    public long getAllocationSize() {
        return this.allocationSize;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getPathWithName() {
        return this.path.isEmpty() ? this.name : this.path + "/" + this.name;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getIdentifier() {
        return this.getPathWithName();
    }

    public long getTimestamp() {
        return this.getLastModifiedTime();
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmbListableEntity that = (SmbListableEntity)o;
        return this.getPathWithName().equals(that.getPathWithName());
    }

    public int hashCode() {
        return this.getPathWithName().hashCode();
    }

    public String toString() {
        return this.getPathWithName() + " (last write: " + this.lastModifiedTime + " size: " + this.size + ")";
    }

    public Record toRecord() {
        TreeMap<String, Object> record = new TreeMap<String, Object>();
        record.put(FILENAME, this.getName());
        record.put(SHORT_NAME, this.getShortName());
        record.put(PATH, this.getPath());
        record.put(SERVICE_LOCATION, this.getServiceLocation().toString());
        record.put(CREATION_TIME, this.getCreationTime());
        record.put(LAST_ACCESS_TIME, this.getLastAccessTime());
        record.put(LAST_MODIFIED_TIME, this.getLastModifiedTime());
        record.put(CHANGE_TIME, this.getChangeTime());
        record.put(SIZE, this.getSize());
        record.put(ALLOCATION_SIZE, this.getAllocationSize());
        return new MapRecord((RecordSchema)SmbListableEntity.getRecordSchema(), record);
    }

    private URI getServiceLocation() {
        return this.serviceLocation;
    }

    public static class SmbListableEntityBuilder {
        private String name;
        private String shortName;
        private String path = "";
        private long lastModifiedTime;
        private long creationTime;
        private long lastAccessTime;
        private long changeTime;
        private boolean directory = false;
        private long size = 0L;
        private long allocationSize = 0L;
        private URI serviceLocation;

        public SmbListableEntityBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public SmbListableEntityBuilder setShortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public SmbListableEntityBuilder setPath(String path) {
            this.path = path;
            return this;
        }

        public SmbListableEntityBuilder setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public SmbListableEntityBuilder setCreationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public SmbListableEntityBuilder setLastAccessTime(long lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public SmbListableEntityBuilder setChangeTime(long changeTime) {
            this.changeTime = changeTime;
            return this;
        }

        public SmbListableEntityBuilder setDirectory(boolean directory) {
            this.directory = directory;
            return this;
        }

        public SmbListableEntityBuilder setSize(long size) {
            this.size = size;
            return this;
        }

        public SmbListableEntityBuilder setAllocationSize(long allocationSize) {
            this.allocationSize = allocationSize;
            return this;
        }

        public SmbListableEntityBuilder setServiceLocation(URI serviceLocation) {
            this.serviceLocation = serviceLocation;
            return this;
        }

        public SmbListableEntity build() {
            return new SmbListableEntity(this.name, this.shortName, this.path, this.lastModifiedTime, this.creationTime, this.lastAccessTime, this.changeTime, this.directory, this.size, this.allocationSize, this.serviceLocation);
        }
    }
}

