/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.script.RecordCounts;
import org.apache.nifi.processors.script.ScriptEvaluator;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.processors.script.ScriptedRecordProcessor;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.PushBackRecordSet;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

@SupportsBatching
@SideEffectFree
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer"), @WritesAttribute(attribute="record.count", description="The number of records within the flow file."), @WritesAttribute(attribute="record.error.message", description="This attribute provides on failure the error message encountered by the Reader or Writer.")})
public abstract class ScriptedRouterProcessor<T>
extends ScriptedRecordProcessor {
    private final Class<T> scriptResultType;

    protected ScriptedRouterProcessor(Class<T> scriptResultType) {
        this.scriptResultType = scriptResultType;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ScriptRunner scriptRunner = this.pollScriptRunner();
        boolean success = false;
        try {
            ScriptEvaluator evaluator;
            try {
                ScriptEngine scriptEngine = scriptRunner.getScriptEngine();
                evaluator = this.createEvaluator(scriptEngine, flowFile);
            }
            catch (ScriptException se) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Script as executed by NiFi with preloads {}", new Object[]{scriptRunner.getScript()});
                }
                this.getLogger().error("Failed to initialize script engine", (Throwable)se);
                session.transfer(flowFile, this.getFailureRelationship());
                this.offerScriptRunner(scriptRunner);
                return;
            }
            success = this.route(context, session, flowFile, evaluator);
        }
        finally {
            this.offerScriptRunner(scriptRunner);
        }
        session.transfer(flowFile, success ? this.getOriginalRelationship() : this.getFailureRelationship());
    }

    private boolean route(ProcessContext context, ProcessSession session, FlowFile incomingFlowFile, ScriptEvaluator evaluator) {
        RecordReaderFactory readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        Map originalAttributes = incomingFlowFile.getAttributes();
        RecordCounts counts = new RecordCounts();
        try {
            session.read(incomingFlowFile, in -> {
                try (RecordReader reader = readerFactory.createRecordReader(originalAttributes, in, incomingFlowFile.getSize(), this.getLogger());){
                    FlowFile outgoingFlowFile;
                    RecordSchema schema = writerFactory.getSchema(originalAttributes, reader.getSchema());
                    RecordSet recordSet = reader.createRecordSet();
                    PushBackRecordSet pushBackSet = new PushBackRecordSet(recordSet);
                    HashMap<Relationship, FlowFile> outgoingFlowFiles = new HashMap<Relationship, FlowFile>();
                    HashMap<Relationship, RecordSetWriter> recordSetWriters = new HashMap<Relationship, RecordSetWriter>();
                    while (pushBackSet.isAnotherRecord()) {
                        Record record = pushBackSet.next();
                        Object evaluatedValue = evaluator.evaluate(record, counts.getRecordCount());
                        this.getLogger().debug("Evaluated scripted against {} (index {}), producing result of {}", new Object[]{record, counts.getRecordCount(), evaluatedValue});
                        counts.incrementRecordCount();
                        if (evaluatedValue != null && this.scriptResultType.isInstance(evaluatedValue)) {
                            Optional<Relationship> outgoingRelationship = this.resolveRelationship(this.scriptResultType.cast(evaluatedValue));
                            if (outgoingRelationship.isPresent()) {
                                if (!outgoingFlowFiles.containsKey(outgoingRelationship.get())) {
                                    outgoingFlowFile = session.create(incomingFlowFile);
                                    OutputStream out = session.write(outgoingFlowFile);
                                    RecordSetWriter writer = writerFactory.createWriter(this.getLogger(), schema, out, outgoingFlowFile);
                                    writer.beginRecordSet();
                                    outgoingFlowFiles.put(outgoingRelationship.get(), outgoingFlowFile);
                                    recordSetWriters.put(outgoingRelationship.get(), writer);
                                }
                                ((RecordSetWriter)recordSetWriters.get(outgoingRelationship.get())).write(record);
                                continue;
                            }
                            this.getLogger().debug("Record with evaluated value {} has no outgoing relationship determined", new Object[]{String.valueOf(evaluatedValue)});
                            continue;
                        }
                        throw new ProcessException("Script returned a value of " + String.valueOf(evaluatedValue) + " but this Processor requires that the object returned be an instance of " + this.scriptResultType.getSimpleName());
                    }
                    for (Relationship relationship : outgoingFlowFiles.keySet()) {
                        RecordSetWriter writer = (RecordSetWriter)recordSetWriters.get(relationship);
                        outgoingFlowFile = (FlowFile)outgoingFlowFiles.get(relationship);
                        HashMap<String, String> attributes = new HashMap<String, String>(incomingFlowFile.getAttributes());
                        attributes.put("mime.type", writer.getMimeType());
                        try {
                            WriteResult finalResult = writer.finishRecordSet();
                            int outgoingFlowFileRecords = finalResult.getRecordCount();
                            attributes.put("record.count", String.valueOf(outgoingFlowFileRecords));
                            writer.close();
                        }
                        catch (IOException e) {
                            throw new ProcessException("Resources used for record writing might not be closed", (Throwable)e);
                        }
                        session.putAllAttributes(outgoingFlowFile, attributes);
                        session.transfer(outgoingFlowFile, relationship);
                    }
                }
                catch (ScriptException | SchemaNotFoundException | MalformedRecordException e) {
                    throw new ProcessException("After processing " + counts.getRecordCount() + " Records, encountered failure when attempting to process " + String.valueOf(incomingFlowFile), e);
                }
            });
            session.adjustCounter("Records Processed", counts.getRecordCount(), true);
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("Failed to route records", (Throwable)e);
            return false;
        }
    }

    protected abstract Relationship getOriginalRelationship();

    protected abstract Relationship getFailureRelationship();

    protected abstract Optional<Relationship> resolveRelationship(T var1);
}

