/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.github;

import java.io.IOException;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.github.GitHubAuthenticationType;
import org.apache.nifi.github.GitHubRepositoryClient;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.git.AbstractGitFlowRegistryClient;
import org.apache.nifi.registry.flow.git.client.GitRepositoryClient;

@Tags(value={"git", "github", "registry", "flow"})
@CapabilityDescription(value="Flow Registry Client that uses the GitHub REST API to version control flows in a GitHub repository. Note that for a given flow, the registry client will retrieve at most the last 10 commits to limit API calls.")
public class GitHubFlowRegistryClient
extends AbstractGitFlowRegistryClient {
    static final PropertyDescriptor GITHUB_API_URL = new PropertyDescriptor.Builder().name("GitHub API URL").description("The URL of the GitHub API").addValidator(StandardValidators.URL_VALIDATOR).defaultValue("https://api.github.com/").required(true).build();
    static final PropertyDescriptor REPOSITORY_NAME = new PropertyDescriptor.Builder().name("Repository Name").description("The name of the repository").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor REPOSITORY_OWNER = new PropertyDescriptor.Builder().name("Repository Owner").description("The owner of the repository").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor AUTHENTICATION_TYPE = new PropertyDescriptor.Builder().name("Authentication Type").description("The type of authentication to use for accessing GitHub").allowableValues(GitHubAuthenticationType.class).defaultValue(GitHubAuthenticationType.NONE.name()).required(true).build();
    static final PropertyDescriptor PERSONAL_ACCESS_TOKEN = new PropertyDescriptor.Builder().name("Personal Access Token").description("The personal access token to use for authentication").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(true).dependsOn(AUTHENTICATION_TYPE, GitHubAuthenticationType.PERSONAL_ACCESS_TOKEN.name(), new String[0]).build();
    static final PropertyDescriptor APP_ID = new PropertyDescriptor.Builder().name("App ID").description("Identifier of GitHub App to use for authentication").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(false).dependsOn(AUTHENTICATION_TYPE, GitHubAuthenticationType.APP_INSTALLATION.name(), new String[0]).build();
    static final PropertyDescriptor APP_PRIVATE_KEY = new PropertyDescriptor.Builder().name("App Private Key").description("RSA private key associated with GitHub App to use for authentication.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(true).dependsOn(AUTHENTICATION_TYPE, GitHubAuthenticationType.APP_INSTALLATION.name(), new String[0]).build();
    static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(GITHUB_API_URL, REPOSITORY_OWNER, REPOSITORY_NAME, AUTHENTICATION_TYPE, PERSONAL_ACCESS_TOKEN, APP_ID, APP_PRIVATE_KEY);
    static final String STORAGE_LOCATION_PREFIX = "git@github.com:";
    static final String STORAGE_LOCATION_FORMAT = "git@github.com:%s/%s.git";

    protected List<PropertyDescriptor> createPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected GitHubRepositoryClient createRepositoryClient(FlowRegistryClientConfigurationContext context) throws IOException, FlowRegistryException {
        return GitHubRepositoryClient.builder().logger(this.getLogger()).apiUrl(context.getProperty(GITHUB_API_URL).getValue()).authenticationType(GitHubAuthenticationType.valueOf(context.getProperty(AUTHENTICATION_TYPE).getValue())).personalAccessToken(context.getProperty(PERSONAL_ACCESS_TOKEN).getValue()).appId(context.getProperty(APP_ID).getValue()).appPrivateKey(context.getProperty(APP_PRIVATE_KEY).getValue()).repoOwner(context.getProperty(REPOSITORY_OWNER).getValue()).repoName(context.getProperty(REPOSITORY_NAME).getValue()).repoPath(context.getProperty(REPOSITORY_PATH).getValue()).build();
    }

    protected String getStorageLocation(GitRepositoryClient repositoryClient) {
        GitHubRepositoryClient gitHubRepositoryClient = (GitHubRepositoryClient)repositoryClient;
        return STORAGE_LOCATION_FORMAT.formatted(gitHubRepositoryClient.getRepoOwner(), gitHubRepositoryClient.getRepoName());
    }

    public boolean isStorageLocationApplicable(FlowRegistryClientConfigurationContext context, String location) {
        return location != null && location.startsWith(STORAGE_LOCATION_PREFIX);
    }
}

