/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.ExternalControllerServiceReference;
import org.apache.nifi.flow.ParameterProviderReference;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.registry.flow.BucketLocation;
import org.apache.nifi.registry.flow.FlowLocation;
import org.apache.nifi.registry.flow.FlowRegistryBranch;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.FlowRegistryClientUserContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.FlowRegistryInvalidException;
import org.apache.nifi.registry.flow.FlowSnapshotContainer;
import org.apache.nifi.registry.flow.FlowVersionLocation;
import org.apache.nifi.registry.flow.RegisterAction;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.StandardFlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.VerifiableFlowRegistryClient;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardFlowRegistryClientNode
extends AbstractComponentNode
implements FlowRegistryClientNode {
    private static final Logger logger = LoggerFactory.getLogger(StandardFlowRegistryClientNode.class);
    private final FlowManager flowManager;
    private final Authorizable parent;
    private final AtomicReference<LoggableComponent<FlowRegistryClient>> client = new AtomicReference();
    private final ControllerServiceProvider serviceProvider;
    private volatile String description;

    public StandardFlowRegistryClientNode(Authorizable parent, FlowManager flowManager, LoggableComponent<FlowRegistryClient> client, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, String componentType, String componentCanonicalClass, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(id, validationContextFactory, serviceProvider, componentType, componentCanonicalClass, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
        this.parent = parent;
        this.flowManager = flowManager;
        this.serviceProvider = serviceProvider;
        this.client.set(client);
    }

    public Authorizable getParentAuthorizable() {
        return this.parent;
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.RegistryClient, (String)this.getIdentifier(), (String)this.getName());
    }

    public String getProcessGroupIdentifier() {
        return null;
    }

    protected List<ValidationResult> validateConfig() {
        return Collections.emptyList();
    }

    public void verifyModifiable() throws IllegalStateException {
    }

    protected ParameterContext getParameterContext() {
        return null;
    }

    public void reload(Set<URL> additionalUrls) throws Exception {
        String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls, (String)this.determineClasloaderIsolationKey());
        this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
        this.getReloadComponent().reload((FlowRegistryClientNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.client.get().getBundleCoordinate();
    }

    public ConfigurableComponent getComponent() {
        return this.client.get().getComponent();
    }

    public TerminationAwareLogger getLogger() {
        return this.client.get().getLogger();
    }

    public Class<?> getComponentClass() {
        return ((FlowRegistryClient)this.client.get().getComponent()).getClass();
    }

    public boolean isRestricted() {
        return this.getComponentClass().isAnnotationPresent(Restricted.class);
    }

    public boolean isDeprecated() {
        return this.getComponentClass().isAnnotationPresent(DeprecationNotice.class);
    }

    public boolean isValidationNecessary() {
        return this.getValidationStatus() != ValidationStatus.VALID;
    }

    public Optional<ProcessGroup> getParentProcessGroup() {
        return Optional.empty();
    }

    public ParameterLookup getParameterLookup() {
        return ParameterLookup.EMPTY;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = CharacterFilterUtils.filterInvalidXmlCharacters((String)description);
    }

    public boolean isStorageLocationApplicable(String location) {
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), this.client.getClass(), (String)this.getIdentifier());){
            boolean bl = ((FlowRegistryClient)this.client.get().getComponent()).isStorageLocationApplicable(this.getConfigurationContext(), location);
            return bl;
        }
    }

    public boolean isBranchingSupported() {
        return ((FlowRegistryClient)this.client.get().getComponent()).isBranchingSupported(this.getConfigurationContext());
    }

    public Set<FlowRegistryBranch> getBranches(FlowRegistryClientUserContext context) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getBranches(this.getConfigurationContext(context)));
    }

    public FlowRegistryBranch getDefaultBranch(FlowRegistryClientUserContext context) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getDefaultBranch(this.getConfigurationContext(context)));
    }

    public Set<FlowRegistryBucket> getBuckets(FlowRegistryClientUserContext context, String branch) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getBuckets(this.getConfigurationContext(context), branch));
    }

    public FlowRegistryBucket getBucket(FlowRegistryClientUserContext context, BucketLocation bucketLocation) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getBucket(this.getConfigurationContext(context), bucketLocation));
    }

    public RegisteredFlow registerFlow(FlowRegistryClientUserContext context, RegisteredFlow flow) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).registerFlow(this.getConfigurationContext(context), flow));
    }

    public RegisteredFlow deregisterFlow(FlowRegistryClientUserContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).deregisterFlow(this.getConfigurationContext(context), flowLocation));
    }

    public RegisteredFlow getFlow(FlowRegistryClientUserContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getFlow(this.getConfigurationContext(context), flowLocation));
    }

    public Set<RegisteredFlow> getFlows(FlowRegistryClientUserContext context, BucketLocation bucketLocation) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getFlows(this.getConfigurationContext(context), bucketLocation));
    }

    public FlowSnapshotContainer getFlowContents(FlowRegistryClientUserContext context, FlowVersionLocation flowVersionLocation, boolean fetchRemoteFlows) throws FlowRegistryException, IOException {
        RegisteredFlowSnapshot flowSnapshot = this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getFlowContents(this.getConfigurationContext(context), flowVersionLocation));
        FlowSnapshotContainer snapshotContainer = new FlowSnapshotContainer(flowSnapshot);
        if (fetchRemoteFlows) {
            VersionedProcessGroup contents = flowSnapshot.getFlowContents();
            for (VersionedProcessGroup child : contents.getProcessGroups()) {
                Map<String, VersionedParameterContext> childParameterContexts = this.populateVersionedContentsRecursively(context, child, snapshotContainer);
                for (Map.Entry<String, VersionedParameterContext> childParameterContext : childParameterContexts.entrySet()) {
                    flowSnapshot.getParameterContexts().putIfAbsent(childParameterContext.getKey(), childParameterContext.getValue());
                }
                this.populateVersionedContentsRecursively(context, child, snapshotContainer);
            }
        }
        return snapshotContainer;
    }

    public RegisteredFlowSnapshot registerFlowSnapshot(FlowRegistryClientUserContext context, RegisteredFlow flow, VersionedProcessGroup snapshot, Map<String, ExternalControllerServiceReference> externalControllerServices, Map<String, VersionedParameterContext> parameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, String comments, String expectedVersion, RegisterAction registerAction) throws FlowRegistryException, IOException {
        RegisteredFlowSnapshot registeredFlowSnapshot = this.createRegisteredFlowSnapshot(context, flow, snapshot, externalControllerServices, parameterContexts, parameterProviderReferences, comments, expectedVersion);
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).registerFlowSnapshot(this.getConfigurationContext(context), registeredFlowSnapshot, registerAction));
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersions(FlowRegistryClientUserContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getFlowVersions(this.getConfigurationContext(context), flowLocation));
    }

    public Optional<String> getLatestVersion(FlowRegistryClientUserContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getLatestVersion(this.getConfigurationContext(context), flowLocation));
    }

    public String generateFlowId(String flowName) throws IOException, FlowRegistryException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).generateFlowId(flowName));
    }

    public void setComponent(LoggableComponent<FlowRegistryClient> component) {
        this.client.set(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verifyConfiguration(Map<String, String> properties, Map<String, String> variables, ComponentLog logger, ExtensionManager extensionManager) {
        ArrayList<ConfigVerificationResult> results;
        block22: {
            results = new ArrayList<ConfigVerificationResult>();
            try {
                LinkedHashMap<PropertyDescriptor, String> propertyValues = new LinkedHashMap<PropertyDescriptor, String>(this.getRawPropertyValues());
                if (properties != null) {
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        PropertyDescriptor descriptor2 = this.getPropertyDescriptor(entry.getKey());
                        propertyValues.put(descriptor2, entry.getValue());
                    }
                }
                StandardFlowRegistryClientConfigurationContext configurationContext = new StandardFlowRegistryClientConfigurationContext(null, propertyValues, this, (ControllerServiceLookup)this.serviceProvider);
                results.addAll(super.verifyConfig(propertyValues, this.getAnnotationData(), null));
                if (!results.isEmpty() && results.stream().anyMatch(result -> result.getOutcome() == ConfigVerificationResult.Outcome.FAILED)) {
                    return results;
                }
                ConfigurableComponent configurableComponent = this.client.get().getComponent();
                if (configurableComponent instanceof VerifiableFlowRegistryClient) {
                    Map<Object, Object> verificationVariables;
                    VerifiableFlowRegistryClient verifiableClient = (VerifiableFlowRegistryClient)configurableComponent;
                    boolean classpathDifferent = this.isClasspathDifferent(propertyValues);
                    Map<Object, Object> map = verificationVariables = variables == null ? Collections.emptyMap() : variables;
                    if (classpathDifferent) {
                        Bundle bundle = extensionManager.getBundle(this.getBundleCoordinate());
                        Set classpathUrls = this.getAdditionalClasspathResources(propertyValues.keySet(), descriptor -> configurationContext.getProperty((PropertyDescriptor)descriptor).getValue());
                        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                        String isolationKey = this.getClassLoaderIsolationKey(configurationContext);
                        try (InstanceClassLoader detectedClassLoader = extensionManager.createInstanceClassLoader(this.getComponentType(), this.getIdentifier(), bundle, classpathUrls, false, isolationKey);){
                            Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
                            results.addAll(verifiableClient.verify((FlowRegistryClientConfigurationContext)configurationContext, logger, verificationVariables));
                            break block22;
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(currentClassLoader);
                        }
                    }
                    try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, (Class)configurableComponent.getClass(), (String)this.getIdentifier());){
                        results.addAll(verifiableClient.verify((FlowRegistryClientConfigurationContext)configurationContext, logger, verificationVariables));
                        break block22;
                    }
                }
                this.getLogger().debug("{} does not support verification. Skipping additional verification beyond validation.", new Object[]{this});
            }
            catch (Throwable t) {
                this.getLogger().error("Failed to perform verification of Flow Registry Client configuration for {}", new Object[]{this, t});
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Perform Verification").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Encountered unexpected failure when attempting to perform verification: " + String.valueOf(t)).build());
            }
        }
        return results;
    }

    private <T> T execute(FlowRegistryClientAction<T> action) throws FlowRegistryException, IOException {
        ValidationStatus validationStatus = this.getValidationStatus();
        if (validationStatus != ValidationStatus.VALID) {
            List validationResults = this.getValidationErrors();
            if (validationResults == null) {
                validationResults = Collections.emptyList();
            }
            List validationProblems = validationResults.stream().map(ValidationResult::getExplanation).collect(Collectors.toList());
            throw new FlowRegistryInvalidException(validationProblems);
        }
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), this.client.getClass(), (String)this.getIdentifier());){
            T t = action.execute();
            return t;
        }
    }

    private FlowRegistryClientConfigurationContext getConfigurationContext() {
        return new StandardFlowRegistryClientConfigurationContext(null, this.getRawPropertyValues(), this, (ControllerServiceLookup)this.serviceProvider);
    }

    private FlowRegistryClientConfigurationContext getConfigurationContext(FlowRegistryClientUserContext clientContext) {
        String userIdentity = clientContext.getNiFiUserIdentity().orElse(null);
        return new StandardFlowRegistryClientConfigurationContext(userIdentity, this.getRawPropertyValues(), this, (ControllerServiceLookup)this.serviceProvider);
    }

    private String extractIdentity(FlowRegistryClientUserContext context) {
        return context.getNiFiUserIdentity().orElse(null);
    }

    private Map<String, VersionedParameterContext> populateVersionedContentsRecursively(FlowRegistryClientUserContext context, VersionedProcessGroup group, FlowSnapshotContainer snapshotContainer) throws FlowRegistryException {
        HashMap<String, VersionedParameterContext> accumulatedParameterContexts = new HashMap<String, VersionedParameterContext>();
        if (group == null) {
            return accumulatedParameterContexts;
        }
        VersionedFlowCoordinates coordinates = group.getVersionedFlowCoordinates();
        if (coordinates != null) {
            RegisteredFlowSnapshot snapshot = this.fetchFlowContents(context, coordinates, true);
            VersionedProcessGroup contents = snapshot.getFlowContents();
            group.setVersionedFlowCoordinates(coordinates);
            group.setComments(contents.getComments());
            group.setConnections(contents.getConnections());
            group.setControllerServices(contents.getControllerServices());
            group.setFunnels(contents.getFunnels());
            group.setInputPorts(contents.getInputPorts());
            group.setLabels(contents.getLabels());
            group.setOutputPorts(contents.getOutputPorts());
            group.setProcessGroups(contents.getProcessGroups());
            group.setProcessors(contents.getProcessors());
            group.setRemoteProcessGroups(contents.getRemoteProcessGroups());
            group.setParameterContextName(contents.getParameterContextName());
            group.setFlowFileConcurrency(contents.getFlowFileConcurrency());
            group.setFlowFileOutboundPolicy(contents.getFlowFileOutboundPolicy());
            group.setDefaultFlowFileExpiration(contents.getDefaultFlowFileExpiration());
            group.setDefaultBackPressureObjectThreshold(contents.getDefaultBackPressureObjectThreshold());
            group.setDefaultBackPressureDataSizeThreshold(contents.getDefaultBackPressureDataSizeThreshold());
            group.setLogFileSuffix(contents.getLogFileSuffix());
            coordinates.setLatest(Boolean.valueOf(snapshot.isLatest()));
            for (Map.Entry parameterContext : snapshot.getParameterContexts().entrySet()) {
                accumulatedParameterContexts.put((String)parameterContext.getKey(), (VersionedParameterContext)parameterContext.getValue());
            }
            snapshotContainer.addChildSnapshot(snapshot, group);
        }
        for (VersionedProcessGroup child : group.getProcessGroups()) {
            Map<String, VersionedParameterContext> childParameterContexts = this.populateVersionedContentsRecursively(context, child, snapshotContainer);
            for (Map.Entry<String, VersionedParameterContext> childParameterContext : childParameterContexts.entrySet()) {
                accumulatedParameterContexts.putIfAbsent(childParameterContext.getKey(), childParameterContext.getValue());
            }
        }
        return accumulatedParameterContexts;
    }

    private RegisteredFlowSnapshot fetchFlowContents(FlowRegistryClientUserContext context, VersionedFlowCoordinates coordinates, boolean fetchRemoteFlows) throws FlowRegistryException {
        String storageLocation = coordinates.getStorageLocation();
        String branch = coordinates.getBranch();
        String bucketId = coordinates.getBucketId();
        String flowId = coordinates.getFlowId();
        String version = coordinates.getVersion();
        FlowVersionLocation flowVersionLocation = new FlowVersionLocation(branch, bucketId, flowId, version);
        List<FlowRegistryClientNode> clientNodes = this.getRegistryClientsForInternalFlow(storageLocation);
        for (FlowRegistryClientNode clientNode : clientNodes) {
            try {
                logger.debug("Attempting to fetch flow from Branch [{}] for Bucket [{}] Flow [{}] Version [{}] using {}", new Object[]{branch, bucketId, flowId, version, clientNode});
                FlowSnapshotContainer snapshotContainer = clientNode.getFlowContents(context, flowVersionLocation, fetchRemoteFlows);
                RegisteredFlowSnapshot snapshot = snapshotContainer.getFlowSnapshot();
                coordinates.setRegistryId(clientNode.getIdentifier());
                logger.debug("Successfully fetched flow from Branch [{}] for Bucket [{}] Flow [{}] Version [{}] using {}", new Object[]{branch, bucketId, flowId, version, clientNode});
                return snapshot;
            }
            catch (Exception e) {
                logger.debug("Failed to fetch flow", (Throwable)e);
            }
        }
        throw new FlowRegistryException(String.format("Could not find any Registry Client that was able to fetch flow with Branch [%s] Bucket [%s] Flow [%s] Version [%s] with Storage Location [%s]", branch, bucketId, flowId, version, storageLocation));
    }

    private List<FlowRegistryClientNode> getRegistryClientsForInternalFlow(String storageLocation) {
        ArrayList<FlowRegistryClientNode> matchingClients = new ArrayList<FlowRegistryClientNode>(this.flowManager.getAllFlowRegistryClients());
        matchingClients.sort(Comparator.comparing(client -> client.isStorageLocationApplicable(storageLocation) ? -1 : 1));
        return matchingClients;
    }

    private RegisteredFlowSnapshot createRegisteredFlowSnapshot(FlowRegistryClientUserContext context, RegisteredFlow flow, VersionedProcessGroup snapshot, Map<String, ExternalControllerServiceReference> externalControllerServices, Map<String, VersionedParameterContext> parameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, String comments, String expectedVersion) {
        RegisteredFlowSnapshotMetadata metadata = new RegisteredFlowSnapshotMetadata();
        metadata.setBranch(flow.getBranch());
        metadata.setBucketIdentifier(flow.getBucketIdentifier());
        metadata.setFlowIdentifier(flow.getIdentifier());
        metadata.setAuthor(this.extractIdentity(context));
        metadata.setTimestamp(System.currentTimeMillis());
        metadata.setVersion(expectedVersion);
        metadata.setComments(comments);
        RegisteredFlowSnapshot registeredFlowSnapshot = new RegisteredFlowSnapshot();
        registeredFlowSnapshot.setFlowContents(snapshot);
        registeredFlowSnapshot.setExternalControllerServices(externalControllerServices);
        registeredFlowSnapshot.setParameterContexts(parameterContexts);
        registeredFlowSnapshot.setFlowEncodingVersion("1.0");
        registeredFlowSnapshot.setSnapshotMetadata(metadata);
        registeredFlowSnapshot.setParameterProviders(parameterProviderReferences);
        return registeredFlowSnapshot;
    }

    private static interface FlowRegistryClientAction<T> {
        public T execute() throws FlowRegistryException, IOException;
    }
}

