/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.flow.ParameterProviderReference;
import org.apache.nifi.flow.VersionedConfigurableExtension;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedReportingTaskSnapshot;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.PythonBundle;
import org.apache.nifi.web.api.dto.BundleDTO;

public final class BundleUtils {
    static Optional<BundleCoordinate> findOptionalBundleForType(ExtensionManager extensionManager, String type, Bundle frameworkBundle) {
        List bundles = extensionManager.getBundles(type);
        if (bundles.size() == 1) {
            return Optional.of(((Bundle)bundles.get(0)).getBundleDetails().getCoordinate());
        }
        String frameworkVersion = frameworkBundle.getBundleDetails().getCoordinate().getVersion();
        for (Bundle bundle : bundles) {
            String componentVersion = bundle.getBundleDetails().getCoordinate().getVersion();
            if (!frameworkVersion.equals(componentVersion)) continue;
            return Optional.of(bundle.getBundleDetails().getCoordinate());
        }
        return Optional.empty();
    }

    private static BundleCoordinate findBundleForType(ExtensionManager extensionManager, String type, BundleCoordinate desiredCoordinate) {
        List bundles = extensionManager.getBundles(type);
        if (bundles.isEmpty()) {
            throw new IllegalStateException(String.format("%s is not known to this NiFi instance.", type));
        }
        if (bundles.size() > 1) {
            if (desiredCoordinate == null) {
                throw new IllegalStateException(String.format("Multiple versions of %s exist.", type));
            }
            throw new IllegalStateException(String.format("Multiple versions of %s exist. No exact match for %s.", type, desiredCoordinate));
        }
        return ((Bundle)bundles.get(0)).getBundleDetails().getCoordinate();
    }

    private static BundleCoordinate findCompatibleBundle(ExtensionManager extensionManager, String type, BundleDTO bundleDTO, boolean allowCompatibleBundle) {
        if (PythonBundle.isPythonCoordinate((String)bundleDTO.getGroup(), (String)bundleDTO.getArtifact())) {
            return new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
        }
        BundleCoordinate coordinate = new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
        Bundle bundle = extensionManager.getBundle(coordinate);
        if (bundle == null) {
            if (allowCompatibleBundle) {
                return BundleUtils.findBundleForType(extensionManager, type, coordinate);
            }
            throw new IllegalStateException(String.format("%s from %s is not known to this NiFi instance.", type, coordinate));
        }
        List<BundleCoordinate> bundlesForType = extensionManager.getBundles(type).stream().map(b -> b.getBundleDetails().getCoordinate()).toList();
        if (bundlesForType.contains(coordinate)) {
            return coordinate;
        }
        throw new IllegalStateException(String.format("Found bundle %s but does not support %s", coordinate, type));
    }

    private static Optional<BundleCoordinate> findOptionalCompatibleBundle(ExtensionManager extensionManager, String type, BundleDTO bundleDTO) {
        BundleCoordinate coordinate = new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
        Bundle bundle = extensionManager.getBundle(coordinate);
        if (bundle == null) {
            return BundleUtils.findOptionalBundleForType(extensionManager, type, NarClassLoadersHolder.getInstance().getFrameworkBundle());
        }
        List<BundleCoordinate> bundlesForType = extensionManager.getBundles(type).stream().map(b -> b.getBundleDetails().getCoordinate()).toList();
        if (bundlesForType.contains(coordinate)) {
            return Optional.of(coordinate);
        }
        return Optional.empty();
    }

    public static BundleCoordinate getBundle(ExtensionManager extensionManager, String type, BundleDTO bundleDTO) {
        if (bundleDTO == null) {
            return BundleUtils.findBundleForType(extensionManager, type, null);
        }
        return BundleUtils.findCompatibleBundle(extensionManager, type, bundleDTO, false);
    }

    public static BundleCoordinate getCompatibleBundle(ExtensionManager extensionManager, String type, BundleDTO bundleDTO) {
        if (bundleDTO == null) {
            return BundleUtils.findBundleForType(extensionManager, type, null);
        }
        return BundleUtils.findCompatibleBundle(extensionManager, type, bundleDTO, true);
    }

    public static Optional<BundleCoordinate> getOptionalCompatibleBundle(ExtensionManager extensionManager, String type, BundleDTO bundleDTO) {
        if (bundleDTO == null) {
            return BundleUtils.findOptionalBundleForType(extensionManager, type, NarClassLoadersHolder.getInstance().getFrameworkBundle());
        }
        return BundleUtils.findOptionalCompatibleBundle(extensionManager, type, bundleDTO);
    }

    public static void discoverCompatibleBundles(ExtensionManager extensionManager, VersionedProcessGroup versionedGroup) {
        if (versionedGroup.getProcessors() != null) {
            versionedGroup.getProcessors().forEach(processor -> BundleUtils.discoverCompatibleBundle(extensionManager, (VersionedConfigurableExtension)processor));
        }
        if (versionedGroup.getControllerServices() != null) {
            versionedGroup.getControllerServices().forEach(controllerService -> BundleUtils.discoverCompatibleBundle(extensionManager, (VersionedConfigurableExtension)controllerService));
        }
        if (versionedGroup.getProcessGroups() != null) {
            versionedGroup.getProcessGroups().forEach(processGroup -> BundleUtils.discoverCompatibleBundles(extensionManager, processGroup));
        }
    }

    public static void discoverCompatibleBundles(ExtensionManager extensionManager, VersionedReportingTaskSnapshot reportingTaskSnapshot) {
        if (reportingTaskSnapshot.getReportingTasks() != null) {
            reportingTaskSnapshot.getReportingTasks().forEach(reportingTask -> BundleUtils.discoverCompatibleBundle(extensionManager, (VersionedConfigurableExtension)reportingTask));
        }
        if (reportingTaskSnapshot.getControllerServices() != null) {
            reportingTaskSnapshot.getControllerServices().forEach(controllerService -> BundleUtils.discoverCompatibleBundle(extensionManager, (VersionedConfigurableExtension)controllerService));
        }
    }

    public static void discoverCompatibleBundles(ExtensionManager extensionManager, Map<String, ParameterProviderReference> parameterProviders) {
        if (parameterProviders != null) {
            parameterProviders.values().forEach(parameterProvider -> BundleUtils.discoverCompatibleBundle(extensionManager, parameterProvider));
        }
    }

    public static void discoverCompatibleBundle(ExtensionManager extensionManager, ParameterProviderReference parameterProviderReference) {
        BundleDTO dto = BundleUtils.createBundleDto(parameterProviderReference.getBundle());
        BundleCoordinate coordinate = BundleUtils.getOptionalCompatibleBundle(extensionManager, parameterProviderReference.getType(), dto).orElse(new BundleCoordinate(dto.getGroup(), dto.getArtifact(), dto.getVersion()));
        parameterProviderReference.setBundle(BundleUtils.createBundle(coordinate));
    }

    public static void discoverCompatibleBundle(ExtensionManager extensionManager, VersionedConfigurableExtension extension) {
        BundleDTO dto = BundleUtils.createBundleDto(extension.getBundle());
        BundleCoordinate coordinate = BundleUtils.getOptionalCompatibleBundle(extensionManager, extension.getType(), dto).orElse(new BundleCoordinate(dto.getGroup(), dto.getArtifact(), dto.getVersion()));
        extension.setBundle(BundleUtils.createBundle(coordinate));
    }

    public static BundleCoordinate discoverCompatibleBundle(ExtensionManager extensionManager, String type, org.apache.nifi.flow.Bundle bundle) {
        return BundleUtils.getCompatibleBundle(extensionManager, type, BundleUtils.createBundleDto(bundle));
    }

    private static org.apache.nifi.flow.Bundle createBundle(BundleCoordinate coordinate) {
        org.apache.nifi.flow.Bundle bundle = new org.apache.nifi.flow.Bundle();
        bundle.setArtifact(coordinate.getId());
        bundle.setGroup(coordinate.getGroup());
        bundle.setVersion(coordinate.getVersion());
        return bundle;
    }

    public static BundleDTO createBundleDto(org.apache.nifi.flow.Bundle bundle) {
        BundleDTO dto = new BundleDTO();
        dto.setArtifact(bundle.getArtifact());
        dto.setGroup(bundle.getGroup());
        dto.setVersion(bundle.getVersion());
        return dto;
    }
}

