/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.registry.extension.AbstractExtensionRegistry;
import org.apache.nifi.registry.extension.ExtensionRegistryException;
import org.apache.nifi.registry.extension.NiFiRegistryExtensionBundleMetadata;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.security.proxied.entity.StandardProxiedEntityEncoder;

public class NiFiRegistryExtensionRegistry
extends AbstractExtensionRegistry<NiFiRegistryExtensionBundleMetadata> {
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private static final String FORWARD_SLASH = "/";
    private static final String PROXIED_ENTITIES_CHAIN_HEADER = "X-ProxiedEntitiesChain";
    private static final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private HttpClient httpClient;

    public NiFiRegistryExtensionRegistry(String identifier, String url, String name, SSLContext sslContext) {
        super(identifier, url, name, sslContext);
    }

    private synchronized HttpClient getConfiguredHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        HttpClient.Builder builder = HttpClient.newBuilder();
        builder.connectTimeout(TIMEOUT);
        SSLContext sslContext = this.getSSLContext();
        if (sslContext != null) {
            builder.sslContext(sslContext);
        }
        this.httpClient = builder.build();
        return this.httpClient;
    }

    private synchronized void invalidateClient() {
        this.httpClient = null;
    }

    @Override
    public void setURL(String url) {
        super.setURL(url);
        this.invalidateClient();
    }

    public Set<NiFiRegistryExtensionBundleMetadata> getExtensionBundleMetadata(NiFiUser user) throws IOException, ExtensionRegistryException {
        URI versionsUri = this.getUri("bundles/versions");
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(versionsUri);
        try (InputStream inputStream = this.sendRequest(requestBuilder, user);){
            BundleVersionMetadata[] bundleVersions = (BundleVersionMetadata[])objectMapper.readValue(inputStream, BundleVersionMetadata[].class);
            Set<NiFiRegistryExtensionBundleMetadata> set = Arrays.stream(bundleVersions).map(this::map).collect(Collectors.toSet());
            return set;
        }
    }

    public InputStream getExtensionBundleContent(NiFiUser user, NiFiRegistryExtensionBundleMetadata bundleMetadata) throws ExtensionRegistryException {
        String bundleId = bundleMetadata.getBundleIdentifier();
        String version = bundleMetadata.getVersion();
        URI versionsUri = this.getUri("bundles/%s/versions/%s/content".formatted(bundleId, version));
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(versionsUri);
        return this.sendRequest(requestBuilder, user);
    }

    private InputStream sendRequest(HttpRequest.Builder requestBuilder, NiFiUser user) throws ExtensionRegistryException {
        HttpClient configuredHttpClient = this.getConfiguredHttpClient();
        if (user != null && !user.isAnonymous()) {
            String identity = user.getIdentity();
            String proxiedEntities = StandardProxiedEntityEncoder.getInstance().getEncodedEntity(identity);
            requestBuilder.setHeader(PROXIED_ENTITIES_CHAIN_HEADER, proxiedEntities);
        }
        requestBuilder.timeout(TIMEOUT);
        HttpRequest request = requestBuilder.build();
        URI uri = request.uri();
        try {
            HttpResponse<InputStream> response = configuredHttpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            int statusCode = response.statusCode();
            if (200 == statusCode) {
                return response.body();
            }
            throw new ExtensionRegistryException("Registry request failed with HTTP %d [%s]".formatted(statusCode, uri));
        }
        catch (IOException e) {
            throw new ExtensionRegistryException("Registry request failed [%s]".formatted(uri), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ExtensionRegistryException("Registry requested interrupted [%s]".formatted(uri), (Throwable)e);
        }
    }

    private URI getUri(String path) {
        StringBuilder builder = new StringBuilder();
        String baseUrl = this.getURL();
        builder.append(baseUrl);
        if (!baseUrl.endsWith(FORWARD_SLASH)) {
            builder.append(FORWARD_SLASH);
        }
        builder.append(path);
        return URI.create(builder.toString());
    }

    private NiFiRegistryExtensionBundleMetadata map(BundleVersionMetadata bundleVersionMetadata) {
        return new NiFiRegistryExtensionBundleMetadata.Builder().group(bundleVersionMetadata.getGroupId()).artifact(bundleVersionMetadata.getArtifactId()).version(bundleVersionMetadata.getVersion()).bundleIdentifier(bundleVersionMetadata.getBundleId()).timestamp(bundleVersionMetadata.getTimestamp()).registryIdentifier(this.getIdentifier()).build();
    }
}

