/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics.tracking;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.apache.nifi.controller.repository.metrics.NanoTimePerformanceTracker;
import org.apache.nifi.controller.repository.metrics.NopPerformanceTracker;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;
import org.apache.nifi.controller.repository.metrics.StandardFlowFileEvent;
import org.apache.nifi.controller.repository.metrics.tracking.StatsTracker;
import org.apache.nifi.controller.repository.metrics.tracking.TrackedStats;

public class StandardStatsTracker
implements StatsTracker {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final LongSupplier gcMillisTracker;
    private final LongSupplier cpuTimeMillisTracker;
    private final int iterationsBetweenCpuTracking;
    private final AtomicLong iterations = new AtomicLong(0L);
    private final AtomicReference<SampledCpuMetrics> sampledCpuMetrics = new AtomicReference<SampledCpuMetrics>(new SampledCpuMetrics(0L, 0L));

    public StandardStatsTracker(LongSupplier gcMillisTracker, int expensiveMetricsTrackingPercentage) {
        if (expensiveMetricsTrackingPercentage < 0) {
            throw new IllegalArgumentException("CPU tracking percentage must be non-negative");
        }
        if (expensiveMetricsTrackingPercentage > 100) {
            throw new IllegalArgumentException("CPU tracking percentage must be less than or equal to 100");
        }
        this.iterationsBetweenCpuTracking = expensiveMetricsTrackingPercentage == 0 ? Integer.MAX_VALUE : 100 / expensiveMetricsTrackingPercentage;
        this.gcMillisTracker = gcMillisTracker;
        this.cpuTimeMillisTracker = threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean::getCurrentThreadCpuTime : () -> 0L;
    }

    @Override
    public TrackedStats startTracking() {
        final long startTimeNanos = System.nanoTime();
        final long startGcMillis = this.gcMillisTracker.getAsLong();
        final boolean trackExpensiveMetrics = this.iterations.getAndIncrement() % (long)this.iterationsBetweenCpuTracking == 0L;
        final long startCpuTimeMillis = trackExpensiveMetrics ? this.cpuTimeMillisTracker.getAsLong() : 0L;
        final PerformanceTracker performanceTracker = trackExpensiveMetrics ? new NanoTimePerformanceTracker() : new NopPerformanceTracker();
        return new TrackedStats(){

            @Override
            public StandardFlowFileEvent end() {
                long endCpuTimeMillis = trackExpensiveMetrics ? StandardStatsTracker.this.cpuTimeMillisTracker.getAsLong() : 0L;
                StandardFlowFileEvent event = new StandardFlowFileEvent();
                event.setProcessingNanos(System.nanoTime() - startTimeNanos);
                event.setGarbageCollectionMillis(StandardStatsTracker.this.gcMillisTracker.getAsLong() - startGcMillis);
                event.setCpuNanoseconds(endCpuTimeMillis - startCpuTimeMillis);
                event.setContentReadNanoseconds(performanceTracker.getContentReadNanos());
                event.setContentWriteNanoseconds(performanceTracker.getContentWriteNanos());
                event.setSessionCommitNanos(performanceTracker.getSessionCommitNanos());
                if (trackExpensiveMetrics) {
                    StandardStatsTracker.this.addSampledCpuTime(event.getProcessingNanoseconds(), event.getCpuNanoseconds());
                } else {
                    event.setCpuNanoseconds(StandardStatsTracker.this.estimateCpuTime(event.getProcessingNanoseconds()));
                }
                return event;
            }

            @Override
            public PerformanceTracker getPerformanceTracker() {
                return performanceTracker;
            }
        };
    }

    private void addSampledCpuTime(long processingNanoseconds, long cpuNanoseconds) {
        boolean updated = false;
        while (!updated) {
            SampledCpuMetrics existingMetrics = this.sampledCpuMetrics.get();
            SampledCpuMetrics newMetrics = existingMetrics.add(processingNanoseconds, cpuNanoseconds);
            updated = this.sampledCpuMetrics.compareAndSet(existingMetrics, newMetrics);
        }
    }

    private long estimateCpuTime(long processingNanoseconds) {
        SampledCpuMetrics metrics = this.sampledCpuMetrics.get();
        if (metrics.processingNanos() == 0L) {
            return 0L;
        }
        return processingNanoseconds * metrics.cpuNanos() / metrics.processingNanos();
    }

    private record SampledCpuMetrics(long processingNanos, long cpuNanos) {
        SampledCpuMetrics add(long processingNanos, long cpuNanos) {
            return new SampledCpuMetrics(this.processingNanos + processingNanos, this.cpuNanos + cpuNanos);
        }
    }
}

