/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.flowanalysis;

import java.io.File;
import java.util.Set;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleInitializationContext;
import org.apache.nifi.logging.ComponentLog;

public class StandardFlowAnalysisInitializationContext
implements FlowAnalysisRuleInitializationContext,
ControllerServiceLookup {
    private final String id;
    private final ComponentLog logger;
    private final ControllerServiceProvider serviceProvider;
    private final KerberosConfig kerberosConfig;
    private final NodeTypeProvider nodeTypeProvider;

    public StandardFlowAnalysisInitializationContext(String id, ComponentLog logger, ControllerServiceProvider serviceProvider, KerberosConfig kerberosConfig, NodeTypeProvider nodeTypeProvider) {
        this.id = id;
        this.serviceProvider = serviceProvider;
        this.logger = logger;
        this.kerberosConfig = kerberosConfig;
        this.nodeTypeProvider = nodeTypeProvider;
    }

    public String getIdentifier() {
        return this.id;
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.serviceProvider.getControllerServiceIdentifiers(serviceType, null);
    }

    public ControllerService getControllerService(String identifier) {
        return this.serviceProvider.getControllerService(identifier);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.serviceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.serviceProvider.getControllerServiceName(serviceIdentifier);
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public String getKerberosServicePrincipal() {
        return this.kerberosConfig.getPrincipal();
    }

    public File getKerberosServiceKeytab() {
        return this.kerberosConfig.getKeytabLocation();
    }

    public File getKerberosConfigurationFile() {
        return this.kerberosConfig.getConfigFile();
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return this.nodeTypeProvider;
    }
}

