/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.synchronization;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.asset.Asset;
import org.apache.nifi.asset.AssetManager;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.Triggerable;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisRuleInstantiationException;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.encrypt.EncryptionException;
import org.apache.nifi.flow.BatchSize;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.ConnectableComponentType;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flow.ExternalControllerServiceReference;
import org.apache.nifi.flow.ParameterProviderReference;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedAsset;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.flow.VersionedFlowAnalysisRule;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedFunnel;
import org.apache.nifi.flow.VersionedLabel;
import org.apache.nifi.flow.VersionedParameter;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedPropertyDescriptor;
import org.apache.nifi.flow.VersionedRemoteGroupPort;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.flow.synchronization.ConnectableAdditionTracker;
import org.apache.nifi.flow.synchronization.FlowSynchronizationException;
import org.apache.nifi.flow.synchronization.VersionedComponentSynchronizer;
import org.apache.nifi.flow.synchronization.VersionedFlowSynchronizationContext;
import org.apache.nifi.groups.ComponentAdditions;
import org.apache.nifi.groups.ComponentIdGenerator;
import org.apache.nifi.groups.FlowFileConcurrency;
import org.apache.nifi.groups.FlowFileOutboundPolicy;
import org.apache.nifi.groups.FlowSynchronizationOptions;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.PropertyDecryptor;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.groups.StandardVersionedFlowStatus;
import org.apache.nifi.groups.VersionedComponentAdditions;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.migration.ControllerServiceFactory;
import org.apache.nifi.migration.StandardControllerServiceFactory;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterProviderConfiguration;
import org.apache.nifi.parameter.ParameterReferenceManager;
import org.apache.nifi.parameter.StandardParameterProviderConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.StandardVersionControlInformation;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.registry.flow.diff.ComparableDataFlow;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowComparatorVersionedStrategy;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.diff.StandardComparableDataFlow;
import org.apache.nifi.registry.flow.diff.StandardFlowComparator;
import org.apache.nifi.registry.flow.diff.StaticDifferenceDescriptor;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.StandardRemoteProcessGroupPortDescriptor;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FlowDifferenceFilters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardVersionedComponentSynchronizer
implements VersionedComponentSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(StandardVersionedComponentSynchronizer.class);
    private static final String TEMP_FUNNEL_ID_SUFFIX = "-temp-funnel";
    public static final String ENC_PREFIX = "enc{";
    public static final String ENC_SUFFIX = "}";
    private final VersionedFlowSynchronizationContext context;
    private final Set<String> updatedVersionedComponentIds = new HashSet<String>();
    private final List<CreatedOrModifiedExtension> createdAndModifiedExtensions = new ArrayList<CreatedOrModifiedExtension>();
    private FlowSynchronizationOptions syncOptions;
    private final ConnectableAdditionTracker connectableAdditionTracker = new ConnectableAdditionTracker();

    public StandardVersionedComponentSynchronizer(VersionedFlowSynchronizationContext context) {
        this.context = context;
    }

    public void setSynchronizationOptions(FlowSynchronizationOptions syncOptions) {
        this.syncOptions = syncOptions;
    }

    @Override
    public ComponentAdditions addVersionedComponentsToProcessGroup(ProcessGroup group, VersionedComponentAdditions additions, FlowSynchronizationOptions options) {
        this.updatedVersionedComponentIds.clear();
        this.createdAndModifiedExtensions.clear();
        this.setSynchronizationOptions(options);
        ComponentAdditions.Builder additionsBuilder = new ComponentAdditions.Builder();
        HashMap instanceMapping = new HashMap();
        additions.getControllerServices().forEach(controllerService -> {
            ControllerServiceNode newService = this.addControllerService(group, (VersionedControllerService)controllerService, options.getComponentIdGenerator(), group);
            instanceMapping.put(controllerService, newService);
            additionsBuilder.addControllerService(newService);
        });
        additions.getControllerServices().forEach(controllerService -> {
            ControllerServiceNode newService = (ControllerServiceNode)instanceMapping.get(controllerService);
            if (newService != null) {
                this.updateControllerService(newService, (VersionedControllerService)controllerService, group);
            }
        });
        additions.getProcessors().forEach(processor -> {
            try {
                ProcessorNode newProcessor = this.addProcessor(group, (VersionedProcessor)processor, options.getComponentIdGenerator(), group);
                additionsBuilder.addProcessor(newProcessor);
            }
            catch (ProcessorInstantiationException pie) {
                throw new RuntimeException(pie);
            }
        });
        HashMap<Port, String> proposedPortFinalNames = new HashMap<Port, String>();
        Set existingInputPorts = group.getInputPorts().stream().map(Connectable::getName).collect(Collectors.toSet());
        Set existingOutputPorts = group.getOutputPorts().stream().map(Connectable::getName).collect(Collectors.toSet());
        additions.getInputPorts().forEach(inputPort -> {
            if (group.isRootGroup()) {
                inputPort.setAllowRemoteAccess(Boolean.valueOf(true));
            }
            String temporaryName = this.generateTemporaryPortName((VersionedPort)inputPort);
            Port newInputPort = this.addInputPort(group, (VersionedPort)inputPort, options.getComponentIdGenerator(), temporaryName);
            if (!existingInputPorts.contains(inputPort.getName())) {
                proposedPortFinalNames.put(newInputPort, inputPort.getName());
            }
            additionsBuilder.addInputPort(newInputPort);
        });
        additions.getOutputPorts().forEach(outputPort -> {
            if (group.isRootGroup()) {
                outputPort.setAllowRemoteAccess(Boolean.valueOf(true));
            }
            String temporaryName = this.generateTemporaryPortName((VersionedPort)outputPort);
            Port newOutputPort = this.addOutputPort(group, (VersionedPort)outputPort, options.getComponentIdGenerator(), temporaryName);
            if (!existingOutputPorts.contains(outputPort.getName())) {
                proposedPortFinalNames.put(newOutputPort, outputPort.getName());
            }
            additionsBuilder.addOutputPort(newOutputPort);
        });
        additions.getLabels().forEach(label -> {
            Label newLabel = this.addLabel(group, (VersionedLabel)label, options.getComponentIdGenerator());
            additionsBuilder.addLabel(newLabel);
        });
        additions.getFunnels().forEach(funnel -> {
            Funnel newFunnel = this.addFunnel(group, (VersionedFunnel)funnel, options.getComponentIdGenerator());
            additionsBuilder.addFunnel(newFunnel);
        });
        additions.getRemoteProcessGroups().forEach(remoteProcessGroup -> {
            RemoteProcessGroup newRemoteProcessGroup = this.addRemoteProcessGroup(group, (VersionedRemoteProcessGroup)remoteProcessGroup, options.getComponentIdGenerator());
            additionsBuilder.addRemoteProcessGroup(newRemoteProcessGroup);
        });
        additions.getProcessGroups().forEach(processGroup -> {
            try {
                ProcessGroup newProcessGroup = this.addProcessGroup(group, (VersionedProcessGroup)processGroup, options.getComponentIdGenerator(), additions.getParameterContexts(), additions.getParameterProviders(), group);
                additionsBuilder.addProcessGroup(newProcessGroup);
            }
            catch (ProcessorInstantiationException pie) {
                throw new RuntimeException(pie);
            }
        });
        additions.getConnections().forEach(connection -> {
            if (connection.getSource() != null) {
                connection.getSource().setInstanceIdentifier(null);
            }
            if (connection.getDestination() != null) {
                connection.getDestination().setInstanceIdentifier(null);
            }
            Connection newConnection = this.addConnection(group, (VersionedConnection)connection, options.getComponentIdGenerator());
            additionsBuilder.addConnection(newConnection);
        });
        this.updatePortsToFinalNames(proposedPortFinalNames);
        for (CreatedOrModifiedExtension createdOrModifiedExtension : this.createdAndModifiedExtensions) {
            ComponentNode extension = createdOrModifiedExtension.extension();
            Map<String, String> originalPropertyValues = createdOrModifiedExtension.propertyValues();
            StandardControllerServiceFactory serviceFactory = new StandardControllerServiceFactory(this.context.getExtensionManager(), this.context.getFlowManager(), this.context.getControllerServiceProvider(), extension);
            if (extension instanceof ProcessorNode) {
                ProcessorNode processor2 = (ProcessorNode)extension;
                processor2.migrateConfiguration(originalPropertyValues, (ControllerServiceFactory)serviceFactory);
                continue;
            }
            if (!(extension instanceof ControllerServiceNode)) continue;
            ControllerServiceNode service = (ControllerServiceNode)extension;
            service.migrateConfiguration(originalPropertyValues, (ControllerServiceFactory)serviceFactory);
        }
        return additionsBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(ProcessGroup group, VersionedExternalFlow versionedExternalFlow, FlowSynchronizationOptions options) {
        NiFiRegistryFlowMapper mapper = new NiFiRegistryFlowMapper(this.context.getExtensionManager(), this.context.getFlowMappingOptions());
        InstantiatedVersionedProcessGroup versionedGroup = mapper.mapProcessGroup(group, this.context.getControllerServiceProvider(), this.context.getFlowManager(), true);
        StandardComparableDataFlow localFlow = new StandardComparableDataFlow("Currently Loaded Flow", (VersionedProcessGroup)versionedGroup);
        StandardComparableDataFlow proposedFlow = new StandardComparableDataFlow("Proposed Flow", versionedExternalFlow.getFlowContents());
        PropertyDecryptor decryptor = options.getPropertyDecryptor();
        StandardFlowComparator flowComparator = new StandardFlowComparator((ComparableDataFlow)localFlow, (ComparableDataFlow)proposedFlow, group.getAncestorServiceIds(), (DifferenceDescriptor)new StaticDifferenceDescriptor(), arg_0 -> ((PropertyDecryptor)decryptor).decrypt(arg_0), options.getComponentComparisonIdLookup(), FlowComparatorVersionedStrategy.DEEP);
        FlowComparison flowComparison = flowComparator.compare();
        this.updatedVersionedComponentIds.clear();
        this.createdAndModifiedExtensions.clear();
        this.setSynchronizationOptions(options);
        for (FlowDifference diff : flowComparison.getDifferences()) {
            VersionedComponent component;
            if (FlowDifferenceFilters.isPropertyMissingFromGhostComponent(diff, this.context.getFlowManager()) || FlowDifferenceFilters.isScheduledStateNew(diff)) continue;
            if (diff.getDifferenceType() == DifferenceType.COMPONENT_ADDED) {
                ControllerServiceNode serviceNode;
                VersionedComponent versionedComponent = component = diff.getComponentA() == null ? diff.getComponentB() : diff.getComponentA();
                if (ComponentType.CONTROLLER_SERVICE == component.getComponentType() && (serviceNode = this.getVersionedControllerService(group, component.getIdentifier())) != null) {
                    VersionedControllerService versionedService = mapper.mapControllerService(serviceNode, this.context.getControllerServiceProvider(), Collections.singleton(serviceNode.getProcessGroupIdentifier()), new HashMap<String, ExternalControllerServiceReference>());
                    Set differences = flowComparator.compareControllerServices(versionedService, (VersionedControllerService)component);
                    if (differences.isEmpty()) continue;
                    this.updatedVersionedComponentIds.add(component.getIdentifier());
                    continue;
                }
            }
            if (diff.getDifferenceType() == DifferenceType.POSITION_CHANGED) continue;
            component = diff.getComponentA() == null ? diff.getComponentB() : diff.getComponentA();
            this.updatedVersionedComponentIds.add(component.getIdentifier());
            if (component.getComponentType() != ComponentType.REMOTE_INPUT_PORT && component.getComponentType() != ComponentType.REMOTE_OUTPUT_PORT) continue;
            String remoteGroupId = ((VersionedRemoteGroupPort)component).getRemoteGroupId();
            this.updatedVersionedComponentIds.add(remoteGroupId);
        }
        if (LOG.isInfoEnabled()) {
            Set differences = flowComparison.getDifferences();
            if (differences.isEmpty()) {
                LOG.info("No differences between current flow and proposed flow for {}", (Object)group);
            } else {
                String differencesByLine = differences.stream().map(FlowDifference::toString).collect(Collectors.joining("\n"));
                LOG.info("Updating {} to {}; there are {} differences to take into account:\n{}", new Object[]{group, versionedExternalFlow, differences.size(), differencesByLine});
            }
        }
        this.context.getComponentScheduler().pause();
        try {
            this.context.getFlowManager().withParameterContextResolution(() -> {
                try {
                    HashMap<String, ParameterProviderReference> parameterProviderReferences = versionedExternalFlow.getParameterProviders() == null ? new HashMap() : versionedExternalFlow.getParameterProviders();
                    ProcessGroup topLevelGroup = this.syncOptions.getTopLevelGroupId() == null ? group : this.context.getFlowManager().getGroup(this.syncOptions.getTopLevelGroupId());
                    this.synchronize(group, versionedExternalFlow.getFlowContents(), versionedExternalFlow.getParameterContexts(), parameterProviderReferences, topLevelGroup, this.syncOptions.isUpdateSettings());
                }
                catch (ProcessorInstantiationException pie) {
                    throw new RuntimeException(pie);
                }
            });
            for (CreatedOrModifiedExtension createdOrModifiedExtension : this.createdAndModifiedExtensions) {
                ComponentNode extension = createdOrModifiedExtension.extension();
                Map<String, String> originalPropertyValues = createdOrModifiedExtension.propertyValues();
                StandardControllerServiceFactory serviceFactory = new StandardControllerServiceFactory(this.context.getExtensionManager(), this.context.getFlowManager(), this.context.getControllerServiceProvider(), extension);
                if (extension instanceof ProcessorNode) {
                    ProcessorNode processor = (ProcessorNode)extension;
                    processor.migrateConfiguration(originalPropertyValues, (ControllerServiceFactory)serviceFactory);
                    continue;
                }
                if (extension instanceof ControllerServiceNode) {
                    ControllerServiceNode service = (ControllerServiceNode)extension;
                    service.migrateConfiguration(originalPropertyValues, (ControllerServiceFactory)serviceFactory);
                    continue;
                }
                if (!(extension instanceof ReportingTaskNode)) continue;
                ReportingTaskNode task = (ReportingTaskNode)extension;
                task.migrateConfiguration(originalPropertyValues, (ControllerServiceFactory)serviceFactory);
            }
        }
        finally {
            this.context.getComponentScheduler().resume();
        }
        group.onComponentModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronize(ProcessGroup group, VersionedProcessGroup proposed, Map<String, VersionedParameterContext> versionedParameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, ProcessGroup topLevelGroup, boolean updateGroupSettings) throws ProcessorInstantiationException {
        VersionedFlowCoordinates remoteCoordinates;
        String statelessTimeout;
        Integer maxConcurrentTasks;
        ExecutionEngine proposedExecutionEngine;
        boolean proposedParameterContextExistsBeforeSynchronize;
        this.context.getComponentScheduler().pause();
        group.setComments(proposed.getComments());
        if (updateGroupSettings) {
            if (proposed.getName() != null) {
                group.setName(proposed.getName());
            }
            if (proposed.getPosition() != null) {
                group.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
            }
        }
        boolean bl = proposedParameterContextExistsBeforeSynchronize = this.getParameterContextByName(proposed.getParameterContextName()) != null;
        if (versionedParameterContexts != null) {
            versionedParameterContexts.values().forEach(this::createParameterContextWithoutReferences);
        }
        this.updateParameterContext(group, proposed, versionedParameterContexts, parameterProviderReferences, this.context.getComponentIdGenerator());
        FlowFileConcurrency flowFileConcurrency = proposed.getFlowFileConcurrency() == null ? FlowFileConcurrency.UNBOUNDED : FlowFileConcurrency.valueOf((String)proposed.getFlowFileConcurrency());
        group.setFlowFileConcurrency(flowFileConcurrency);
        FlowFileOutboundPolicy outboundPolicy = proposed.getFlowFileOutboundPolicy() == null ? FlowFileOutboundPolicy.STREAM_WHEN_AVAILABLE : FlowFileOutboundPolicy.valueOf((String)proposed.getFlowFileOutboundPolicy());
        group.setFlowFileOutboundPolicy(outboundPolicy);
        group.setDefaultFlowFileExpiration(proposed.getDefaultFlowFileExpiration());
        group.setDefaultBackPressureObjectThreshold(proposed.getDefaultBackPressureObjectThreshold());
        group.setDefaultBackPressureDataSizeThreshold(proposed.getDefaultBackPressureDataSizeThreshold());
        if (group.getLogFileSuffix() == null || group.getLogFileSuffix().isEmpty()) {
            group.setLogFileSuffix(proposed.getLogFileSuffix());
        }
        if ((proposedExecutionEngine = proposed.getExecutionEngine()) != null) {
            group.setExecutionEngine(proposedExecutionEngine);
        }
        if ((maxConcurrentTasks = proposed.getMaxConcurrentTasks()) != null) {
            group.setMaxConcurrentTasks(maxConcurrentTasks.intValue());
        }
        if ((statelessTimeout = proposed.getStatelessFlowTimeout()) != null) {
            group.setStatelessFlowTimeout(statelessTimeout);
        }
        if (proposed.getScheduledState() != null && org.apache.nifi.controller.ScheduledState.RUNNING.name().equals(proposed.getScheduledState().name())) {
            this.context.getComponentScheduler().startStatelessGroup(group);
        }
        if ((remoteCoordinates = proposed.getVersionedFlowCoordinates()) == null) {
            group.disconnectVersionControl(false);
        } else {
            VersionedFlowState flowState;
            String registryName;
            String registryId = this.determineRegistryId(remoteCoordinates);
            String branch = remoteCoordinates.getBranch();
            String bucketId = remoteCoordinates.getBucketId();
            String flowId = remoteCoordinates.getFlowId();
            String version = remoteCoordinates.getVersion();
            String storageLocation = remoteCoordinates.getStorageLocation();
            FlowRegistryClientNode flowRegistry = this.context.getFlowManager().getFlowRegistryClient(registryId);
            String string = registryName = flowRegistry == null ? registryId : flowRegistry.getName();
            if (remoteCoordinates.getLatest() == null) {
                flowState = VersionedFlowState.SYNC_FAILURE;
            } else {
                VersionedFlowState versionedFlowState = flowState = remoteCoordinates.getLatest() != false ? VersionedFlowState.UP_TO_DATE : VersionedFlowState.STALE;
            }
            if (registryId != null) {
                StandardVersionControlInformation vci = new StandardVersionControlInformation.Builder().registryId(registryId).registryName(registryName).branch(branch).bucketId(bucketId).bucketName(bucketId).flowId(flowId).storageLocation(storageLocation).flowName(flowId).version(version).flowSnapshot((VersionedProcessGroup)(this.syncOptions.isUpdateGroupVersionControlSnapshot() ? proposed : null)).status(new StandardVersionedFlowStatus(flowState, flowState.getDescription())).build();
                group.setVersionControlInformation((VersionControlInformation)vci, Collections.emptyMap());
            }
        }
        HashMap<Port, String> proposedPortFinalNames = new HashMap<Port, String>();
        Map<String, ControllerServiceNode> controllerServicesByVersionedId = this.componentsById(group, grp -> grp.getControllerServices(false), ComponentNode::getIdentifier, org.apache.nifi.components.VersionedComponent::getVersionedComponentId);
        this.removeMissingControllerServices(group, proposed, controllerServicesByVersionedId);
        this.synchronizeControllerServices(group, proposed, controllerServicesByVersionedId, topLevelGroup);
        Map<String, Connection> connectionsByVersionedId = this.componentsById(group, ProcessGroup::getConnections, Connection::getIdentifier, org.apache.nifi.components.VersionedComponent::getVersionedComponentId);
        this.removeMissingConnections(group, proposed, connectionsByVersionedId);
        Set<String> connectionsWithTempDestination = this.updateConnectionDestinations(group, proposed, connectionsByVersionedId);
        try {
            try {
                Map<String, Funnel> funnelsByVersionedId = this.componentsById(group, ProcessGroup::getFunnels);
                Map<String, ProcessorNode> processorsByVersionedId = this.componentsById(group, ProcessGroup::getProcessors);
                Map<String, Port> inputPortsByVersionedId = this.componentsById(group, ProcessGroup::getInputPorts);
                Map<String, Port> outputPortsByVersionedId = this.componentsById(group, ProcessGroup::getOutputPorts);
                Map<String, Label> labelsByVersionedId = this.componentsById(group, ProcessGroup::getLabels, Label::getIdentifier, org.apache.nifi.components.VersionedComponent::getVersionedComponentId);
                Map<String, RemoteProcessGroup> rpgsByVersionedId = this.componentsById(group, ProcessGroup::getRemoteProcessGroups, RemoteProcessGroup::getIdentifier, org.apache.nifi.components.VersionedComponent::getVersionedComponentId);
                Map<String, ProcessGroup> childGroupsByVersionedId = this.componentsById(group, ProcessGroup::getProcessGroups, ProcessGroup::getIdentifier, org.apache.nifi.components.VersionedComponent::getVersionedComponentId);
                this.removeMissingProcessors(group, proposed, processorsByVersionedId);
                this.removeMissingFunnels(group, proposed, funnelsByVersionedId);
                this.removeMissingInputPorts(group, proposed, inputPortsByVersionedId);
                this.removeMissingOutputPorts(group, proposed, outputPortsByVersionedId);
                this.removeMissingLabels(group, proposed, labelsByVersionedId);
                this.removeMissingRpg(group, proposed, rpgsByVersionedId);
                this.removeMissingChildGroups(group, proposed, childGroupsByVersionedId);
                this.synchronizeChildGroups(group, proposed, versionedParameterContexts, childGroupsByVersionedId, parameterProviderReferences, topLevelGroup);
                this.synchronizeFunnels(group, proposed, funnelsByVersionedId);
                this.synchronizeInputPorts(group, proposed, proposedPortFinalNames, inputPortsByVersionedId);
                this.synchronizeOutputPorts(group, proposed, proposedPortFinalNames, outputPortsByVersionedId);
                this.synchronizeLabels(group, proposed, labelsByVersionedId);
                this.synchronizeProcessors(group, proposed, processorsByVersionedId, topLevelGroup);
                this.synchronizeRemoteGroups(group, proposed, rpgsByVersionedId);
            }
            finally {
                this.restoreConnectionDestinations(group, proposed, connectionsByVersionedId, connectionsWithTempDestination);
            }
            HashMap newParameters = new HashMap();
            if (!proposedParameterContextExistsBeforeSynchronize && this.context.getFlowMappingOptions().isMapControllerServiceReferencesToVersionedId()) {
                Map<String, String> controllerServiceVersionedIdToId = group.getControllerServices(false).stream().filter(controllerServiceNode -> controllerServiceNode.getVersionedComponentId().isPresent()).collect(Collectors.toMap(controllerServiceNode -> (String)controllerServiceNode.getVersionedComponentId().get(), ComponentNode::getIdentifier));
                ParameterContext parameterContext = group.getParameterContext();
                if (parameterContext != null) {
                    parameterContext.getParameters().forEach((descriptor, parameter) -> {
                        List referencedControllerServiceData = parameterContext.getParameterReferenceManager().getReferencedControllerServiceData(parameterContext, descriptor.getName());
                        if (referencedControllerServiceData.isEmpty()) {
                            newParameters.put(descriptor.getName(), parameter);
                        } else {
                            Parameter adjustedParameter = new Parameter.Builder().fromParameter(parameter).value((String)controllerServiceVersionedIdToId.get(parameter.getValue())).build();
                            newParameters.put(descriptor.getName(), adjustedParameter);
                        }
                    });
                    parameterContext.setParameters(newParameters);
                }
            }
            this.synchronizeConnections(group, proposed, connectionsByVersionedId);
            this.updatePortsToFinalNames(proposedPortFinalNames);
            this.context.getComponentScheduler().resume();
        }
        finally {
            this.removeTemporaryFunnel(group);
        }
    }

    private String determineRegistryId(VersionedFlowCoordinates coordinates) {
        String explicitRegistryId = coordinates.getRegistryId();
        if (explicitRegistryId != null) {
            FlowRegistryClientNode clientNode = this.context.getFlowManager().getFlowRegistryClient(explicitRegistryId);
            if (clientNode == null) {
                LOG.debug("Encountered Versioned Flow Coordinates with a Client Registry ID of {} but that Registry ID does not exist. Will check for an applicable Registry Client", (Object)explicitRegistryId);
            } else {
                return explicitRegistryId;
            }
        }
        String location = coordinates.getStorageLocation();
        for (FlowRegistryClientNode flowRegistryClientNode : this.context.getFlowManager().getAllFlowRegistryClients()) {
            boolean locationApplicable;
            try {
                locationApplicable = flowRegistryClientNode.isStorageLocationApplicable(location);
            }
            catch (Exception e) {
                LOG.error("Unable to determine if {} is an applicable Flow Registry Client for storage location {}", new Object[]{flowRegistryClientNode, location, e});
                continue;
            }
            if (!locationApplicable) continue;
            LOG.debug("Found Flow Registry Client {} that is applicable for storage location {}", (Object)flowRegistryClientNode, (Object)location);
            return flowRegistryClientNode.getIdentifier();
        }
        LOG.debug("Found no Flow Registry Client that is applicable for storage location {}; will return explicitly specified Registry ID {}", (Object)location, (Object)explicitRegistryId);
        return explicitRegistryId;
    }

    private void synchronizeChildGroups(ProcessGroup group, VersionedProcessGroup proposed, Map<String, VersionedParameterContext> versionedParameterContexts, Map<String, ProcessGroup> childGroupsByVersionedId, Map<String, ParameterProviderReference> parameterProviderReferences, ProcessGroup topLevelGroup) throws ProcessorInstantiationException {
        for (VersionedProcessGroup proposedChildGroup : proposed.getProcessGroups()) {
            ProcessGroup childGroup = childGroupsByVersionedId.get(proposedChildGroup.getIdentifier());
            VersionedFlowCoordinates childCoordinates = proposedChildGroup.getVersionedFlowCoordinates();
            if (childGroup == null) {
                ProcessGroup added = this.addProcessGroup(group, proposedChildGroup, this.context.getComponentIdGenerator(), versionedParameterContexts, parameterProviderReferences, topLevelGroup);
                this.context.getFlowManager().onProcessGroupAdded(added);
                added.findAllRemoteProcessGroups().forEach(RemoteProcessGroup::initialize);
                LOG.info("Added {} to {}", (Object)added, (Object)group);
                continue;
            }
            if (childCoordinates != null && !this.syncOptions.isUpdateDescendantVersionedFlows()) continue;
            this.synchronize(childGroup, proposedChildGroup, versionedParameterContexts, parameterProviderReferences, topLevelGroup, true);
            LOG.info("Updated {}", (Object)childGroup);
        }
    }

    private void synchronizeControllerServices(ProcessGroup group, VersionedProcessGroup proposed, Map<String, ControllerServiceNode> servicesByVersionedId, ProcessGroup topLevelGroup) {
        HashMap<ControllerServiceNode, VersionedControllerService> services = new HashMap<ControllerServiceNode, VersionedControllerService>();
        HashMap<String, ControllerServiceNode> servicesAdded = new HashMap<String, ControllerServiceNode>();
        for (VersionedControllerService versionedControllerService : proposed.getControllerServices()) {
            ControllerServiceNode service2 = servicesByVersionedId.get(versionedControllerService.getIdentifier());
            if (service2 == null) {
                service2 = this.addControllerService(group, versionedControllerService, this.context.getComponentIdGenerator(), topLevelGroup);
                LOG.info("Added {} to {}", (Object)service2, (Object)group);
                servicesAdded.put(versionedControllerService.getIdentifier(), service2);
            }
            services.put(service2, versionedControllerService);
        }
        for (VersionedControllerService versionedControllerService : proposed.getControllerServices()) {
            ControllerServiceNode addedService = (ControllerServiceNode)servicesAdded.get(versionedControllerService.getIdentifier());
            if (addedService == null) continue;
            this.updateControllerService(addedService, versionedControllerService, topLevelGroup);
        }
        for (Map.Entry entry : services.entrySet()) {
            ControllerServiceNode service2 = (ControllerServiceNode)entry.getKey();
            VersionedControllerService proposedService = (VersionedControllerService)entry.getValue();
            if (!this.updatedVersionedComponentIds.contains(proposedService.getIdentifier())) continue;
            this.updateControllerService(service2, proposedService, topLevelGroup);
            this.createdAndModifiedExtensions.add(new CreatedOrModifiedExtension((ComponentNode)service2, this.getPropertyValues((ComponentNode)service2)));
            LOG.info("Updated {}", (Object)service2);
        }
        HashSet<ControllerServiceNode> toEnable = new HashSet<ControllerServiceNode>();
        for (Map.Entry entry : services.entrySet()) {
            if (((VersionedControllerService)entry.getValue()).getScheduledState() != ScheduledState.ENABLED) continue;
            toEnable.add((ControllerServiceNode)entry.getKey());
        }
        toEnable.forEach(ComponentNode::performValidation);
        toEnable.forEach(service -> {
            if (service.getState() == ControllerServiceState.DISABLED) {
                this.context.getComponentScheduler().enableControllerServicesAsync(Collections.singleton(service));
            }
        });
    }

    private void removeMissingConnections(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Connection> connectionsByVersionedId) {
        HashSet<String> connectionsRemoved = new HashSet<String>(connectionsByVersionedId.keySet());
        HashSet<String> connectionsRemovedDueToChangingSourceId = new HashSet<String>();
        for (VersionedConnection proposedConnection : proposed.getConnections()) {
            connectionsRemoved.remove(proposedConnection.getIdentifier());
        }
        for (VersionedConnection proposedConnection : proposed.getConnections()) {
            Connection existingConnection = connectionsByVersionedId.get(proposedConnection.getIdentifier());
            if (existingConnection == null) continue;
            String proposedSourceId = proposedConnection.getSource().getId();
            String existingSourceId = existingConnection.getSource().getVersionedComponentId().orElse(null);
            if (existingSourceId == null || Objects.equals(proposedSourceId, existingSourceId)) continue;
            connectionsRemovedDueToChangingSourceId.add(proposedConnection.getIdentifier());
            connectionsRemoved.add(proposedConnection.getIdentifier());
        }
        for (String removedVersionedId : connectionsRemoved) {
            Connection connection = connectionsByVersionedId.get(removedVersionedId);
            LOG.info("Removing {} from {}", (Object)connection, (Object)group);
            group.removeConnection(connection);
        }
        for (String removedVersionedId : connectionsRemovedDueToChangingSourceId) {
            connectionsByVersionedId.remove(removedVersionedId);
        }
    }

    private void synchronizeConnections(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Connection> connectionsByVersionedId) {
        for (VersionedConnection proposedConnection : proposed.getConnections()) {
            Connection connection = connectionsByVersionedId.get(proposedConnection.getIdentifier());
            if (connection == null) {
                Connection added = this.addConnection(group, proposedConnection, this.context.getComponentIdGenerator());
                this.context.getFlowManager().onConnectionAdded(added);
                LOG.info("Added {} to {}", (Object)added, (Object)group);
                continue;
            }
            if (!this.isUpdateable(connection)) continue;
            this.updateConnection(connection, proposedConnection);
            LOG.info("Updated {}", (Object)connection);
        }
    }

    private Set<String> updateConnectionDestinations(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Connection> connectionsByVersionedId) {
        HashSet<String> connectionsWithTempDestination = new HashSet<String>();
        for (VersionedConnection proposedConnection : proposed.getConnections()) {
            Connection connection = connectionsByVersionedId.get(proposedConnection.getIdentifier());
            if (connection == null) continue;
            String destinationVersionId = connection.getDestination().getVersionedComponentId().orElse(null);
            String proposedDestinationId = proposedConnection.getDestination().getId();
            Connectable newDestination = this.getConnectable(group, proposedConnection.getDestination());
            boolean newDestinationReachableFromSource = this.isConnectionDestinationReachable(connection.getSource(), newDestination);
            if (Objects.equals(destinationVersionId, proposedDestinationId) && newDestinationReachableFromSource) continue;
            boolean useTempDestination = this.isTempDestinationNecessary(connection, proposedConnection, newDestination);
            if (useTempDestination) {
                Funnel temporaryDestination = this.getTemporaryFunnel(connection.getProcessGroup());
                LOG.debug("Updated Connection {} to have a temporary destination of {}", (Object)connection, (Object)temporaryDestination);
                newDestination = temporaryDestination;
                connectionsWithTempDestination.add(proposedConnection.getIdentifier());
            }
            LOG.debug("Changing destination of Connection {} from {} to {}", new Object[]{connection, connection.getDestination(), newDestination});
            connection.setDestination(newDestination);
        }
        return connectionsWithTempDestination;
    }

    private boolean isConnectionDestinationReachable(Connectable source, Connectable destination) {
        if (source == null || destination == null) {
            return false;
        }
        if (source.getConnectableType() == ConnectableType.OUTPUT_PORT) {
            if (destination.getConnectableType() == ConnectableType.INPUT_PORT) {
                return Objects.equals(source.getProcessGroup().getParent(), destination.getProcessGroup().getParent());
            }
            return Objects.equals(source.getProcessGroup().getParent(), destination.getProcessGroup());
        }
        return Objects.equals(source.getProcessGroup(), destination.getProcessGroup());
    }

    private boolean isTempDestinationNecessary(Connection existingConnection, VersionedConnection proposedConnection, Connectable newDestination) {
        String destinationGroupVersionedComponentId;
        boolean groupChanged;
        if (newDestination == null) {
            LOG.debug("Will use a temporary destination for {} because its destination doesn't yet exist", (Object)existingConnection);
            return true;
        }
        ConnectableType connectableType = newDestination.getConnectableType();
        boolean port = connectableType == ConnectableType.OUTPUT_PORT || connectableType == ConnectableType.INPUT_PORT;
        boolean bl = groupChanged = !newDestination.getProcessGroup().equals((Object)existingConnection.getDestination().getProcessGroup());
        if (port && groupChanged) {
            LOG.debug("Will use a temporary destination for {} because its destination is a port whose group has changed", (Object)existingConnection);
            return true;
        }
        String proposedDestinationGroupId = proposedConnection.getDestination().getGroupId();
        if (!Objects.equals(proposedDestinationGroupId, destinationGroupVersionedComponentId = this.getVersionedId(existingConnection.getDestination().getProcessGroup()))) {
            LOG.debug("Will use a temporary destination for {} because its destination has a different group than the existing group. Existing group ID is [{}] (instance ID of [{}]); proposed is [{}]", new Object[]{existingConnection, destinationGroupVersionedComponentId, existingConnection.getProcessGroup().getIdentifier(), proposedDestinationGroupId});
            return true;
        }
        String connectionGroupVersionedComponentId = this.getVersionedId(existingConnection.getProcessGroup());
        String proposedGroupId = proposedConnection.getGroupIdentifier();
        if (!Objects.equals(proposedGroupId, connectionGroupVersionedComponentId)) {
            LOG.debug("Will use a temporary destination for {} because it has a different group than the existing group. Existing group ID is [{}]; proposed is [{}]", new Object[]{existingConnection, connectionGroupVersionedComponentId, proposedGroupId});
            return true;
        }
        return false;
    }

    private String getVersionedId(ProcessGroup processGroup) {
        return this.getVersionedId(processGroup.getIdentifier(), processGroup.getVersionedComponentId().orElse(null));
    }

    private String getVersionedId(String instanceId, String versionedId) {
        if (versionedId != null) {
            return versionedId;
        }
        return this.context.getFlowMappingOptions().getComponentIdLookup().getComponentId(Optional.empty(), instanceId);
    }

    private Funnel getTemporaryFunnel(ProcessGroup group) {
        String tempFunnelId = group.getIdentifier() + TEMP_FUNNEL_ID_SUFFIX;
        Funnel temporaryFunnel = this.context.getFlowManager().getFunnel(tempFunnelId);
        if (temporaryFunnel == null) {
            temporaryFunnel = this.context.getFlowManager().createFunnel(tempFunnelId);
            temporaryFunnel.setPosition(new Position(0.0, 0.0));
            group.addFunnel(temporaryFunnel, false);
        }
        return temporaryFunnel;
    }

    private void restoreConnectionDestinations(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Connection> connectionsByVersionedId, Set<String> connectionsWithTempDestination) {
        if (connectionsWithTempDestination.isEmpty()) {
            LOG.debug("No connections with temporary destinations for {}", (Object)group);
            return;
        }
        Map versionedConnectionsById = proposed.getConnections().stream().collect(Collectors.toMap(VersionedComponent::getIdentifier, Function.identity()));
        for (String connectionId : connectionsWithTempDestination) {
            Connection connection = connectionsByVersionedId.get(connectionId);
            VersionedConnection versionedConnection = (VersionedConnection)versionedConnectionsById.get(connectionId);
            Connectable newDestination = this.getConnectable(group, versionedConnection.getDestination());
            if (newDestination == null) continue;
            LOG.debug("Updated Connection {} from its temporary destination to its correct destination of {}", (Object)connection, (Object)newDestination);
            connection.setDestination(newDestination);
        }
    }

    private void removeTemporaryFunnel(ProcessGroup group) {
        String tempFunnelId = group.getIdentifier() + TEMP_FUNNEL_ID_SUFFIX;
        Funnel temporaryFunnel = this.context.getFlowManager().getFunnel(tempFunnelId);
        if (temporaryFunnel == null) {
            LOG.debug("No temporary funnel to remove for {}", (Object)group);
            return;
        }
        if (temporaryFunnel.getIncomingConnections().isEmpty()) {
            LOG.debug("Updated all temporary connections for {}. Removing Temporary funnel from flow", (Object)group);
            group.removeFunnel(temporaryFunnel);
        } else {
            LOG.warn("The temporary funnel {} for {} still has {} connections. It cannot be removed.", new Object[]{temporaryFunnel, group, temporaryFunnel.getIncomingConnections().size()});
        }
    }

    private <T extends Connectable> Map<String, T> componentsById(ProcessGroup group, Function<ProcessGroup, Collection<T>> retrieveComponents) {
        return retrieveComponents.apply(group).stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(component.getIdentifier())), Function.identity()));
    }

    private <T> Map<String, T> componentsById(ProcessGroup group, Function<ProcessGroup, Collection<T>> retrieveComponents, Function<T, String> retrieveId, Function<T, Optional<String>> retrieveVersionedComponentId) {
        return retrieveComponents.apply(group).stream().collect(Collectors.toMap(component -> ((Optional)retrieveVersionedComponentId.apply(component)).orElse(NiFiRegistryFlowMapper.generateVersionedComponentId((String)retrieveId.apply(component))), Function.identity()));
    }

    private void synchronizeFunnels(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Funnel> funnelsByVersionedId) {
        for (VersionedFunnel proposedFunnel : proposed.getFunnels()) {
            Funnel funnel = funnelsByVersionedId.get(proposedFunnel.getIdentifier());
            if (funnel == null) {
                Funnel added = this.addFunnel(group, proposedFunnel, this.context.getComponentIdGenerator());
                this.context.getFlowManager().onFunnelAdded(added);
                LOG.info("Added {} to {}", (Object)added, (Object)group);
                continue;
            }
            if (this.updatedVersionedComponentIds.contains(proposedFunnel.getIdentifier())) {
                this.updateFunnel(funnel, proposedFunnel);
                LOG.info("Updated {}", (Object)funnel);
                continue;
            }
            funnel.setPosition(new Position(proposedFunnel.getPosition().getX(), proposedFunnel.getPosition().getY()));
        }
    }

    private void synchronizeInputPorts(ProcessGroup group, VersionedProcessGroup proposed, Map<Port, String> proposedPortFinalNames, Map<String, Port> inputPortsByVersionedId) {
        for (VersionedPort proposedPort : proposed.getInputPorts()) {
            String temporaryName;
            Port port = inputPortsByVersionedId.get(proposedPort.getIdentifier());
            if (port == null) {
                temporaryName = this.generateTemporaryPortName(proposedPort);
                Port added = this.addInputPort(group, proposedPort, this.context.getComponentIdGenerator(), temporaryName);
                proposedPortFinalNames.put(added, proposedPort.getName());
                this.context.getFlowManager().onInputPortAdded(added);
                LOG.info("Added {} to {}", (Object)added, (Object)group);
                continue;
            }
            if (this.updatedVersionedComponentIds.contains(proposedPort.getIdentifier())) {
                temporaryName = this.generateTemporaryPortName(proposedPort);
                proposedPortFinalNames.put(port, proposedPort.getName());
                this.updatePort(port, proposedPort, temporaryName);
                LOG.info("Updated {}", (Object)port);
                continue;
            }
            port.setPosition(new Position(proposedPort.getPosition().getX(), proposedPort.getPosition().getY()));
        }
    }

    private void synchronizeOutputPorts(ProcessGroup group, VersionedProcessGroup proposed, Map<Port, String> proposedPortFinalNames, Map<String, Port> outputPortsByVersionedId) {
        for (VersionedPort proposedPort : proposed.getOutputPorts()) {
            String temporaryName;
            Port port = outputPortsByVersionedId.get(proposedPort.getIdentifier());
            if (port == null) {
                temporaryName = this.generateTemporaryPortName(proposedPort);
                Port added = this.addOutputPort(group, proposedPort, this.context.getComponentIdGenerator(), temporaryName);
                proposedPortFinalNames.put(added, proposedPort.getName());
                this.context.getFlowManager().onOutputPortAdded(added);
                LOG.info("Added {} to {}", (Object)added, (Object)group);
                continue;
            }
            if (this.updatedVersionedComponentIds.contains(proposedPort.getIdentifier())) {
                temporaryName = this.generateTemporaryPortName(proposedPort);
                proposedPortFinalNames.put(port, proposedPort.getName());
                this.updatePort(port, proposedPort, temporaryName);
                LOG.info("Updated {}", (Object)port);
                continue;
            }
            port.setPosition(new Position(proposedPort.getPosition().getX(), proposedPort.getPosition().getY()));
        }
    }

    private void updatePortsToFinalNames(Map<Port, String> proposedPortFinalNames) {
        for (Map.Entry<Port, String> portAndFinalName : proposedPortFinalNames.entrySet()) {
            Port port = portAndFinalName.getKey();
            String finalName = portAndFinalName.getValue();
            LOG.info("Updating {} to replace temporary name with final name", (Object)port);
            if (port instanceof PublicPort) {
                PublicPort publicPort = (PublicPort)port;
                String publicPortFinalName = this.getPublicPortFinalName(publicPort, finalName);
                this.updatePortToSetFinalName((Port)publicPort, publicPortFinalName);
                continue;
            }
            this.updatePortToSetFinalName(port, finalName);
        }
    }

    private void synchronizeLabels(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Label> labelsByVersionedId) {
        for (VersionedLabel proposedLabel : proposed.getLabels()) {
            Label label = labelsByVersionedId.get(proposedLabel.getIdentifier());
            if (label == null) {
                Label added = this.addLabel(group, proposedLabel, this.context.getComponentIdGenerator());
                LOG.info("Added {} to {}", (Object)added, (Object)group);
                continue;
            }
            if (this.updatedVersionedComponentIds.contains(proposedLabel.getIdentifier())) {
                this.updateLabel(label, proposedLabel);
                LOG.info("Updated {}", (Object)label);
                continue;
            }
            label.setPosition(new Position(proposedLabel.getPosition().getX(), proposedLabel.getPosition().getY()));
        }
    }

    private void removeMissingProcessors(ProcessGroup group, VersionedProcessGroup proposed, Map<String, ProcessorNode> processorsByVersionedId) {
        this.removeMissingComponents(group, proposed, processorsByVersionedId, VersionedProcessGroup::getProcessors, ProcessGroup::removeProcessor);
    }

    private void removeMissingInputPorts(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Port> portsByVersionedId) {
        this.removeMissingComponents(group, proposed, portsByVersionedId, VersionedProcessGroup::getInputPorts, ProcessGroup::removeInputPort);
    }

    private void removeMissingOutputPorts(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Port> portsByVersionedId) {
        this.removeMissingComponents(group, proposed, portsByVersionedId, VersionedProcessGroup::getOutputPorts, ProcessGroup::removeOutputPort);
    }

    private void removeMissingLabels(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Label> labelsByVersionedId) {
        this.removeMissingComponents(group, proposed, labelsByVersionedId, VersionedProcessGroup::getLabels, ProcessGroup::removeLabel);
    }

    private void removeMissingFunnels(ProcessGroup group, VersionedProcessGroup proposed, Map<String, Funnel> funnelsByVersionedId) {
        this.removeMissingComponents(group, proposed, funnelsByVersionedId, VersionedProcessGroup::getFunnels, (removalGroup, funnelToRemove) -> {
            if (funnelToRemove.getIdentifier().equals(removalGroup.getIdentifier() + TEMP_FUNNEL_ID_SUFFIX)) {
                return;
            }
            removalGroup.removeFunnel(funnelToRemove);
        });
    }

    private void removeMissingRpg(ProcessGroup group, VersionedProcessGroup proposed, Map<String, RemoteProcessGroup> rpgsByVersionedId) {
        this.removeMissingComponents(group, proposed, rpgsByVersionedId, VersionedProcessGroup::getRemoteProcessGroups, ProcessGroup::removeRemoteProcessGroup);
    }

    private void removeMissingControllerServices(ProcessGroup group, VersionedProcessGroup proposed, Map<String, ControllerServiceNode> servicesByVersionedId) {
        BiConsumer<ProcessGroup, ControllerServiceNode> componentRemoval = (grp, service) -> this.context.getControllerServiceProvider().removeControllerService(service);
        this.removeMissingComponents(group, proposed, servicesByVersionedId, VersionedProcessGroup::getControllerServices, componentRemoval);
    }

    private void removeMissingChildGroups(ProcessGroup group, VersionedProcessGroup proposed, Map<String, ProcessGroup> groupsByVersionedId) {
        this.removeMissingComponents(group, proposed, groupsByVersionedId, VersionedProcessGroup::getProcessGroups, (procGroup, childGroup) -> {
            if (!childGroup.isEmpty()) {
                this.purgeChildGroupOfEmptyChildren((ProcessGroup)childGroup);
            }
            procGroup.removeProcessGroup(childGroup);
        });
    }

    private void purgeChildGroupOfEmptyChildren(ProcessGroup group) {
        for (ProcessGroup child : group.getProcessGroups()) {
            this.purgeChildGroupOfEmptyChildren(child);
            if (!child.isEmpty()) continue;
            group.removeProcessGroup(child);
        }
    }

    private <C, V extends VersionedComponent> void removeMissingComponents(ProcessGroup group, VersionedProcessGroup proposed, Map<String, C> componentsById, Function<VersionedProcessGroup, Collection<V>> getVersionedComponents, BiConsumer<ProcessGroup, C> removeComponent) {
        HashSet<String> idsOfComponentsToRemove = new HashSet<String>(componentsById.keySet());
        for (VersionedComponent versionedComponent : getVersionedComponents.apply(proposed)) {
            idsOfComponentsToRemove.remove(versionedComponent.getIdentifier());
        }
        for (String idToRemove : idsOfComponentsToRemove) {
            C toRemove = componentsById.get(idToRemove);
            LOG.info("Removing {} from {}", toRemove, (Object)group);
            removeComponent.accept(group, toRemove);
        }
    }

    private void synchronizeProcessors(ProcessGroup group, VersionedProcessGroup proposed, Map<String, ProcessorNode> processorsByVersionedId, ProcessGroup topLevelGroup) throws ProcessorInstantiationException {
        for (VersionedProcessor proposedProcessor : proposed.getProcessors()) {
            ProcessorNode processor = processorsByVersionedId.get(proposedProcessor.getIdentifier());
            if (processor == null) {
                ProcessorNode added = this.addProcessor(group, proposedProcessor, this.context.getComponentIdGenerator(), topLevelGroup);
                LOG.info("Added {} to {}", (Object)added, (Object)group);
                continue;
            }
            if (this.updatedVersionedComponentIds.contains(proposedProcessor.getIdentifier())) {
                this.updateProcessor(processor, proposedProcessor, topLevelGroup);
                this.createdAndModifiedExtensions.add(new CreatedOrModifiedExtension((ComponentNode)processor, this.getPropertyValues((ComponentNode)processor)));
                LOG.info("Updated {}", (Object)processor);
                continue;
            }
            processor.setPosition(new Position(proposedProcessor.getPosition().getX(), proposedProcessor.getPosition().getY()));
        }
    }

    private void synchronizeRemoteGroups(ProcessGroup group, VersionedProcessGroup proposed, Map<String, RemoteProcessGroup> rpgsByVersionedId) {
        for (VersionedRemoteProcessGroup proposedRpg : proposed.getRemoteProcessGroups()) {
            RemoteProcessGroup rpg = rpgsByVersionedId.get(proposedRpg.getIdentifier());
            if (rpg == null) {
                RemoteProcessGroup added = this.addRemoteProcessGroup(group, proposedRpg, this.context.getComponentIdGenerator());
                LOG.info("Added {} to {}", (Object)added, (Object)group);
                continue;
            }
            if (this.updatedVersionedComponentIds.contains(proposedRpg.getIdentifier())) {
                this.updateRemoteProcessGroup(rpg, proposedRpg, this.context.getComponentIdGenerator());
                LOG.info("Updated {}", (Object)rpg);
                continue;
            }
            rpg.setPosition(new Position(proposedRpg.getPosition().getX(), proposedRpg.getPosition().getY()));
        }
    }

    @Override
    public void verifyCanAddVersionedComponents(ProcessGroup group, VersionedComponentAdditions additions) {
        this.verifyCanInstantiateProcessors(group, additions.getProcessors(), additions.getProcessGroups());
        this.verifyCanInstantiateControllerServices(group, additions.getControllerServices(), additions.getProcessGroups());
        this.verifyCanInstantiateConnections(group, additions.getConnections(), additions.getProcessGroups());
    }

    @Override
    public void verifyCanSynchronize(ProcessGroup group, VersionedProcessGroup flowContents, boolean verifyConnectionRemoval) {
        this.verifyCanRemoveMissingComponents(group, flowContents, verifyConnectionRemoval);
        HashMap removedInputPortsByVersionId = new HashMap();
        group.getInputPorts().forEach(port -> removedInputPortsByVersionId.put(port.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(port.getIdentifier())), port));
        flowContents.getInputPorts().stream().map(VersionedComponent::getIdentifier).forEach(removedInputPortsByVersionId::remove);
        for (Port inputPort : removedInputPortsByVersionId.values()) {
            List incomingConnections = inputPort.getIncomingConnections();
            if (incomingConnections.isEmpty()) continue;
            throw new IllegalStateException(String.valueOf(group) + " cannot be updated to the proposed flow because the proposed flow does not contain the Input Port " + String.valueOf(inputPort) + " and the Input Port currently has an incoming connection");
        }
        HashMap removedOutputPortsByVersionId = new HashMap();
        group.getOutputPorts().forEach(port -> removedOutputPortsByVersionId.put(port.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(port.getIdentifier())), port));
        flowContents.getOutputPorts().stream().map(VersionedComponent::getIdentifier).forEach(removedOutputPortsByVersionId::remove);
        for (Port outputPort : removedOutputPortsByVersionId.values()) {
            Set outgoingConnections = outputPort.getConnections();
            if (outgoingConnections.isEmpty()) continue;
            throw new IllegalStateException(String.valueOf(group) + " cannot be updated to the proposed flow because the proposed flow does not contain the Output Port " + String.valueOf(outputPort) + " and the Output Port currently has an outgoing connection");
        }
        this.verifyCanInstantiateProcessors(group, flowContents.getProcessors(), flowContents.getProcessGroups());
        this.verifyCanInstantiateControllerServices(group, flowContents.getControllerServices(), flowContents.getProcessGroups());
        this.verifyCanInstantiateConnections(group, flowContents.getConnections(), flowContents.getProcessGroups());
    }

    private void verifyCanInstantiateProcessors(ProcessGroup group, Set<VersionedProcessor> processors, Set<VersionedProcessGroup> childGroups) {
        HashMap<String, VersionedProcessor> proposedProcessors = new HashMap<String, VersionedProcessor>();
        this.findAllProcessors(processors, childGroups, proposedProcessors);
        group.findAllProcessors().forEach(proc -> proposedProcessors.remove(proc.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(proc.getIdentifier()))));
        for (VersionedProcessor processorToAdd : proposedProcessors.values()) {
            List possibleBundles;
            boolean bundleExists;
            String processorToAddClass = processorToAdd.getType();
            BundleCoordinate processorToAddCoordinate = this.toCoordinate(processorToAdd.getBundle());
            Bundle bundle = processorToAdd.getBundle();
            BundleCoordinate coordinate = new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
            org.apache.nifi.bundle.Bundle resolved = this.context.getExtensionManager().getBundle(coordinate);
            if (resolved != null || (bundleExists = (possibleBundles = this.context.getExtensionManager().getBundles(processorToAddClass)).stream().anyMatch(b -> processorToAddCoordinate.equals((Object)b.getBundleDetails().getCoordinate()))) || possibleBundles.size() == 1) continue;
            LOG.warn("Unknown bundle {} for processor type {} - will use Ghosted component instead", (Object)processorToAddCoordinate, (Object)processorToAddClass);
        }
    }

    private void verifyCanInstantiateControllerServices(ProcessGroup group, Set<VersionedControllerService> controllerServices, Set<VersionedProcessGroup> childGroups) {
        HashMap<String, VersionedControllerService> proposedServices = new HashMap<String, VersionedControllerService>();
        this.findAllControllerServices(controllerServices, childGroups, proposedServices);
        group.findAllControllerServices().forEach(service -> proposedServices.remove(service.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(service.getIdentifier()))));
        for (VersionedControllerService serviceToAdd : proposedServices.values()) {
            List possibleBundles;
            boolean bundleExists;
            String serviceToAddClass = serviceToAdd.getType();
            BundleCoordinate serviceToAddCoordinate = this.toCoordinate(serviceToAdd.getBundle());
            org.apache.nifi.bundle.Bundle resolved = this.context.getExtensionManager().getBundle(serviceToAddCoordinate);
            if (resolved != null || (bundleExists = (possibleBundles = this.context.getExtensionManager().getBundles(serviceToAddClass)).stream().anyMatch(b -> serviceToAddCoordinate.equals((Object)b.getBundleDetails().getCoordinate()))) || possibleBundles.size() == 1) continue;
            LOG.warn("Unknown bundle {} for processor type {} - will use Ghosted component instead", (Object)serviceToAddCoordinate, (Object)serviceToAddClass);
        }
    }

    private void verifyCanInstantiateConnections(ProcessGroup group, Set<VersionedConnection> connections, Set<VersionedProcessGroup> childGroups) {
        HashMap<String, VersionedConnection> proposedConnections = new HashMap<String, VersionedConnection>();
        this.findAllConnections(connections, childGroups, proposedConnections);
        group.findAllConnections().forEach(conn -> proposedConnections.remove(conn.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(conn.getIdentifier()))));
        for (VersionedConnection connectionToAdd : proposedConnections.values()) {
            String loadBalanceStrategyName;
            if (connectionToAdd.getPrioritizers() != null) {
                for (String prioritizerType : connectionToAdd.getPrioritizers()) {
                    try {
                        this.context.getFlowManager().createPrioritizer(prioritizerType);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unable to create Prioritizer of type " + prioritizerType, e);
                    }
                }
            }
            if ((loadBalanceStrategyName = connectionToAdd.getLoadBalanceStrategy()) == null) continue;
            try {
                LoadBalanceStrategy.valueOf((String)loadBalanceStrategyName);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unable to create Connection with Load Balance Strategy of '" + loadBalanceStrategyName + "' because this is not a known Load Balance Strategy");
            }
        }
    }

    private ProcessGroup addProcessGroup(ProcessGroup destination, VersionedProcessGroup proposed, ComponentIdGenerator componentIdGenerator, Map<String, VersionedParameterContext> versionedParameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, ProcessGroup topLevelGroup) throws ProcessorInstantiationException {
        String id = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), destination.getIdentifier());
        ProcessGroup group = this.context.getFlowManager().createProcessGroup(id);
        group.setVersionedComponentId(proposed.getIdentifier());
        group.setParent(destination);
        group.setName(proposed.getName());
        destination.addProcessGroup(group);
        this.synchronize(group, proposed, versionedParameterContexts, parameterProviderReferences, topLevelGroup, true);
        return group;
    }

    private ControllerServiceNode addControllerService(ProcessGroup destination, VersionedControllerService proposed, ComponentIdGenerator componentIdGenerator, ProcessGroup topLevelGroup) {
        String destinationId = destination == null ? "Controller" : destination.getIdentifier();
        String identifier = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), destinationId);
        LOG.debug("Adding Controller Service with ID {} of type {}", (Object)identifier, (Object)proposed.getType());
        BundleCoordinate coordinate = this.toCoordinate(proposed.getBundle());
        Set additionalUrls = Collections.emptySet();
        ControllerServiceNode newService = this.context.getFlowManager().createControllerService(proposed.getType(), identifier, coordinate, additionalUrls, true, true, null);
        newService.setVersionedComponentId(proposed.getIdentifier());
        if (destination == null) {
            this.context.getFlowManager().addRootControllerService(newService);
        } else {
            destination.addControllerService(newService);
        }
        Map<String, String> decryptedProperties = this.getDecryptedProperties(proposed.getProperties());
        this.createdAndModifiedExtensions.add(new CreatedOrModifiedExtension((ComponentNode)newService, decryptedProperties));
        this.updateControllerService(newService, proposed, topLevelGroup);
        return newService;
    }

    private void verifyCanSynchronize(ControllerServiceNode controllerService, VersionedControllerService proposed) {
        if (controllerService == null) {
            return;
        }
        if (proposed == null) {
            controllerService.verifyCanDelete();
            return;
        }
        controllerService.verifyCanUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(ControllerServiceNode controllerService, VersionedControllerService proposed, ProcessGroup group, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException {
        if (controllerService == null && proposed == null) {
            return;
        }
        this.setSynchronizationOptions(synchronizationOptions);
        long timeout = System.currentTimeMillis() + synchronizationOptions.getComponentStopTimeout().toMillis();
        ControllerServiceProvider serviceProvider = this.context.getControllerServiceProvider();
        synchronizationOptions.getComponentScheduler().pause();
        try {
            HashSet<ComponentNode> referencesToRestart = new HashSet<ComponentNode>();
            HashSet<ControllerServiceNode> servicesToRestart = new HashSet<ControllerServiceNode>();
            try {
                this.stopControllerService(controllerService, proposed, timeout, synchronizationOptions.getComponentStopTimeoutAction(), referencesToRestart, servicesToRestart, synchronizationOptions);
                this.verifyCanSynchronize(controllerService, proposed);
                try {
                    ProcessGroup topLevelGroup;
                    ProcessGroup processGroup = topLevelGroup = synchronizationOptions.getTopLevelGroupId() != null ? this.context.getFlowManager().getGroup(synchronizationOptions.getTopLevelGroupId()) : group;
                    if (proposed == null) {
                        serviceProvider.removeControllerService(controllerService);
                        LOG.info("Successfully synchronized {} by removing it from the flow", (Object)controllerService);
                    } else if (controllerService == null) {
                        ControllerServiceNode added = this.addControllerService(group, proposed, synchronizationOptions.getComponentIdGenerator(), topLevelGroup);
                        if (proposed.getScheduledState() == ScheduledState.ENABLED) {
                            servicesToRestart.add(added);
                        }
                        LOG.info("Successfully synchronized {} by adding it to the flow", (Object)added);
                    } else {
                        this.updateControllerService(controllerService, proposed, topLevelGroup);
                        if (proposed.getScheduledState() == ScheduledState.ENABLED) {
                            servicesToRestart.add(controllerService);
                        }
                        LOG.info("Successfully synchronized {} by updating it to match proposed version", (Object)controllerService);
                    }
                }
                catch (Exception e) {
                    throw new FlowSynchronizationException("Failed to synchronize Controller Service " + String.valueOf(controllerService) + " with proposed version", e);
                }
            }
            finally {
                if (proposed != null && proposed.getScheduledState() != ScheduledState.DISABLED) {
                    serviceProvider.enableControllerServicesAsync(servicesToRestart);
                    this.notifyScheduledStateChange(servicesToRestart, synchronizationOptions, ScheduledState.ENABLED);
                    if (controllerService != null) {
                        serviceProvider.scheduleReferencingComponents(controllerService, referencesToRestart, this.context.getComponentScheduler());
                        referencesToRestart.forEach(componentNode -> this.notifyScheduledStateChange((ComponentNode)componentNode, synchronizationOptions, ScheduledState.RUNNING));
                    }
                }
            }
        }
        finally {
            synchronizationOptions.getComponentScheduler().resume();
        }
    }

    private void waitForStopCompletion(Future<?> future, Object component, long timeout, FlowSynchronizationOptions.ComponentStopTimeoutAction timeoutAction) throws InterruptedException, FlowSynchronizationException, TimeoutException {
        try {
            future.get(timeout - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedException("Interrupted while waiting for " + String.valueOf(component) + " to stop/disable");
        }
        catch (ExecutionException ee) {
            throw new FlowSynchronizationException("Failed to stop/disable " + String.valueOf(component), ee.getCause());
        }
        catch (TimeoutException e) {
            if (component instanceof ProcessorNode) {
                switch (timeoutAction) {
                    case THROW_TIMEOUT_EXCEPTION: {
                        throw e;
                    }
                }
                ((ProcessorNode)component).terminate();
                return;
            }
            throw new TimeoutException("Timed out waiting for " + String.valueOf(component) + " to stop/disable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateControllerService(ControllerServiceNode service, VersionedControllerService proposed, ProcessGroup topLevelGroup) {
        LOG.debug("Updating {}", (Object)service);
        service.pauseValidationTrigger();
        try {
            service.setAnnotationData(proposed.getAnnotationData());
            service.setComments(proposed.getComments());
            service.setName(proposed.getName());
            if (proposed.getBulletinLevel() != null) {
                service.setBulletinLevel(LogLevel.valueOf((String)proposed.getBulletinLevel()));
            } else {
                service.setBulletinLevel(LogLevel.WARN);
            }
            if (!this.isEqual(service.getBundleCoordinate(), proposed.getBundle())) {
                BundleCoordinate newBundleCoordinate = this.toCoordinate(proposed.getBundle());
                ArrayList descriptors = new ArrayList(service.getRawPropertyValues().keySet());
                Set additionalUrls = service.getAdditionalClasspathResources(descriptors);
                this.context.getReloadComponent().reload(service, proposed.getType(), newBundleCoordinate, additionalUrls);
            }
            Set<String> sensitiveDynamicPropertyNames = this.getSensitiveDynamicPropertyNames((ComponentNode)service, proposed.getProperties(), proposed.getPropertyDescriptors().values());
            Map<String, String> properties = this.populatePropertiesMap((ComponentNode)service, proposed.getProperties(), proposed.getPropertyDescriptors(), service.getProcessGroup(), topLevelGroup);
            service.setProperties(properties, true, sensitiveDynamicPropertyNames);
        }
        finally {
            service.resumeValidationTrigger();
        }
    }

    private Set<String> getSensitiveDynamicPropertyNames(ComponentNode componentNode, Map<String, String> proposedProperties, Collection<VersionedPropertyDescriptor> proposedDescriptors) {
        LinkedHashSet<String> sensitiveDynamicPropertyNames = new LinkedHashSet<String>();
        proposedDescriptors.stream().filter(VersionedPropertyDescriptor::isSensitive).map(VersionedPropertyDescriptor::getName).map(arg_0 -> ((ComponentNode)componentNode).getPropertyDescriptor(arg_0)).filter(PropertyDescriptor::isDynamic).map(PropertyDescriptor::getName).forEach(sensitiveDynamicPropertyNames::add);
        proposedProperties.entrySet().stream().filter(entry -> StandardVersionedComponentSynchronizer.isValueEncrypted((String)entry.getValue())).map(Map.Entry::getKey).map(arg_0 -> ((ComponentNode)componentNode).getPropertyDescriptor(arg_0)).filter(PropertyDescriptor::isDynamic).map(PropertyDescriptor::getName).forEach(sensitiveDynamicPropertyNames::add);
        return sensitiveDynamicPropertyNames;
    }

    private Map<String, String> populatePropertiesMap(ComponentNode componentNode, Map<String, String> proposedProperties, Map<String, VersionedPropertyDescriptor> proposedPropertyDescriptors, ProcessGroup group, ProcessGroup topLevelGroup) {
        HashMap<String, String> fullPropertyMap = new HashMap<String, String>();
        for (PropertyDescriptor property : componentNode.getRawPropertyValues().keySet()) {
            if (property.isSensitive()) continue;
            fullPropertyMap.put(property.getName(), null);
        }
        if (proposedProperties != null) {
            HashSet<String> updatedPropertyNames = new HashSet<String>(proposedProperties.keySet());
            componentNode.getProperties().keySet().stream().map(PropertyDescriptor::getName).forEach(updatedPropertyNames::add);
            for (String propertyName : updatedPropertyNames) {
                PropertyConfiguration propertyConfiguration;
                String value;
                boolean sensitive;
                PropertyDescriptor descriptor = componentNode.getPropertyDescriptor(propertyName);
                VersionedPropertyDescriptor versionedDescriptor = proposedPropertyDescriptors == null ? null : proposedPropertyDescriptors.get(propertyName);
                boolean referencesService = descriptor != null && descriptor.getControllerServiceDefinition() != null || versionedDescriptor != null && versionedDescriptor.getIdentifiesControllerService();
                boolean bl = sensitive = descriptor != null && descriptor.isSensitive() || versionedDescriptor != null && versionedDescriptor.isSensitive();
                if (descriptor != null && referencesService && proposedProperties.get(propertyName) != null) {
                    ControllerServiceNode serviceNode;
                    ProcessGroup parentGroup;
                    String existingExternalServiceId = null;
                    String componentDescriptorValue = componentNode.getEffectivePropertyValue(descriptor);
                    if (componentDescriptorValue != null && (parentGroup = topLevelGroup.getParent()) != null && (serviceNode = parentGroup.findControllerService(componentDescriptorValue, false, true)) != null) {
                        existingExternalServiceId = componentDescriptorValue;
                    }
                    if (existingExternalServiceId == null) {
                        String serviceVersionedComponentId = proposedProperties.get(propertyName);
                        String instanceId = this.getServiceInstanceId(serviceVersionedComponentId, group);
                        value = instanceId == null ? serviceVersionedComponentId : instanceId;
                        this.createdAndModifiedExtensions.stream().filter(ce -> ce.extension.equals((Object)componentNode)).forEach(createdOrModifiedExtension -> createdOrModifiedExtension.propertyValues.replace(propertyName, value));
                    } else {
                        value = existingExternalServiceId;
                    }
                } else {
                    value = proposedProperties.get(propertyName);
                }
                if (sensitive && value == null && ((propertyConfiguration = componentNode.getProperty(descriptor)) == null || propertyConfiguration.getParameterReferences().isEmpty())) continue;
                fullPropertyMap.put(propertyName, StandardVersionedComponentSynchronizer.decrypt(value, this.syncOptions.getPropertyDecryptor()));
            }
        }
        return fullPropertyMap;
    }

    private Map<String, String> getDecryptedProperties(Map<String, String> properties) {
        LinkedHashMap<String, String> decryptedProperties = new LinkedHashMap<String, String>();
        PropertyDecryptor decryptor = this.syncOptions.getPropertyDecryptor();
        properties.forEach((propertyName, propertyValue) -> {
            String propertyValueDecrypted = StandardVersionedComponentSynchronizer.decrypt(propertyValue, decryptor);
            decryptedProperties.put((String)propertyName, propertyValueDecrypted);
        });
        return decryptedProperties;
    }

    private static String decrypt(String value, PropertyDecryptor decryptor) {
        if (StandardVersionedComponentSynchronizer.isValueEncrypted(value)) {
            try {
                return decryptor.decrypt(value.substring(ENC_PREFIX.length(), value.length() - ENC_SUFFIX.length()));
            }
            catch (EncryptionException e) {
                String moreDescriptiveMessage = "There was a problem decrypting a sensitive flow configuration value. Check that the nifi.sensitive.props.key value in nifi.properties matches the value used to encrypt the flow.json.gz file";
                throw new EncryptionException("There was a problem decrypting a sensitive flow configuration value. Check that the nifi.sensitive.props.key value in nifi.properties matches the value used to encrypt the flow.json.gz file", (Throwable)e);
            }
        }
        return value;
    }

    private static boolean isValueEncrypted(String value) {
        return value != null && value.startsWith(ENC_PREFIX) && value.endsWith(ENC_SUFFIX);
    }

    private void verifyCanSynchronize(ParameterContext parameterContext, VersionedParameterContext proposed) throws FlowSynchronizationException {
        Object existingContext;
        if (parameterContext == null && (existingContext = this.getParameterContextByName(proposed.getName())) != null) {
            throw new FlowSynchronizationException("Cannot synchronize flow with proposed Parameter Context because a Parameter Context already exists with the name " + proposed.getName());
        }
        if (proposed == null) {
            this.verifyNotInherited(parameterContext.getIdentifier());
        }
        if (parameterContext != null && proposed != null) {
            for (VersionedParameter versionedParameter : proposed.getParameters()) {
                boolean paramSensitive;
                Optional optionalParameter = parameterContext.getParameter(versionedParameter.getName());
                if (!optionalParameter.isPresent() || (paramSensitive = ((Parameter)optionalParameter.get()).getDescriptor().isSensitive()) == versionedParameter.isSensitive()) continue;
                throw new FlowSynchronizationException("Cannot synchronize flow with proposed Parameter Context because the Parameter [" + versionedParameter.getName() + "] in " + String.valueOf(parameterContext) + " has a sensitivity flag of " + paramSensitive + " while the proposed version has a sensitivity flag of " + versionedParameter.isSensitive());
            }
            List inheritedContexts = proposed.getInheritedParameterContexts();
            if (inheritedContexts != null) {
                for (String contextName : inheritedContexts) {
                    ParameterContext existing = this.getParameterContextByName(contextName);
                    if (existing != null) continue;
                    throw new FlowSynchronizationException("Cannot synchronize flow with proposed Parameter Context because proposed version inherits from Parameter Context with name " + contextName + " but there is no Parameter Context with that name in the current flow");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(ParameterContext parameterContext, VersionedParameterContext proposed, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException {
        if (parameterContext == null && proposed == null) {
            return;
        }
        long timeout = System.currentTimeMillis() + synchronizationOptions.getComponentStopTimeout().toMillis();
        this.verifyCanSynchronize(parameterContext, proposed);
        synchronizationOptions.getComponentScheduler().pause();
        try {
            if (parameterContext == null) {
                String contextId = synchronizationOptions.getComponentIdGenerator().generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), "Controller");
                ParameterContext added = this.createParameterContext(proposed, contextId, Collections.emptyMap(), Collections.emptyMap(), synchronizationOptions.getComponentIdGenerator());
                LOG.info("Successfully synchronized {} by adding it to the flow", (Object)added);
                return;
            }
            ParameterReferenceManager referenceManager = parameterContext.getParameterReferenceManager();
            Set<String> updatedParameterNames = this.getUpdatedParameterNames(parameterContext, proposed);
            HashSet<ComponentNode> componentsToRestart = new HashSet<ComponentNode>();
            HashSet<ControllerServiceNode> servicesToRestart = new HashSet<ControllerServiceNode>();
            try {
                for (String string : updatedParameterNames) {
                    Set processors = referenceManager.getProcessorsReferencing(parameterContext, string);
                    componentsToRestart.addAll(this.stopOrTerminate(processors, timeout, synchronizationOptions));
                    Set referencingServices = referenceManager.getControllerServicesReferencing(parameterContext, string);
                    for (ControllerServiceNode referencingService : referencingServices) {
                        boolean isServiceActive = referencingService.isActive();
                        this.stopControllerService(referencingService, null, timeout, synchronizationOptions.getComponentStopTimeoutAction(), componentsToRestart, servicesToRestart, synchronizationOptions);
                        if (!isServiceActive) continue;
                        servicesToRestart.add(referencingService);
                    }
                }
                ParameterContextManager contextManager = this.context.getFlowManager().getParameterContextManager();
                if (proposed == null) {
                    for (ProcessGroup groupBound : referenceManager.getProcessGroupsBound(parameterContext)) {
                        groupBound.setParameterContext(null);
                    }
                    contextManager.removeParameterContext(parameterContext.getIdentifier());
                    LOG.info("Successfully synchronized {} by removing it from the flow", (Object)parameterContext);
                }
                Map<String, Parameter> map = this.createParameterMap(proposed.getParameters());
                for (ParameterDescriptor existingParameterDescriptor : parameterContext.getParameters().keySet()) {
                    String name = existingParameterDescriptor.getName();
                    if (map.containsKey(name)) continue;
                    map.put(name, null);
                }
                Map contextsByName = contextManager.getParameterContextNameMapping();
                ArrayList<ParameterContext> inheritedContexts = new ArrayList<ParameterContext>();
                List inheritedContextNames = proposed.getInheritedParameterContexts();
                if (inheritedContextNames != null) {
                    for (String inheritedContextName : inheritedContextNames) {
                        ParameterContext inheritedContext = (ParameterContext)contextsByName.get(inheritedContextName);
                        inheritedContexts.add(inheritedContext);
                    }
                }
                parameterContext.setParameters(map);
                parameterContext.setName(proposed.getName());
                parameterContext.setDescription(proposed.getDescription());
                parameterContext.setInheritedParameterContexts(inheritedContexts);
                LOG.info("Successfully synchronized {} by updating it to match the proposed version", (Object)parameterContext);
            }
            finally {
                this.context.getControllerServiceProvider().enableControllerServicesAsync(servicesToRestart);
                for (ComponentNode componentNode : componentsToRestart) {
                    if (!(componentNode instanceof Connectable)) continue;
                    this.context.getComponentScheduler().startComponent((Connectable)componentNode);
                    this.notifyScheduledStateChange(componentNode, synchronizationOptions, ScheduledState.RUNNING);
                }
            }
        }
        finally {
            synchronizationOptions.getComponentScheduler().resume();
        }
    }

    private void collectValueAndReferences(ParameterContext parameterContext, Map<String, ParameterValueAndReferences> valueAndRef) {
        parameterContext.getEffectiveParameters().forEach((pd, param) -> valueAndRef.put(pd.getName(), this.getValueAndReferences((Parameter)param)));
    }

    protected Set<String> getUpdatedParameterNames(ParameterContext parameterContext, VersionedParameterContext proposed) {
        HashMap<String, ParameterValueAndReferences> originalValues = new HashMap<String, ParameterValueAndReferences>();
        this.collectValueAndReferences(parameterContext, originalValues);
        parameterContext.getEffectiveParameters().forEach((pd, param) -> originalValues.put(pd.getName(), this.getValueAndReferences((Parameter)param)));
        HashMap<String, ParameterValueAndReferences> proposedValues = new HashMap<String, ParameterValueAndReferences>();
        if (proposed != null) {
            if (proposed.getInheritedParameterContexts() != null) {
                for (int i = proposed.getInheritedParameterContexts().size() - 1; i >= 0; --i) {
                    String name = (String)proposed.getInheritedParameterContexts().get(i);
                    ParameterContext inheritedContext = this.getParameterContextByName(name);
                    if (inheritedContext == null) continue;
                    this.collectValueAndReferences(inheritedContext, proposedValues);
                    inheritedContext.getEffectiveParameters().forEach((pd, param) -> proposedValues.put(pd.getName(), this.getValueAndReferences((Parameter)param)));
                }
            }
            proposed.getParameters().forEach(versionedParam -> proposedValues.put(versionedParam.getName(), this.getValueAndReferences((VersionedParameter)versionedParam)));
        }
        HashMap<String, ParameterValueAndReferences> copyOfOriginalValues = new HashMap<String, ParameterValueAndReferences>(originalValues);
        proposedValues.forEach(originalValues::remove);
        copyOfOriginalValues.forEach(proposedValues::remove);
        HashSet<String> updatedParameterNames = new HashSet<String>(originalValues.keySet());
        updatedParameterNames.addAll(proposedValues.keySet());
        return updatedParameterNames;
    }

    private ParameterValueAndReferences getValueAndReferences(Parameter parameter) {
        List assets = parameter.getReferencedAssets();
        if (assets == null || assets.isEmpty()) {
            return new ParameterValueAndReferences(parameter.getValue(), null);
        }
        List<String> assetIds = assets.stream().map(Asset::getIdentifier).toList();
        return new ParameterValueAndReferences(null, assetIds);
    }

    private ParameterValueAndReferences getValueAndReferences(VersionedParameter parameter) {
        List assets = parameter.getReferencedAssets();
        if (assets == null || assets.isEmpty()) {
            return new ParameterValueAndReferences(parameter.getValue(), null);
        }
        List<String> assetIds = assets.stream().map(VersionedAsset::getIdentifier).toList();
        return new ParameterValueAndReferences(null, assetIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeProcessGroupSettings(ProcessGroup processGroup, VersionedProcessGroup proposed, ProcessGroup parentGroup, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException {
        if (processGroup == null && proposed == null) {
            return;
        }
        long timeout = System.currentTimeMillis() + synchronizationOptions.getComponentStopTimeout().toMillis();
        synchronizationOptions.getComponentScheduler().pause();
        try {
            String currentParameterContextName;
            ParameterContext parameterContext;
            ProcessGroup groupToUpdate;
            if (proposed == null) {
                processGroup.getInputPorts().forEach(Connectable::verifyCanDelete);
                this.bleedOut(processGroup, timeout, synchronizationOptions);
                processGroup.stopProcessing();
                this.waitFor(timeout, () -> this.isDoneProcessing(processGroup));
                Set controllerServices = processGroup.findAllControllerServices();
                CompletableFuture disableServicesFuture = this.context.getControllerServiceProvider().disableControllerServicesAsync((Collection)controllerServices);
                this.notifyScheduledStateChange(controllerServices, synchronizationOptions, ScheduledState.DISABLED);
                try {
                    disableServicesFuture.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException ee) {
                    throw new FlowSynchronizationException("Could not synchronize flow with proposal due to: failed to disable Controller Services", ee.getCause());
                }
                processGroup.getParent().removeProcessGroup(processGroup);
                LOG.info("Successfully synchronized {} by removing it from the flow", (Object)processGroup);
                return;
            }
            if (processGroup == null) {
                String groupId = synchronizationOptions.getComponentIdGenerator().generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), parentGroup.getIdentifier());
                ProcessGroup group = this.context.getFlowManager().createProcessGroup(groupId);
                group.setVersionedComponentId(proposed.getIdentifier());
                group.setParent(parentGroup);
                group.setName(proposed.getName());
                parentGroup.addProcessGroup(group);
                groupToUpdate = group;
            } else {
                groupToUpdate = processGroup;
            }
            ParameterContext parameterContext2 = parameterContext = proposed.getParameterContextName() == null ? null : (ParameterContext)this.context.getFlowManager().getParameterContextManager().getParameterContextNameMapping().get(proposed.getParameterContextName());
            if (parameterContext == null && proposed.getParameterContextName() != null) {
                throw new FlowSynchronizationException("Cannot synchronize flow with proposed version because proposal indicates that Process Group " + String.valueOf(groupToUpdate) + " should use Parameter Context with name [" + proposed.getParameterContextName() + "] but no Parameter Context exists with that name");
            }
            HashSet processorsToStop = new HashSet();
            HashSet<ControllerServiceNode> controllerServicesToStop = new HashSet<ControllerServiceNode>();
            String string = currentParameterContextName = groupToUpdate.getParameterContext() == null ? null : groupToUpdate.getParameterContext().getName();
            if (!Objects.equals(currentParameterContextName, proposed.getParameterContextName())) {
                groupToUpdate.getProcessors().stream().filter(Triggerable::isRunning).filter(AbstractComponentNode::isReferencingParameter).forEach(processorsToStop::add);
                Set servicesReferencingParams = groupToUpdate.getControllerServices(false).stream().filter(ComponentNode::isReferencingParameter).collect(Collectors.toSet());
                for (ControllerServiceNode service : servicesReferencingParams) {
                    if (!service.isActive()) continue;
                    controllerServicesToStop.add(service);
                    for (ControllerServiceNode referencingService : service.getReferences().findRecursiveReferences(ControllerServiceNode.class)) {
                        if (!referencingService.isActive()) continue;
                        controllerServicesToStop.add(referencingService);
                    }
                }
                for (ControllerServiceNode service : controllerServicesToStop) {
                    service.getReferences().findRecursiveReferences(ProcessorNode.class).stream().filter(Triggerable::isRunning).forEach(processorsToStop::add);
                }
            }
            try {
                this.stopOrTerminate(processorsToStop, timeout, synchronizationOptions);
                CompletableFuture serviceDisableFuture = this.context.getControllerServiceProvider().disableControllerServicesAsync(controllerServicesToStop);
                this.notifyScheduledStateChange(controllerServicesToStop, synchronizationOptions, ScheduledState.DISABLED);
                try {
                    serviceDisableFuture.get(timeout - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw new FlowSynchronizationException("Failed to disable Controller Services necessary in order to perform update of Process Group", e);
                }
                groupToUpdate.setDefaultBackPressureDataSizeThreshold(proposed.getDefaultBackPressureDataSizeThreshold());
                groupToUpdate.setDefaultBackPressureObjectThreshold(proposed.getDefaultBackPressureObjectThreshold());
                groupToUpdate.setDefaultFlowFileExpiration(proposed.getDefaultFlowFileExpiration());
                groupToUpdate.setFlowFileConcurrency(proposed.getFlowFileConcurrency() == null ? FlowFileConcurrency.UNBOUNDED : FlowFileConcurrency.valueOf((String)proposed.getFlowFileConcurrency()));
                groupToUpdate.setFlowFileOutboundPolicy(proposed.getFlowFileOutboundPolicy() == null ? FlowFileOutboundPolicy.STREAM_WHEN_AVAILABLE : FlowFileOutboundPolicy.valueOf((String)proposed.getFlowFileOutboundPolicy()));
                groupToUpdate.setParameterContext(parameterContext);
                groupToUpdate.setComments(proposed.getComments());
                groupToUpdate.setName(proposed.getName());
                groupToUpdate.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
                groupToUpdate.setLogFileSuffix(proposed.getLogFileSuffix());
                if (processGroup == null) {
                    LOG.info("Successfully synchronized {} by adding it to the flow", (Object)groupToUpdate);
                }
                LOG.info("Successfully synchronized {} by updating it to match proposed version", (Object)groupToUpdate);
            }
            finally {
                this.context.getControllerServiceProvider().enableControllerServicesAsync(controllerServicesToStop);
                this.notifyScheduledStateChange(controllerServicesToStop, synchronizationOptions, ScheduledState.ENABLED);
                for (ProcessorNode processor : processorsToStop) {
                    processor.getProcessGroup().startProcessor(processor, false);
                    this.notifyScheduledStateChange((ComponentNode)processor, synchronizationOptions, ScheduledState.RUNNING);
                }
            }
        }
        finally {
            synchronizationOptions.getComponentScheduler().resume();
        }
    }

    private boolean isDoneProcessing(ProcessGroup group) {
        for (ProcessorNode processor : group.getProcessors()) {
            if (!processor.isRunning()) continue;
            return false;
        }
        for (Port port : group.getInputPorts()) {
            if (!port.isRunning()) continue;
            return false;
        }
        for (Port port : group.getOutputPorts()) {
            if (!port.isRunning()) continue;
            return false;
        }
        for (RemoteProcessGroup rpg : group.getRemoteProcessGroups()) {
            for (RemoteGroupPort port : rpg.getInputPorts()) {
                if (!port.isRunning()) continue;
                return false;
            }
            for (RemoteGroupPort port : rpg.getOutputPorts()) {
                if (!port.isRunning()) continue;
                return false;
            }
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            if (this.isDoneProcessing(childGroup)) continue;
            return false;
        }
        return true;
    }

    private void bleedOut(ProcessGroup processGroup, long timeout, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException {
        processGroup.getInputPorts().forEach(arg_0 -> ((ProcessGroup)processGroup).stopInputPort(arg_0));
        Set sourceProcessors = processGroup.findAllProcessors().stream().filter(this::isSourceProcessor).collect(Collectors.toSet());
        this.stopOrTerminate(sourceProcessors, timeout, synchronizationOptions);
        List connections = processGroup.findAllConnections();
        this.waitFor(timeout, () -> this.connectionsEmpty(connections));
    }

    private void waitFor(long timeout, BooleanSupplier condition) throws InterruptedException {
        while (System.currentTimeMillis() <= timeout && !condition.getAsBoolean()) {
            Thread.sleep(10L);
        }
    }

    private boolean connectionsEmpty(Collection<Connection> connections) {
        for (Connection connection : connections) {
            if (connection.getFlowFileQueue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean isSourceProcessor(ProcessorNode processor) {
        return processor.getIncomingConnections().stream().anyMatch(connection -> connection.getSource() != processor);
    }

    private void verifyNotInherited(String parameterContextId) {
        for (ParameterContext parameterContext : this.context.getFlowManager().getParameterContextManager().getParameterContexts()) {
            if (!parameterContext.getInheritedParameterContexts().stream().anyMatch(pc -> pc.getIdentifier().equals(parameterContextId))) continue;
            throw new IllegalStateException(String.format("Cannot delete Parameter Context with ID [%s] because it is referenced by at least one Parameter Context [%s]", parameterContextId, parameterContext.getIdentifier()));
        }
    }

    private void updateParameterContext(ProcessGroup group, VersionedProcessGroup proposed, Map<String, VersionedParameterContext> versionedParameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, ComponentIdGenerator componentIdGenerator) {
        VersionedParameterContext versionedParameterContext;
        ParameterContext currentParamContext = group.getParameterContext();
        String proposedParameterContextName = proposed.getParameterContextName();
        if (proposedParameterContextName == null && currentParamContext != null) {
            group.setParameterContext(null);
        } else if (proposedParameterContextName != null && (versionedParameterContext = versionedParameterContexts.get(proposedParameterContextName)) != null) {
            this.createMissingParameterProvider(versionedParameterContext, versionedParameterContext.getParameterProvider(), parameterProviderReferences, componentIdGenerator);
            if (currentParamContext == null) {
                ParameterContext selectedParameterContext;
                ParameterContext contextByName = this.getParameterContextByName(versionedParameterContext.getName());
                if (contextByName == null) {
                    String parameterContextId = componentIdGenerator.generateUuid(versionedParameterContext.getName(), versionedParameterContext.getName(), versionedParameterContext.getName());
                    selectedParameterContext = this.createParameterContext(versionedParameterContext, parameterContextId, versionedParameterContexts, parameterProviderReferences, componentIdGenerator);
                } else {
                    selectedParameterContext = contextByName;
                    this.addMissingConfiguration(versionedParameterContext, selectedParameterContext, versionedParameterContexts, parameterProviderReferences, componentIdGenerator);
                }
                group.setParameterContext(selectedParameterContext);
            } else {
                this.addMissingConfiguration(versionedParameterContext, currentParamContext, versionedParameterContexts, parameterProviderReferences, componentIdGenerator);
            }
        }
    }

    private void createMissingParameterProvider(VersionedParameterContext versionedParameterContext, String parameterProviderId, Map<String, ParameterProviderReference> parameterProviderReferences, ComponentIdGenerator componentIdGenerator) {
        ParameterProviderNode parameterProviderNode;
        String parameterProviderIdToSet = parameterProviderId;
        if (parameterProviderId != null && (parameterProviderNode = this.context.getFlowManager().getParameterProvider(parameterProviderId)) == null) {
            ParameterProviderReference reference = parameterProviderReferences.get(parameterProviderId);
            if (reference == null) {
                parameterProviderIdToSet = null;
            } else {
                parameterProviderNode = this.context.getFlowManager().getParameterProvider(reference.getIdentifier());
                if (parameterProviderNode != null) {
                    parameterProviderIdToSet = reference.getIdentifier();
                } else {
                    String newParameterProviderId = componentIdGenerator.generateUuid(parameterProviderId, parameterProviderId, null);
                    Bundle bundle = reference.getBundle();
                    parameterProviderNode = this.context.getFlowManager().createParameterProvider(reference.getType(), newParameterProviderId, new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion()), true);
                    parameterProviderNode.pauseValidationTrigger();
                    parameterProviderNode.setName(reference.getName());
                    parameterProviderNode.resumeValidationTrigger();
                    parameterProviderIdToSet = parameterProviderNode.getIdentifier();
                    reference.setIdentifier(parameterProviderIdToSet);
                    parameterProviderReferences.put(parameterProviderIdToSet, reference);
                }
            }
        }
        versionedParameterContext.setParameterProvider(parameterProviderIdToSet);
    }

    private String getPublicPortFinalName(PublicPort publicPort, String proposedFinalName) {
        Optional existingPublicPort = TransferDirection.RECEIVE == publicPort.getDirection() ? this.context.getFlowManager().getPublicInputPort(proposedFinalName) : this.context.getFlowManager().getPublicOutputPort(proposedFinalName);
        if (existingPublicPort.isPresent() && !((Port)existingPublicPort.get()).getIdentifier().equals(publicPort.getIdentifier())) {
            return this.getPublicPortFinalName(publicPort, "Copy of " + proposedFinalName);
        }
        return proposedFinalName;
    }

    private ParameterContext getParameterContextByName(String contextName) {
        return (ParameterContext)this.context.getFlowManager().getParameterContextManager().getParameterContextNameMapping().get(contextName);
    }

    private ParameterContext createParameterContextWithoutReferences(VersionedParameterContext versionedParameterContext) {
        ParameterContext existing = (ParameterContext)this.context.getFlowManager().getParameterContextManager().getParameterContextNameMapping().get(versionedParameterContext.getName());
        if (existing != null) {
            return existing;
        }
        ComponentIdGenerator componentIdGenerator = this.syncOptions.getComponentIdGenerator();
        String parameterContextId = componentIdGenerator.generateUuid(versionedParameterContext.getName(), versionedParameterContext.getName(), versionedParameterContext.getName());
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        for (VersionedParameter versionedParameter : versionedParameterContext.getParameters()) {
            if (versionedParameter == null) continue;
            Parameter parameter = this.createParameter(null, versionedParameter);
            parameters.put(versionedParameter.getName(), parameter);
        }
        return this.context.getFlowManager().createParameterContext(parameterContextId, versionedParameterContext.getName(), versionedParameterContext.getDescription(), parameters, Collections.emptyList(), null);
    }

    private ParameterProviderConfiguration getParameterProviderConfiguration(VersionedParameterContext context) {
        return context.getParameterProvider() == null ? null : new StandardParameterProviderConfiguration(context.getParameterProvider(), context.getParameterGroupName(), context.isSynchronized());
    }

    private ParameterContext createParameterContext(VersionedParameterContext versionedParameterContext, String parameterContextId, Map<String, VersionedParameterContext> versionedParameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, ComponentIdGenerator componentIdGenerator) {
        Map<String, Parameter> parameters = this.createParameterMap(versionedParameterContext.getParameters());
        ArrayList parameterContextRefs = new ArrayList();
        if (versionedParameterContext.getInheritedParameterContexts() != null) {
            versionedParameterContext.getInheritedParameterContexts().stream().map(name -> this.createParameterReferenceId((String)name, versionedParameterContexts, parameterProviderReferences, componentIdGenerator)).forEach(parameterContextRefs::add);
        }
        AtomicReference contextReference = new AtomicReference();
        this.context.getFlowManager().withParameterContextResolution(() -> {
            ParameterContext created = this.context.getFlowManager().createParameterContext(parameterContextId, versionedParameterContext.getName(), versionedParameterContext.getDescription(), parameters, parameterContextRefs, this.getParameterProviderConfiguration(versionedParameterContext));
            contextReference.set(created);
        });
        return (ParameterContext)contextReference.get();
    }

    private Map<String, Parameter> createParameterMap(Collection<VersionedParameter> versionedParameters) {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        for (VersionedParameter versionedParameter : versionedParameters) {
            Parameter parameter = this.createParameter(null, versionedParameter);
            parameters.put(versionedParameter.getName(), parameter);
        }
        return parameters;
    }

    private String createParameterReferenceId(String parameterContextName, Map<String, VersionedParameterContext> versionedParameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, ComponentIdGenerator componentIdGenerator) {
        VersionedParameterContext versionedParameterContext = versionedParameterContexts.get(parameterContextName);
        ParameterContext selectedParameterContext = this.selectParameterContext(versionedParameterContext, versionedParameterContexts, parameterProviderReferences, componentIdGenerator);
        return selectedParameterContext.getIdentifier();
    }

    private ParameterContext selectParameterContext(VersionedParameterContext versionedParameterContext, Map<String, VersionedParameterContext> versionedParameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, ComponentIdGenerator componentIdGenerator) {
        ParameterContext selectedParameterContext;
        ParameterContext contextByName = this.getParameterContextByName(versionedParameterContext.getName());
        if (contextByName == null) {
            String parameterContextId = this.context.getFlowMappingOptions().getComponentIdLookup().getComponentId(Optional.ofNullable(versionedParameterContext.getIdentifier()), versionedParameterContext.getInstanceIdentifier());
            selectedParameterContext = this.createParameterContext(versionedParameterContext, parameterContextId, versionedParameterContexts, parameterProviderReferences, componentIdGenerator);
        } else {
            selectedParameterContext = contextByName;
            this.addMissingConfiguration(versionedParameterContext, selectedParameterContext, versionedParameterContexts, parameterProviderReferences, componentIdGenerator);
        }
        return selectedParameterContext;
    }

    private void addMissingConfiguration(VersionedParameterContext versionedParameterContext, ParameterContext currentParameterContext, Map<String, VersionedParameterContext> versionedParameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, ComponentIdGenerator componentIdGenerator) {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        for (VersionedParameter versionedParameter : versionedParameterContext.getParameters()) {
            Optional parameterOption = currentParameterContext.getParameter(versionedParameter.getName());
            if (parameterOption.isPresent()) continue;
            Parameter parameter = this.createParameter(currentParameterContext.getIdentifier(), versionedParameter);
            parameters.put(versionedParameter.getName(), parameter);
        }
        currentParameterContext.setParameters(parameters);
        if (versionedParameterContext.getInheritedParameterContexts() != null && !versionedParameterContext.getInheritedParameterContexts().isEmpty()) {
            currentParameterContext.setInheritedParameterContexts(versionedParameterContext.getInheritedParameterContexts().stream().map(name -> this.selectParameterContext((VersionedParameterContext)versionedParameterContexts.get(name), versionedParameterContexts, parameterProviderReferences, componentIdGenerator)).collect(Collectors.toList()));
        }
        if (versionedParameterContext.getParameterProvider() != null && currentParameterContext.getParameterProvider() == null) {
            this.createMissingParameterProvider(versionedParameterContext, versionedParameterContext.getParameterProvider(), parameterProviderReferences, componentIdGenerator);
            currentParameterContext.configureParameterProvider(this.getParameterProviderConfiguration(versionedParameterContext));
        }
    }

    private Parameter createParameter(String contextId, VersionedParameter versionedParameter) {
        ArrayList<Asset> assets;
        List referencedAssets = versionedParameter.getReferencedAssets();
        if (referencedAssets == null || referencedAssets.isEmpty()) {
            assets = null;
        } else {
            AssetManager assetManager = this.context.getAssetManager();
            assets = new ArrayList<Asset>();
            for (VersionedAsset reference : referencedAssets) {
                Optional assetOption = assetManager.getAsset(reference.getIdentifier());
                Asset asset = assetOption.orElseGet(() -> assetManager.createMissingAsset(contextId, reference.getName()));
                assets.add(asset);
            }
        }
        return new Parameter.Builder().name(versionedParameter.getName()).description(versionedParameter.getDescription()).sensitive(versionedParameter.isSensitive()).value(versionedParameter.getValue()).referencedAssets(assets).provided(Boolean.valueOf(versionedParameter.isProvided())).parameterContextId(contextId).build();
    }

    private boolean isEqual(BundleCoordinate coordinate, Bundle bundle) {
        if (!bundle.getGroup().equals(coordinate.getGroup())) {
            return false;
        }
        if (!bundle.getArtifact().equals(coordinate.getId())) {
            return false;
        }
        return bundle.getVersion().equals(coordinate.getVersion());
    }

    private BundleCoordinate toCoordinate(Bundle bundle) {
        return new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(Funnel funnel, VersionedFunnel proposed, ProcessGroup group, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException {
        if (funnel == null && proposed == null) {
            return;
        }
        long timeout = System.currentTimeMillis() + synchronizationOptions.getComponentStopTimeout().toMillis();
        if (proposed == null) {
            this.verifyCanDelete((Connectable)funnel, timeout);
        } else if (funnel != null) {
            funnel.verifyCanUpdate();
        }
        HashSet<Connectable> toRestart = new HashSet<Connectable>();
        try {
            if (proposed == null) {
                Set<Connectable> stoppedDownstream = this.stopDownstreamComponents((Connectable)funnel, timeout, synchronizationOptions);
                toRestart.addAll(stoppedDownstream);
                funnel.getProcessGroup().removeFunnel(funnel);
                LOG.info("Successfully synchronized {} by removing it from the flow", (Object)funnel);
            } else if (funnel == null) {
                Funnel added = this.addFunnel(group, proposed, synchronizationOptions.getComponentIdGenerator());
                LOG.info("Successfully synchronized {} by adding it to the flow", (Object)added);
            } else {
                this.updateFunnel(funnel, proposed);
                LOG.info("Successfully synchronized {} by updating it to match proposed version", (Object)funnel);
            }
        }
        finally {
            this.startComponents(toRestart, synchronizationOptions);
        }
    }

    @Override
    public void synchronize(Label label, VersionedLabel proposed, ProcessGroup group, FlowSynchronizationOptions synchronizationOptions) {
        if (label == null && proposed == null) {
            return;
        }
        if (proposed == null) {
            label.getProcessGroup().removeLabel(label);
        } else if (label == null) {
            this.addLabel(group, proposed, synchronizationOptions.getComponentIdGenerator());
        } else {
            this.updateLabel(label, proposed);
        }
    }

    private void updateFunnel(Funnel funnel, VersionedFunnel proposed) {
        funnel.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
    }

    private Funnel addFunnel(ProcessGroup destination, VersionedFunnel proposed, ComponentIdGenerator componentIdGenerator) {
        String id = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), destination.getIdentifier());
        Funnel funnel = this.context.getFlowManager().createFunnel(id);
        funnel.setVersionedComponentId(proposed.getIdentifier());
        destination.addFunnel(funnel);
        this.updateFunnel(funnel, proposed);
        this.connectableAdditionTracker.addComponent(destination.getIdentifier(), proposed.getIdentifier(), (Connectable)funnel);
        return funnel;
    }

    private boolean isUpdateable(Connection connection) {
        Optional versionIdOptional = connection.getVersionedComponentId();
        if (versionIdOptional.isPresent() && !this.updatedVersionedComponentIds.contains(versionIdOptional.get())) {
            return false;
        }
        Connectable source = connection.getSource();
        if (source.getConnectableType() != ConnectableType.FUNNEL && source.isRunning()) {
            return false;
        }
        Connectable destination = connection.getDestination();
        return destination.getConnectableType() == ConnectableType.FUNNEL || !destination.isRunning();
    }

    private String generateTemporaryPortName(VersionedPort proposedPort) {
        String versionedPortId = proposedPort.getIdentifier();
        String proposedPortFinalName = proposedPort.getName();
        return proposedPortFinalName + " (" + versionedPortId + ")";
    }

    private void updatePortToSetFinalName(Port port, String name) {
        port.setName(name);
    }

    private void verifyCanSynchronize(Port port, VersionedPort proposed, long timeout) throws InterruptedException, TimeoutException, FlowSynchronizationException {
        if (proposed == null) {
            this.verifyCanDelete((Connectable)port, timeout);
            return;
        }
        ComponentType proposedType = proposed.getComponentType();
        if (proposedType != ComponentType.INPUT_PORT && proposedType != ComponentType.OUTPUT_PORT) {
            throw new FlowSynchronizationException("Cannot synchronize port " + String.valueOf(port) + " with the proposed Port definition because its type is " + String.valueOf(proposedType) + " and expected either an INPUT_PORT or an OUTPUT_PORT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(Port port, VersionedPort proposed, ProcessGroup group, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException {
        if (port == null && proposed == null) {
            return;
        }
        long timeout = System.currentTimeMillis() + synchronizationOptions.getComponentStopTimeout().toMillis();
        this.verifyCanSynchronize(port, proposed, timeout);
        synchronizationOptions.getComponentScheduler().pause();
        try {
            boolean stopped;
            HashSet<Connectable> toRestart = new HashSet<Connectable>();
            if (port != null && (stopped = this.stopOrTerminate((Connectable)port, timeout, synchronizationOptions)) && proposed != null && proposed.getScheduledState() == ScheduledState.RUNNING) {
                toRestart.add((Connectable)port);
            }
            try {
                if (port == null) {
                    ComponentType proposedType = proposed.getComponentType();
                    Port newPort = proposedType == ComponentType.INPUT_PORT ? this.addInputPort(group, proposed, synchronizationOptions.getComponentIdGenerator(), proposed.getName()) : this.addOutputPort(group, proposed, synchronizationOptions.getComponentIdGenerator(), proposed.getName());
                    LOG.info("Successfully synchronized {} by adding it to the flow", (Object)newPort);
                } else if (proposed == null) {
                    Set<Connectable> stoppedDownstream = this.stopDownstreamComponents((Connectable)port, timeout, synchronizationOptions);
                    toRestart.addAll(stoppedDownstream);
                    this.verifyCanDelete((Connectable)port, timeout);
                    switch (port.getConnectableType()) {
                        case INPUT_PORT: {
                            port.getProcessGroup().removeInputPort(port);
                            break;
                        }
                        case OUTPUT_PORT: {
                            port.getProcessGroup().removeOutputPort(port);
                        }
                    }
                    LOG.info("Successfully synchronized {} by removing it from the flow", (Object)port);
                } else {
                    this.updatePort(port, proposed, proposed.getName());
                    LOG.info("Successfully synchronized {} by updating it to match proposed version", (Object)port);
                }
            }
            finally {
                this.startComponents(toRestart, synchronizationOptions);
            }
        }
        finally {
            synchronizationOptions.getComponentScheduler().resume();
        }
    }

    private void startComponents(Collection<Connectable> stoppedComponents, FlowSynchronizationOptions synchronizationOptions) {
        for (Connectable stoppedComponent : stoppedComponents) {
            this.context.getComponentScheduler().startComponent(stoppedComponent);
            this.notifyScheduledStateChange(stoppedComponent, synchronizationOptions, ScheduledState.RUNNING);
        }
    }

    private void updatePort(Port port, VersionedPort proposed, String temporaryName) {
        String name = temporaryName != null ? temporaryName : proposed.getName();
        port.setComments(proposed.getComments());
        port.setName(name);
        port.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
        port.setMaxConcurrentTasks(proposed.getConcurrentlySchedulableTaskCount().intValue());
        if (proposed.getPortFunction() != null) {
            port.setPortFunction(proposed.getPortFunction());
        }
        this.context.getComponentScheduler().transitionComponentState((Connectable)port, proposed.getScheduledState());
        this.notifyScheduledStateChange(port, this.syncOptions, proposed.getScheduledState());
    }

    private Port addInputPort(ProcessGroup destination, VersionedPort proposed, ComponentIdGenerator componentIdGenerator, String temporaryName) {
        String name = temporaryName != null ? temporaryName : proposed.getName();
        String id = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), destination.getIdentifier());
        Port port = proposed.isAllowRemoteAccess() != false ? this.context.getFlowManager().createPublicInputPort(id, name) : this.context.getFlowManager().createLocalInputPort(id, name);
        port.setVersionedComponentId(proposed.getIdentifier());
        if (proposed.getPortFunction() != null) {
            port.setPortFunction(proposed.getPortFunction());
        }
        destination.addInputPort(port);
        this.updatePort(port, proposed, temporaryName);
        this.connectableAdditionTracker.addComponent(destination.getIdentifier(), proposed.getIdentifier(), (Connectable)port);
        return port;
    }

    private Port addOutputPort(ProcessGroup destination, VersionedPort proposed, ComponentIdGenerator componentIdGenerator, String temporaryName) {
        String name = temporaryName != null ? temporaryName : proposed.getName();
        String id = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), destination.getIdentifier());
        Port port = proposed.isAllowRemoteAccess() != false ? this.context.getFlowManager().createPublicOutputPort(id, name) : this.context.getFlowManager().createLocalOutputPort(id, name);
        port.setVersionedComponentId(proposed.getIdentifier());
        if (proposed.getPortFunction() != null) {
            port.setPortFunction(proposed.getPortFunction());
        }
        destination.addOutputPort(port);
        this.updatePort(port, proposed, temporaryName);
        this.connectableAdditionTracker.addComponent(destination.getIdentifier(), proposed.getIdentifier(), (Connectable)port);
        return port;
    }

    private Label addLabel(ProcessGroup destination, VersionedLabel proposed, ComponentIdGenerator componentIdGenerator) {
        String id = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), destination.getIdentifier());
        Label label = this.context.getFlowManager().createLabel(id, proposed.getLabel());
        label.setVersionedComponentId(proposed.getIdentifier());
        destination.addLabel(label);
        this.updateLabel(label, proposed);
        return label;
    }

    private void updateLabel(Label label, VersionedLabel proposed) {
        label.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
        label.setSize(new Size(proposed.getWidth().doubleValue(), proposed.getHeight().doubleValue()));
        label.setStyle(proposed.getStyle());
        label.setValue(proposed.getLabel());
        if (proposed.getzIndex() != null) {
            label.setZIndex(proposed.getzIndex().longValue());
        }
    }

    private ProcessorNode addProcessor(ProcessGroup destination, VersionedProcessor proposed, ComponentIdGenerator componentIdGenerator, ProcessGroup topLevelGroup) throws ProcessorInstantiationException {
        String identifier = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), destination.getIdentifier());
        LOG.debug("Adding Processor with ID {} of type {}", (Object)identifier, (Object)proposed.getType());
        BundleCoordinate coordinate = this.toCoordinate(proposed.getBundle());
        ProcessorNode procNode = this.context.getFlowManager().createProcessor(proposed.getType(), identifier, coordinate, true);
        procNode.setVersionedComponentId(proposed.getIdentifier());
        destination.addProcessor(procNode);
        Map<String, String> decryptedProperties = this.getDecryptedProperties(proposed.getProperties());
        this.createdAndModifiedExtensions.add(new CreatedOrModifiedExtension((ComponentNode)procNode, decryptedProperties));
        this.updateProcessor(procNode, proposed, topLevelGroup);
        ProcessContext processContext = this.context.getProcessContextFactory().apply(procNode);
        procNode.onConfigurationRestored(processContext);
        this.connectableAdditionTracker.addComponent(destination.getIdentifier(), proposed.getIdentifier(), (Connectable)procNode);
        return procNode;
    }

    private void verifyCanSynchronize(ProcessorNode processor, VersionedProcessor proposedProcessor, long timeout) throws InterruptedException, TimeoutException, FlowSynchronizationException {
        if (processor == null) {
            return;
        }
        if (proposedProcessor == null) {
            this.verifyCanDelete((Connectable)processor, timeout);
            return;
        }
        processor.verifyCanUpdate();
    }

    private void verifyCanDelete(Connectable connectable, long timeout) throws InterruptedException, TimeoutException, FlowSynchronizationException {
        this.verifyNoIncomingConnections(connectable);
        this.verifyCanDeleteConnections(connectable, timeout);
        connectable.verifyCanDelete(true);
    }

    private void verifyCanDeleteConnections(Connectable connectable, long timeout) throws InterruptedException, TimeoutException, FlowSynchronizationException {
        Set connections = connectable.getConnections();
        for (Connection connection : connections) {
            this.verifyCanDeleteWhenQueueEmpty(connection);
        }
        for (Connection connection : connections) {
            this.waitForQueueEmpty(connection, Duration.ofMillis(timeout - System.currentTimeMillis()));
        }
    }

    private void verifyNoIncomingConnections(Connectable connectable) throws FlowSynchronizationException {
        for (Connection incoming : connectable.getIncomingConnections()) {
            Connectable source = incoming.getSource();
            if (source == connectable) continue;
            throw new FlowSynchronizationException("Cannot remove " + String.valueOf(connectable) + " because it has an incoming connection from " + String.valueOf(incoming.getSource()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(ProcessorNode processor, VersionedProcessor proposedProcessor, ProcessGroup group, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException {
        if (processor == null && proposedProcessor == null) {
            return;
        }
        this.setSynchronizationOptions(synchronizationOptions);
        long timeout = System.currentTimeMillis() + synchronizationOptions.getComponentStopTimeout().toMillis();
        synchronizationOptions.getComponentScheduler().pause();
        try {
            boolean stopped;
            HashSet<Connectable> toRestart = new HashSet<Connectable>();
            if (processor != null && (stopped = this.stopOrTerminate(processor, timeout, synchronizationOptions)) && proposedProcessor != null && proposedProcessor.getScheduledState() == ScheduledState.RUNNING) {
                toRestart.add((Connectable)processor);
            }
            try {
                this.verifyCanSynchronize(processor, proposedProcessor, timeout);
                try {
                    ProcessGroup topLevelGroup;
                    ProcessGroup processGroup = topLevelGroup = synchronizationOptions.getTopLevelGroupId() != null ? this.context.getFlowManager().getGroup(synchronizationOptions.getTopLevelGroupId()) : group;
                    if (proposedProcessor == null) {
                        Set<Connectable> stoppedDownstream = this.stopDownstreamComponents((Connectable)processor, timeout, synchronizationOptions);
                        toRestart.addAll(stoppedDownstream);
                        processor.getProcessGroup().removeProcessor(processor);
                        LOG.info("Successfully synchronized {} by removing it from the flow", (Object)processor);
                    } else if (processor == null) {
                        ProcessorNode added = this.addProcessor(group, proposedProcessor, synchronizationOptions.getComponentIdGenerator(), topLevelGroup);
                        LOG.info("Successfully synchronized {} by adding it to the flow", (Object)added);
                    } else {
                        this.updateProcessor(processor, proposedProcessor, topLevelGroup);
                        LOG.info("Successfully synchronized {} by updating it to match proposed version", (Object)processor);
                    }
                }
                catch (Exception e) {
                    throw new FlowSynchronizationException("Failed to synchronize processor " + String.valueOf(processor) + " with proposed version", e);
                }
            }
            finally {
                this.startComponents(toRestart, synchronizationOptions);
            }
        }
        finally {
            synchronizationOptions.getComponentScheduler().resume();
        }
    }

    private Set<Connectable> stopDownstreamComponents(Connectable component, long timeout, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException {
        HashSet<Connectable> stoppedComponents = new HashSet<Connectable>();
        for (Connection connection : component.getConnections()) {
            Connectable destination = connection.getDestination();
            boolean stopped = this.stopOrTerminate(destination, timeout, synchronizationOptions);
            if (!stopped) continue;
            stoppedComponents.add(destination);
        }
        return stoppedComponents;
    }

    private <T extends Connectable> Set<T> stopOrTerminate(Set<T> components, long timeout, FlowSynchronizationOptions synchronizationOptions) throws TimeoutException, FlowSynchronizationException {
        HashSet<Connectable> stoppedComponents = new HashSet<Connectable>();
        for (Connectable component : components) {
            boolean stopped = this.stopOrTerminate(component, timeout, synchronizationOptions);
            if (!stopped) continue;
            stoppedComponents.add(component);
        }
        return stoppedComponents;
    }

    private void notifyScheduledStateChange(Connectable component, FlowSynchronizationOptions synchronizationOptions, ScheduledState intendedState) {
        try {
            if (component instanceof ProcessorNode) {
                synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange((ProcessorNode)component, intendedState);
            } else if (component instanceof Port) {
                synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange((Port)component, intendedState);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to notify listeners of ScheduledState changes", (Throwable)e);
        }
    }

    private void notifyScheduledStateChange(ComponentNode component, FlowSynchronizationOptions synchronizationOptions, ScheduledState intendedState) {
        if (component instanceof Triggerable && intendedState == ScheduledState.RUNNING && ((Triggerable)component).getScheduledState() == org.apache.nifi.controller.ScheduledState.DISABLED) {
            return;
        }
        try {
            if (component instanceof ProcessorNode) {
                synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange((ProcessorNode)component, intendedState);
            } else if (component instanceof Port) {
                synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange((Port)component, intendedState);
            } else if (component instanceof ControllerServiceNode) {
                synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange((ControllerServiceNode)component, intendedState);
            } else if (component instanceof ReportingTaskNode) {
                ReportingTaskNode reportingTaskNode = (ReportingTaskNode)component;
                if (intendedState == ScheduledState.RUNNING && reportingTaskNode.getScheduledState() == org.apache.nifi.controller.ScheduledState.DISABLED) {
                    return;
                }
                synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange(reportingTaskNode, intendedState);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to notify listeners of ScheduledState changes", (Throwable)e);
        }
    }

    private void notifyScheduledStateChange(Collection<ControllerServiceNode> servicesToRestart, FlowSynchronizationOptions synchronizationOptions, ScheduledState intendedState) {
        try {
            servicesToRestart.forEach(service -> {
                synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange(service, intendedState);
                if (intendedState == ScheduledState.DISABLED) {
                    service.getReferences().findRecursiveReferences(ControllerServiceNode.class).forEach(reference -> synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange(reference, ScheduledState.DISABLED));
                } else if (intendedState == ScheduledState.ENABLED) {
                    service.getRequiredControllerServices().forEach(requiredService -> synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange(requiredService, ScheduledState.ENABLED));
                }
            });
        }
        catch (Exception e) {
            LOG.debug("Failed to notify listeners of ScheduledState changes", (Throwable)e);
        }
    }

    private void notifyScheduledStateChange(Port inputPort, FlowSynchronizationOptions synchronizationOptions, ScheduledState intendedState) {
        try {
            synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange(inputPort, intendedState);
        }
        catch (Exception e) {
            LOG.debug("Failed to notify listeners of ScheduledState changes", (Throwable)e);
        }
    }

    private boolean stopOrTerminate(Connectable component, long timeout, FlowSynchronizationOptions synchronizationOptions) throws TimeoutException, FlowSynchronizationException {
        if (!component.isRunning()) {
            return false;
        }
        ConnectableType connectableType = component.getConnectableType();
        switch (connectableType) {
            case INPUT_PORT: {
                Port inputPort = (Port)component;
                component.getProcessGroup().stopInputPort(inputPort);
                this.notifyScheduledStateChange(inputPort, synchronizationOptions, ScheduledState.ENABLED);
                return true;
            }
            case OUTPUT_PORT: {
                Port outputPort = (Port)component;
                component.getProcessGroup().stopOutputPort(outputPort);
                this.notifyScheduledStateChange(outputPort, synchronizationOptions, ScheduledState.ENABLED);
                return true;
            }
            case PROCESSOR: {
                ProcessorNode processorNode = (ProcessorNode)component;
                return this.stopOrTerminate(processorNode, timeout, synchronizationOptions);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopOrTerminate(ProcessorNode processor, long timeout, FlowSynchronizationOptions synchronizationOptions) throws TimeoutException, FlowSynchronizationException {
        try {
            LOG.debug("Stopping {} in order to synchronize it with proposed version", (Object)processor);
            boolean bl = this.stopProcessor(processor, timeout);
            return bl;
        }
        catch (TimeoutException te) {
            if (synchronizationOptions.getComponentStopTimeoutAction() == FlowSynchronizationOptions.ComponentStopTimeoutAction.THROW_TIMEOUT_EXCEPTION) {
                throw te;
            }
            processor.terminate();
            boolean bl = true;
            return bl;
        }
        finally {
            this.notifyScheduledStateChange((ComponentNode)processor, synchronizationOptions, ScheduledState.ENABLED);
        }
    }

    private boolean stopProcessor(ProcessorNode processor, long timeout) throws FlowSynchronizationException, TimeoutException {
        if (!processor.isRunning() && processor.getPhysicalScheduledState() != org.apache.nifi.controller.ScheduledState.STARTING) {
            return false;
        }
        CompletableFuture future = processor.getProcessGroup().stopProcessor(processor);
        try {
            future.get(timeout - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            return true;
        }
        catch (ExecutionException ee) {
            throw new FlowSynchronizationException("Failed to stop processor " + String.valueOf(processor), ee.getCause());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new FlowSynchronizationException("Interrupted while waiting for processor " + String.valueOf(processor) + " to stop", ie);
        }
    }

    private void stopControllerService(ControllerServiceNode controllerService, VersionedControllerService proposed, long timeout, FlowSynchronizationOptions.ComponentStopTimeoutAction timeoutAction, Set<ComponentNode> referencesStopped, Set<ControllerServiceNode> servicesDisabled, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException {
        ControllerServiceProvider serviceProvider = this.context.getControllerServiceProvider();
        if (controllerService == null) {
            return;
        }
        Map futures = serviceProvider.unscheduleReferencingComponents(controllerService);
        referencesStopped.addAll(futures.keySet());
        for (Map.Entry entry : futures.entrySet()) {
            ComponentNode component = (ComponentNode)entry.getKey();
            Future future = (Future)entry.getValue();
            this.waitForStopCompletion(future, component, timeout, timeoutAction);
            this.notifyScheduledStateChange(component, synchronizationOptions, ScheduledState.ENABLED);
        }
        if (controllerService.isActive()) {
            List referencingServices = controllerService.getReferences().findRecursiveReferences(ControllerServiceNode.class);
            if (proposed != null && proposed.getScheduledState() != ScheduledState.DISABLED) {
                servicesDisabled.add(controllerService);
            }
            for (ControllerServiceNode reference : referencingServices) {
                if (!reference.isActive()) continue;
                servicesDisabled.add(reference);
            }
            HashSet<ControllerServiceNode> hashSet = new HashSet<ControllerServiceNode>(servicesDisabled);
            hashSet.add(controllerService);
            CompletableFuture future = serviceProvider.disableControllerServicesAsync(hashSet);
            this.waitForStopCompletion(future, controllerService, timeout, timeoutAction);
            this.notifyScheduledStateChange(hashSet, synchronizationOptions, ScheduledState.DISABLED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcessor(ProcessorNode processor, VersionedProcessor proposed, ProcessGroup topLevelGroup) throws ProcessorInstantiationException {
        LOG.debug("Updating Processor {}", (Object)processor);
        processor.pauseValidationTrigger();
        try {
            processor.setAnnotationData(proposed.getAnnotationData());
            processor.setBulletinLevel(LogLevel.valueOf((String)proposed.getBulletinLevel()));
            processor.setComments(proposed.getComments());
            processor.setName(proposed.getName());
            processor.setPenalizationPeriod(proposed.getPenaltyDuration());
            if (!this.isEqual(processor.getBundleCoordinate(), proposed.getBundle())) {
                BundleCoordinate newBundleCoordinate = this.toCoordinate(proposed.getBundle());
                ArrayList descriptors = new ArrayList(processor.getProperties().keySet());
                Set additionalUrls = processor.getAdditionalClasspathResources(descriptors);
                this.context.getReloadComponent().reload(processor, proposed.getType(), newBundleCoordinate, additionalUrls);
            }
            Set<String> sensitiveDynamicPropertyNames = this.getSensitiveDynamicPropertyNames((ComponentNode)processor, proposed.getProperties(), proposed.getPropertyDescriptors().values());
            Map<String, String> properties = this.populatePropertiesMap((ComponentNode)processor, proposed.getProperties(), proposed.getPropertyDescriptors(), processor.getProcessGroup(), topLevelGroup);
            processor.setProperties(properties, true, sensitiveDynamicPropertyNames);
            processor.setRunDuration(proposed.getRunDurationMillis().longValue(), TimeUnit.MILLISECONDS);
            processor.setSchedulingStrategy(SchedulingStrategy.valueOf((String)proposed.getSchedulingStrategy()));
            processor.setSchedulingPeriod(proposed.getSchedulingPeriod());
            processor.setMaxConcurrentTasks(proposed.getConcurrentlySchedulableTaskCount().intValue());
            processor.setExecutionNode(ExecutionNode.valueOf((String)proposed.getExecutionNode()));
            processor.setStyle(proposed.getStyle());
            processor.setYieldPeriod(proposed.getYieldDuration());
            processor.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
            processor.setMaxBackoffPeriod(proposed.getMaxBackoffPeriod());
            processor.setRetriedRelationships(proposed.getRetriedRelationships());
            Set proposedAutoTerminated = proposed.getAutoTerminatedRelationships();
            if (proposedAutoTerminated != null) {
                Set relationshipsToAutoTerminate = proposedAutoTerminated.stream().map(arg_0 -> ((ProcessorNode)processor).getRelationship(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
                processor.setAutoTerminatedRelationships(relationshipsToAutoTerminate);
            }
            if (proposed.getRetryCount() != null) {
                processor.setRetryCount(proposed.getRetryCount());
            } else {
                processor.setRetryCount(Integer.valueOf(10));
            }
            if (proposed.getBackoffMechanism() != null) {
                processor.setBackoffMechanism(BackoffMechanism.valueOf((String)proposed.getBackoffMechanism()));
            }
            this.context.getComponentScheduler().transitionComponentState((Connectable)processor, proposed.getScheduledState());
            this.notifyScheduledStateChange((ComponentNode)processor, this.syncOptions, proposed.getScheduledState());
        }
        finally {
            processor.resumeValidationTrigger();
        }
    }

    private String getServiceInstanceId(String serviceVersionedComponentId, ProcessGroup group) {
        for (ControllerServiceNode serviceNode : group.getControllerServices(false)) {
            String versionedId = serviceNode.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(serviceNode.getIdentifier()));
            if (!versionedId.equals(serviceVersionedComponentId)) continue;
            return serviceNode.getIdentifier();
        }
        ProcessGroup parent = group.getParent();
        if (parent == null) {
            return null;
        }
        return this.getServiceInstanceId(serviceVersionedComponentId, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(RemoteProcessGroup rpg, VersionedRemoteProcessGroup proposed, ProcessGroup group, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException {
        if (rpg == null && proposed == null) {
            return;
        }
        this.setSynchronizationOptions(synchronizationOptions);
        long timeout = System.currentTimeMillis() + synchronizationOptions.getComponentStopTimeout().toMillis();
        synchronizationOptions.getComponentScheduler().pause();
        try {
            HashSet<Connectable> toRestart = new HashSet<Connectable>();
            if (rpg != null && rpg.isTransmitting()) {
                Iterator transmitting = this.getTransmittingPorts(rpg);
                Future future = rpg.stopTransmitting();
                try {
                    transmitting.forEach(remoteGroupPort -> synchronizationOptions.getScheduledStateChangeListener().onScheduledStateChange((Port)remoteGroupPort, ScheduledState.ENABLED));
                }
                catch (Exception e) {
                    LOG.debug("Failed to notify listeners of ScheduledState changes", (Throwable)e);
                }
                this.waitForStopCompletion(future, rpg, timeout, synchronizationOptions.getComponentStopTimeoutAction());
                boolean proposedTransmitting = this.isTransmitting(proposed);
                if (proposed != null && proposedTransmitting) {
                    toRestart.addAll((Collection<Connectable>)((Object)transmitting));
                }
            }
            try {
                if (proposed == null) {
                    for (RemoteGroupPort outPort : rpg.getOutputPorts()) {
                        Set<Connectable> stoppedDownstream = this.stopDownstreamComponents((Connectable)outPort, timeout, synchronizationOptions);
                        toRestart.addAll(stoppedDownstream);
                    }
                    for (RemoteGroupPort port : rpg.getInputPorts()) {
                        this.verifyCanDelete((Connectable)port, timeout);
                    }
                    for (RemoteGroupPort port : rpg.getOutputPorts()) {
                        this.verifyCanDelete((Connectable)port, timeout);
                    }
                    rpg.getProcessGroup().removeRemoteProcessGroup(rpg);
                    LOG.info("Successfully synchronized {} by removing it from the flow", (Object)rpg);
                } else if (rpg == null) {
                    RemoteProcessGroup added = this.addRemoteProcessGroup(group, proposed, synchronizationOptions.getComponentIdGenerator());
                    LOG.info("Successfully synchronized {} by adding it to the flow", (Object)added);
                } else {
                    this.updateRemoteProcessGroup(rpg, proposed, synchronizationOptions.getComponentIdGenerator());
                    LOG.info("Successfully synchronized {} by updating it to match proposed version", (Object)rpg);
                }
            }
            catch (Exception e) {
                throw new FlowSynchronizationException("Failed to synchronize " + String.valueOf(rpg) + " with proposed version", e);
            }
            finally {
                this.startComponents(toRestart, synchronizationOptions);
            }
        }
        finally {
            synchronizationOptions.getComponentScheduler().resume();
        }
    }

    private boolean isTransmitting(VersionedRemoteProcessGroup versionedRpg) {
        if (versionedRpg == null) {
            return false;
        }
        for (VersionedRemoteGroupPort port : versionedRpg.getInputPorts()) {
            if (port.getScheduledState() != ScheduledState.RUNNING) continue;
            return true;
        }
        for (VersionedRemoteGroupPort port : versionedRpg.getOutputPorts()) {
            if (port.getScheduledState() != ScheduledState.RUNNING) continue;
            return true;
        }
        return false;
    }

    private Set<RemoteGroupPort> getTransmittingPorts(RemoteProcessGroup rpg) {
        if (rpg == null) {
            return Collections.emptySet();
        }
        HashSet<RemoteGroupPort> transmitting = new HashSet<RemoteGroupPort>();
        rpg.getInputPorts().stream().filter(port -> port.getScheduledState() == org.apache.nifi.controller.ScheduledState.RUNNING).forEach(transmitting::add);
        rpg.getOutputPorts().stream().filter(port -> port.getScheduledState() == org.apache.nifi.controller.ScheduledState.RUNNING).forEach(transmitting::add);
        return transmitting;
    }

    private RemoteProcessGroup addRemoteProcessGroup(ProcessGroup destination, VersionedRemoteProcessGroup proposed, ComponentIdGenerator componentIdGenerator) {
        String id = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), destination.getIdentifier());
        RemoteProcessGroup rpg = this.context.getFlowManager().createRemoteProcessGroup(id, proposed.getTargetUris());
        rpg.setVersionedComponentId(proposed.getIdentifier());
        destination.addRemoteProcessGroup(rpg);
        this.updateRemoteProcessGroup(rpg, proposed, componentIdGenerator);
        rpg.initialize();
        return rpg;
    }

    private void updateRemoteProcessGroup(RemoteProcessGroup rpg, VersionedRemoteProcessGroup proposed, ComponentIdGenerator componentIdGenerator) {
        RemoteGroupPort remoteGroupPort;
        rpg.setComments(proposed.getComments());
        rpg.setCommunicationsTimeout(proposed.getCommunicationsTimeout());
        rpg.setInputPorts(proposed.getInputPorts() == null ? Collections.emptySet() : proposed.getInputPorts().stream().map(port -> this.createPortDescriptor((VersionedRemoteGroupPort)port, componentIdGenerator, rpg.getIdentifier())).collect(Collectors.toSet()), false);
        this.synchronizeRemoteGroupPorts(rpg.getInputPorts(), proposed.getInputPorts());
        this.synchronizeRemoteGroupPorts(rpg.getOutputPorts(), proposed.getOutputPorts());
        rpg.setName(proposed.getName());
        rpg.setNetworkInterface(proposed.getLocalNetworkInterface());
        rpg.setOutputPorts(proposed.getOutputPorts() == null ? Collections.emptySet() : proposed.getOutputPorts().stream().map(port -> this.createPortDescriptor((VersionedRemoteGroupPort)port, componentIdGenerator, rpg.getIdentifier())).collect(Collectors.toSet()), false);
        rpg.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
        rpg.setProxyHost(proposed.getProxyHost());
        rpg.setProxyPort(proposed.getProxyPort());
        rpg.setProxyUser(proposed.getProxyUser());
        rpg.setProxyPassword(StandardVersionedComponentSynchronizer.decrypt(proposed.getProxyPassword(), this.syncOptions.getPropertyDecryptor()));
        rpg.setTransportProtocol(SiteToSiteTransportProtocol.valueOf((String)proposed.getTransportProtocol()));
        rpg.setYieldDuration(proposed.getYieldDuration());
        if (this.syncOptions.isUpdateRpgUrls()) {
            rpg.setTargetUris(proposed.getTargetUris());
        }
        if (proposed.getInputPorts() != null) {
            for (VersionedRemoteGroupPort port2 : proposed.getInputPorts()) {
                remoteGroupPort = this.getRpgInputPort(port2, rpg, componentIdGenerator);
                if (remoteGroupPort == null) continue;
                this.synchronizeTransmissionState(port2, remoteGroupPort);
            }
        }
        if (proposed.getOutputPorts() != null) {
            for (VersionedRemoteGroupPort port2 : proposed.getOutputPorts()) {
                remoteGroupPort = this.getRpgOutputPort(port2, rpg, componentIdGenerator);
                if (remoteGroupPort == null) continue;
                this.synchronizeTransmissionState(port2, remoteGroupPort);
            }
        }
    }

    private void synchronizeRemoteGroupPorts(Set<RemoteGroupPort> remoteGroupPorts, Set<VersionedRemoteGroupPort> proposedPorts) {
        Map<String, VersionedRemoteGroupPort> inputPortsByTargetId = this.mapRemoteGroupPortsByTargetId(proposedPorts);
        remoteGroupPorts.forEach(port -> {
            VersionedRemoteGroupPort proposedPort = (VersionedRemoteGroupPort)inputPortsByTargetId.get(port.getTargetIdentifier());
            if (proposedPort != null) {
                if (proposedPort.getBatchSize() != null) {
                    BatchSize batchSize = proposedPort.getBatchSize();
                    port.setBatchSize(batchSize.getSize());
                    port.setBatchCount(batchSize.getCount());
                    port.setBatchDuration(batchSize.getDuration());
                }
                if (proposedPort.isUseCompression() != null) {
                    port.setUseCompression(proposedPort.isUseCompression().booleanValue());
                }
                if (proposedPort.getConcurrentlySchedulableTaskCount() != null) {
                    port.setMaxConcurrentTasks(proposedPort.getConcurrentlySchedulableTaskCount().intValue());
                }
            }
        });
    }

    private Map<String, VersionedRemoteGroupPort> mapRemoteGroupPortsByTargetId(Set<VersionedRemoteGroupPort> remoteGroupPorts) {
        return remoteGroupPorts == null ? Collections.emptyMap() : remoteGroupPorts.stream().collect(Collectors.toMap(VersionedRemoteGroupPort::getTargetId, Function.identity()));
    }

    private RemoteGroupPort getRpgInputPort(VersionedRemoteGroupPort port, RemoteProcessGroup rpg, ComponentIdGenerator componentIdGenerator) {
        return this.getRpgPort(port, rpg, componentIdGenerator, arg_0 -> ((RemoteProcessGroup)rpg).getInputPort(arg_0), rpg.getInputPorts());
    }

    private RemoteGroupPort getRpgOutputPort(VersionedRemoteGroupPort port, RemoteProcessGroup rpg, ComponentIdGenerator componentIdGenerator) {
        return this.getRpgPort(port, rpg, componentIdGenerator, arg_0 -> ((RemoteProcessGroup)rpg).getOutputPort(arg_0), rpg.getOutputPorts());
    }

    private RemoteGroupPort getRpgPort(VersionedRemoteGroupPort port, RemoteProcessGroup rpg, ComponentIdGenerator componentIdGenerator, Function<String, RemoteGroupPort> portLookup, Set<RemoteGroupPort> ports) {
        RemoteGroupPort remoteGroupPort;
        String instanceId = port.getInstanceIdentifier();
        if (instanceId != null && (remoteGroupPort = portLookup.apply(instanceId)) != null) {
            return remoteGroupPort;
        }
        Optional<RemoteGroupPort> portByName = ports.stream().filter(p -> p.getName().equals(port.getName())).findFirst();
        if (portByName.isPresent()) {
            return portByName.get();
        }
        String portId = componentIdGenerator.generateUuid(port.getIdentifier(), port.getInstanceIdentifier(), rpg.getIdentifier());
        RemoteGroupPort remoteGroupPort2 = portLookup.apply(portId);
        return remoteGroupPort2;
    }

    private void synchronizeTransmissionState(VersionedRemoteGroupPort versionedPort, RemoteGroupPort remoteGroupPort) {
        org.apache.nifi.controller.ScheduledState portState = remoteGroupPort.getScheduledState();
        if (versionedPort.getScheduledState() == ScheduledState.RUNNING) {
            if (portState != org.apache.nifi.controller.ScheduledState.RUNNING) {
                this.context.getComponentScheduler().startComponent((Connectable)remoteGroupPort);
                this.notifyScheduledStateChange((Port)remoteGroupPort, this.syncOptions, ScheduledState.RUNNING);
            }
        } else if (portState == org.apache.nifi.controller.ScheduledState.RUNNING) {
            this.context.getComponentScheduler().stopComponent((Connectable)remoteGroupPort);
            this.notifyScheduledStateChange((Port)remoteGroupPort, this.syncOptions, ScheduledState.ENABLED);
        }
    }

    private RemoteProcessGroupPortDescriptor createPortDescriptor(VersionedRemoteGroupPort proposed, ComponentIdGenerator componentIdGenerator, String rpgId) {
        StandardRemoteProcessGroupPortDescriptor descriptor = new StandardRemoteProcessGroupPortDescriptor();
        descriptor.setVersionedComponentId(proposed.getIdentifier());
        BatchSize batchSize = proposed.getBatchSize();
        if (batchSize != null) {
            descriptor.setBatchCount(batchSize.getCount());
            descriptor.setBatchDuration(batchSize.getDuration());
            descriptor.setBatchSize(batchSize.getSize());
        }
        descriptor.setComments(proposed.getComments());
        descriptor.setConcurrentlySchedulableTaskCount(proposed.getConcurrentlySchedulableTaskCount());
        descriptor.setGroupId(proposed.getRemoteGroupId());
        descriptor.setTargetId(proposed.getTargetId());
        String id = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), rpgId);
        descriptor.setId(id);
        descriptor.setName(proposed.getName());
        descriptor.setUseCompression(proposed.isUseCompression());
        return descriptor;
    }

    private void verifyCanSynchronize(Connection connection, VersionedConnection proposedConnection) throws FlowSynchronizationException {
        if (proposedConnection == null) {
            this.verifyCanDeleteWhenQueueEmpty(connection);
        }
    }

    private void verifyCanDeleteWhenQueueEmpty(Connection connection) throws FlowSynchronizationException {
        boolean empty = connection.getFlowFileQueue().isEmpty();
        if (empty) {
            return;
        }
        org.apache.nifi.controller.ScheduledState scheduledState = connection.getDestination().getScheduledState();
        if (scheduledState == org.apache.nifi.controller.ScheduledState.DISABLED || scheduledState == org.apache.nifi.controller.ScheduledState.STOPPED || scheduledState == org.apache.nifi.controller.ScheduledState.STOPPING) {
            throw new FlowSynchronizationException("Cannot synchronize " + String.valueOf(connection) + " with proposed connection because doing so would require deleting the connection, and the connection has data queued while the destination is not running. The connection must be emptied before it can be removed.");
        }
    }

    private Set<Connectable> getUpstreamComponents(Connection connection) {
        if (connection == null) {
            return Collections.emptySet();
        }
        HashSet<Connectable> components = new HashSet<Connectable>();
        this.findUpstreamComponents(connection, components);
        return components;
    }

    private void findUpstreamComponents(Connection connection, Set<Connectable> components) {
        Connectable source = connection.getSource();
        if (source.getConnectableType() == ConnectableType.FUNNEL) {
            source.getIncomingConnections().forEach(incoming -> this.findUpstreamComponents((Connection)incoming, components));
        } else {
            components.add(source);
        }
    }

    private Set<Connectable> getUpstreamComponents(VersionedConnection connection) {
        if (connection == null) {
            return Collections.emptySet();
        }
        HashSet<Connectable> components = new HashSet<Connectable>();
        this.findUpstreamComponents(connection, components);
        return components;
    }

    private void findUpstreamComponents(VersionedConnection connection, Set<Connectable> components) {
        ConnectableComponent sourceConnectable = connection.getSource();
        Connectable source = this.context.getFlowManager().findConnectable(sourceConnectable.getId());
        if (sourceConnectable.getType() == ConnectableComponentType.FUNNEL) {
            source.getIncomingConnections().forEach(incoming -> this.findUpstreamComponents((Connection)incoming, components));
        } else {
            components.add(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(Connection connection, VersionedConnection proposedConnection, ProcessGroup group, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException {
        Set<Connectable> stoppedComponents;
        if (connection == null && proposedConnection == null) {
            return;
        }
        long timeout = System.currentTimeMillis() + synchronizationOptions.getComponentStopTimeout().toMillis();
        HashSet<Connectable> upstream = new HashSet<Connectable>(this.getUpstreamComponents(connection));
        if (connection == null) {
            upstream.addAll(this.getUpstreamComponents(proposedConnection));
        }
        try {
            stoppedComponents = this.stopOrTerminate(upstream, timeout, synchronizationOptions);
        }
        catch (TimeoutException te) {
            if (synchronizationOptions.getComponentStopTimeoutAction() == FlowSynchronizationOptions.ComponentStopTimeoutAction.THROW_TIMEOUT_EXCEPTION) {
                throw te;
            }
            LOG.info("Components upstream of {} did not stop in time. Will terminate {}", (Object)connection, upstream);
            this.terminateComponents(upstream, synchronizationOptions);
            stoppedComponents = upstream;
        }
        try {
            Connectable destination;
            boolean stopped;
            this.verifyCanSynchronize(connection, proposedConnection);
            if (proposedConnection == null) {
                try {
                    this.waitForQueueEmpty(connection, synchronizationOptions.getComponentStopTimeout());
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new FlowSynchronizationException("Interrupted while waiting for FlowFile queue to empty for " + String.valueOf(connection), ie);
                }
            }
            if (connection != null && (stopped = this.stopOrTerminate(destination = connection.getDestination(), timeout, synchronizationOptions))) {
                stoppedComponents.add(destination);
            }
            if (connection == null) {
                Connection added = this.addConnection(group, proposedConnection, synchronizationOptions.getComponentIdGenerator());
                LOG.info("Successfully synchronized {} by adding it to the flow", (Object)added);
            } else if (proposedConnection == null) {
                connection.getProcessGroup().removeConnection(connection);
                LOG.info("Successfully synchronized {} by removing it from the flow", (Object)connection);
            } else {
                this.updateConnection(connection, proposedConnection);
                LOG.info("Successfully synchronized {} by updating it to match proposed version", (Object)connection);
            }
        }
        finally {
            if (proposedConnection != null) {
                this.startComponents(stoppedComponents, synchronizationOptions);
            }
        }
    }

    private void waitForQueueEmpty(Connection connection, Duration duration) throws TimeoutException, InterruptedException {
        if (connection == null) {
            return;
        }
        FlowFileQueue flowFileQueue = connection.getFlowFileQueue();
        long timeoutMillis = System.currentTimeMillis() + duration.toMillis();
        while (!flowFileQueue.isEmpty()) {
            if (System.currentTimeMillis() >= timeoutMillis) {
                throw new TimeoutException("Timed out waiting for " + String.valueOf(connection) + " to empty its FlowFiles");
            }
            Thread.sleep(10L);
        }
    }

    private void terminateComponents(Set<Connectable> components, FlowSynchronizationOptions synchronizationOptions) {
        for (Connectable component : components) {
            ProcessorNode processor;
            if (!(component instanceof ProcessorNode) || !(processor = (ProcessorNode)component).isRunning()) continue;
            processor.getProcessGroup().stopProcessor(processor);
            processor.terminate();
            this.notifyScheduledStateChange((ComponentNode)processor, synchronizationOptions, ScheduledState.ENABLED);
        }
    }

    private void updateConnection(Connection connection, VersionedConnection proposed) {
        LOG.debug("Updating connection from {} to {} with name {} and relationships {}: {}", new Object[]{proposed.getSource(), proposed.getDestination(), proposed.getName(), proposed.getSelectedRelationships(), connection});
        connection.setBendPoints(proposed.getBends() == null ? Collections.emptyList() : proposed.getBends().stream().map(pos -> new Position(pos.getX(), pos.getY())).collect(Collectors.toList()));
        connection.setDestination(this.getConnectable(connection.getProcessGroup(), proposed.getDestination()));
        connection.setLabelIndex(proposed.getLabelIndex().intValue());
        connection.setName(proposed.getName());
        connection.setRelationships((Collection)proposed.getSelectedRelationships().stream().map(name -> new Relationship.Builder().name(name).build()).collect(Collectors.toSet()));
        connection.setZIndex(proposed.getzIndex().longValue());
        FlowFileQueue queue = connection.getFlowFileQueue();
        queue.setBackPressureDataSizeThreshold(proposed.getBackPressureDataSizeThreshold());
        queue.setBackPressureObjectThreshold(proposed.getBackPressureObjectThreshold().longValue());
        queue.setFlowFileExpiration(proposed.getFlowFileExpiration());
        List prioritizers = proposed.getPrioritizers() == null ? Collections.emptyList() : proposed.getPrioritizers().stream().map(prioritizerName -> {
            try {
                return this.context.getFlowManager().createPrioritizer(prioritizerName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create Prioritizer of type " + prioritizerName + " for Connection with ID " + connection.getIdentifier());
            }
        }).collect(Collectors.toList());
        queue.setPriorities(prioritizers);
        String loadBalanceStrategyName = proposed.getLoadBalanceStrategy();
        if (loadBalanceStrategyName == null) {
            queue.setLoadBalanceStrategy(LoadBalanceStrategy.DO_NOT_LOAD_BALANCE, proposed.getPartitioningAttribute());
        } else {
            LoadBalanceStrategy loadBalanceStrategy = LoadBalanceStrategy.valueOf((String)loadBalanceStrategyName);
            String partitioningAttribute = proposed.getPartitioningAttribute();
            queue.setLoadBalanceStrategy(loadBalanceStrategy, partitioningAttribute);
        }
        String compressionName = proposed.getLoadBalanceCompression();
        if (compressionName == null) {
            queue.setLoadBalanceCompression(LoadBalanceCompression.DO_NOT_COMPRESS);
        } else {
            queue.setLoadBalanceCompression(LoadBalanceCompression.valueOf((String)compressionName));
        }
    }

    private Connection addConnection(ProcessGroup destinationGroup, VersionedConnection proposed, ComponentIdGenerator componentIdGenerator) {
        LOG.debug("Adding connection from {} to {} with name {} and relationships {}", new Object[]{proposed.getSource(), proposed.getDestination(), proposed.getName(), proposed.getSelectedRelationships()});
        Connectable source = this.getConnectable(destinationGroup, proposed.getSource());
        if (source == null) {
            throw new IllegalArgumentException("Connection has a source with identifier " + proposed.getSource().getId() + " but no component could be found in the Process Group with a corresponding identifier");
        }
        Connectable destination = this.getConnectable(destinationGroup, proposed.getDestination());
        if (destination == null) {
            throw new IllegalArgumentException("Connection has a destination with identifier " + proposed.getDestination().getId() + " but no component could be found in the Process Group with a corresponding identifier");
        }
        String id = componentIdGenerator.generateUuid(proposed.getIdentifier(), proposed.getInstanceIdentifier(), destination.getIdentifier());
        Connection connection = this.context.getFlowManager().createConnection(id, proposed.getName(), source, destination, (Collection)proposed.getSelectedRelationships());
        connection.setVersionedComponentId(proposed.getIdentifier());
        destinationGroup.addConnection(connection);
        this.updateConnection(connection, proposed);
        this.context.getFlowManager().onConnectionAdded(connection);
        return connection;
    }

    private Connectable getConnectable(ProcessGroup group, ConnectableComponent connectableComponent) {
        Connectable connectable = this.getConnectable(group, connectableComponent, ConnectableComponent::getInstanceIdentifier);
        if (connectable != null) {
            LOG.debug("Found Connectable {} in Process Group {} by Instance ID {}", new Object[]{connectable, group, connectableComponent.getInstanceIdentifier()});
            return connectable;
        }
        Connectable connectableById = this.getConnectable(group, connectableComponent, ConnectableComponent::getId);
        LOG.debug("Found no connectable in Process Group {} by Instance ID. Lookup by ID {} yielded {}", new Object[]{group, connectableComponent.getId(), connectableById});
        if (connectableById != null) {
            return connectableById;
        }
        Optional<Connectable> addedComponent = this.connectableAdditionTracker.getComponent(group.getIdentifier(), connectableComponent.getId());
        addedComponent.ifPresent(value -> LOG.debug("Found Connectable in Process Group {} as newly added component {}", (Object)group, value));
        return addedComponent.orElse(null);
    }

    private Connectable getConnectable(ProcessGroup group, ConnectableComponent connectableComponent, Function<ConnectableComponent, String> idFunction) {
        String id = idFunction.apply(connectableComponent);
        if (id == null) {
            return null;
        }
        switch (connectableComponent.getType()) {
            case FUNNEL: {
                return group.getFunnels().stream().filter(component -> this.matchesId(component, id)).findAny().orElse(null);
            }
            case INPUT_PORT: {
                Optional<Port> port = group.getInputPorts().stream().filter(component -> this.matchesId(component, id)).findAny();
                if (port.isPresent()) {
                    return (Connectable)port.get();
                }
                Optional<ProcessGroup> optionalSpecifiedGroup = group.getProcessGroups().stream().filter(child -> this.matchesGroupId((ProcessGroup)child, connectableComponent.getGroupId())).findFirst();
                if (optionalSpecifiedGroup.isPresent()) {
                    ProcessGroup specifiedGroup = optionalSpecifiedGroup.get();
                    return specifiedGroup.getInputPorts().stream().filter(component -> this.matchesId(component, id)).findAny().orElse(null);
                }
                return group.getProcessGroups().stream().flatMap(gr -> gr.getInputPorts().stream()).filter(component -> this.matchesId(component, id)).findAny().orElse(null);
            }
            case OUTPUT_PORT: {
                Optional<Port> port = group.getOutputPorts().stream().filter(component -> this.matchesId(component, id)).findAny();
                if (port.isPresent()) {
                    return (Connectable)port.get();
                }
                Optional<ProcessGroup> optionalSpecifiedGroup = group.getProcessGroups().stream().filter(child -> this.matchesGroupId((ProcessGroup)child, connectableComponent.getGroupId())).findFirst();
                if (optionalSpecifiedGroup.isPresent()) {
                    ProcessGroup specifiedGroup = optionalSpecifiedGroup.get();
                    return specifiedGroup.getOutputPorts().stream().filter(component -> this.matchesId(component, id)).findAny().orElse(null);
                }
                return group.getProcessGroups().stream().flatMap(gr -> gr.getOutputPorts().stream()).filter(component -> this.matchesId(component, id)).findAny().orElse(null);
            }
            case PROCESSOR: {
                return group.getProcessors().stream().filter(component -> this.matchesId(component, id)).findAny().orElse(null);
            }
            case REMOTE_INPUT_PORT: {
                String rpgId = connectableComponent.getGroupId();
                Optional<RemoteProcessGroup> rpgOption = group.getRemoteProcessGroups().stream().filter(component -> rpgId.equals(component.getIdentifier()) || rpgId.equals(component.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(component.getIdentifier())))).findAny();
                if (rpgOption.isEmpty()) {
                    throw new IllegalArgumentException("Connection refers to a Port with ID " + id + " within Remote Process Group with ID " + rpgId + " but could not find a Remote Process Group corresponding to that ID");
                }
                RemoteProcessGroup rpg = rpgOption.get();
                Optional<RemoteGroupPort> portByIdOption = rpg.getInputPorts().stream().filter(component -> this.matchesId(component, id)).findAny();
                if (portByIdOption.isPresent()) {
                    return (Connectable)portByIdOption.get();
                }
                return rpg.getInputPorts().stream().filter(component -> connectableComponent.getName().equals(component.getName())).findAny().orElse(null);
            }
            case REMOTE_OUTPUT_PORT: {
                String rpgId = connectableComponent.getGroupId();
                Optional<RemoteProcessGroup> rpgOption = group.getRemoteProcessGroups().stream().filter(component -> rpgId.equals(component.getIdentifier()) || rpgId.equals(component.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(component.getIdentifier())))).findAny();
                if (rpgOption.isEmpty()) {
                    throw new IllegalArgumentException("Connection refers to a Port with ID " + id + " within Remote Process Group with ID " + rpgId + " but could not find a Remote Process Group corresponding to that ID");
                }
                RemoteProcessGroup rpg = rpgOption.get();
                Optional<RemoteGroupPort> portByIdOption = rpg.getOutputPorts().stream().filter(component -> this.matchesId(component, id)).findAny();
                if (portByIdOption.isPresent()) {
                    return (Connectable)portByIdOption.get();
                }
                return rpg.getOutputPorts().stream().filter(component -> connectableComponent.getName().equals(component.getName())).findAny().orElse(null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(ReportingTaskNode reportingTask, VersionedReportingTask proposed, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException, ReportingTaskInstantiationException {
        if (reportingTask == null && proposed == null) {
            return;
        }
        synchronizationOptions.getComponentScheduler().pause();
        try {
            if (reportingTask != null && reportingTask.isRunning()) {
                reportingTask.stop();
            }
            if (proposed == null) {
                reportingTask.verifyCanDelete();
                this.context.getFlowManager().removeReportingTask(reportingTask);
                LOG.info("Successfully synchronized {} by removing it from the flow", (Object)reportingTask);
            } else if (reportingTask == null) {
                ReportingTaskNode added = this.addReportingTask(proposed);
                LOG.info("Successfully synchronized {} by adding it to the flow", (Object)added);
            } else {
                this.updateReportingTask(reportingTask, proposed);
                this.createdAndModifiedExtensions.add(new CreatedOrModifiedExtension((ComponentNode)reportingTask, this.getPropertyValues((ComponentNode)reportingTask)));
                LOG.info("Successfully synchronized {} by updating it to match proposed version", (Object)reportingTask);
            }
        }
        finally {
            synchronizationOptions.getComponentScheduler().resume();
        }
    }

    private ReportingTaskNode addReportingTask(VersionedReportingTask reportingTask) throws ReportingTaskInstantiationException {
        BundleCoordinate coordinate = this.toCoordinate(reportingTask.getBundle());
        ReportingTaskNode taskNode = this.context.getFlowManager().createReportingTask(reportingTask.getType(), reportingTask.getInstanceIdentifier(), coordinate, false);
        this.updateReportingTask(taskNode, reportingTask);
        Map<String, String> decryptedProperties = this.getDecryptedProperties(reportingTask.getProperties());
        this.createdAndModifiedExtensions.add(new CreatedOrModifiedExtension((ComponentNode)taskNode, decryptedProperties));
        return taskNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReportingTask(ReportingTaskNode reportingTask, VersionedReportingTask proposed) throws ReportingTaskInstantiationException {
        LOG.debug("Updating Reporting Task {}", (Object)reportingTask);
        reportingTask.pauseValidationTrigger();
        try {
            reportingTask.setName(proposed.getName());
            reportingTask.setComments(proposed.getComments());
            reportingTask.setSchedulingPeriod(proposed.getSchedulingPeriod());
            reportingTask.setSchedulingStrategy(SchedulingStrategy.valueOf((String)proposed.getSchedulingStrategy()));
            reportingTask.setAnnotationData(proposed.getAnnotationData());
            if (!this.isEqual(reportingTask.getBundleCoordinate(), proposed.getBundle())) {
                BundleCoordinate newBundleCoordinate = this.toCoordinate(proposed.getBundle());
                ArrayList descriptors = new ArrayList(reportingTask.getProperties().keySet());
                Set additionalUrls = reportingTask.getAdditionalClasspathResources(descriptors);
                this.context.getReloadComponent().reload(reportingTask, proposed.getType(), newBundleCoordinate, additionalUrls);
            }
            Set<String> sensitiveDynamicPropertyNames = this.getSensitiveDynamicPropertyNames((ComponentNode)reportingTask, proposed.getProperties(), proposed.getPropertyDescriptors().values());
            reportingTask.setProperties(proposed.getProperties(), false, sensitiveDynamicPropertyNames);
            switch (proposed.getScheduledState()) {
                case DISABLED: {
                    if (reportingTask.isRunning()) {
                        reportingTask.stop();
                    }
                    reportingTask.disable();
                    break;
                }
                case ENABLED: {
                    if (reportingTask.getScheduledState() == org.apache.nifi.controller.ScheduledState.DISABLED) {
                        reportingTask.enable();
                        break;
                    }
                    if (!reportingTask.isRunning()) break;
                    reportingTask.stop();
                    break;
                }
                case RUNNING: {
                    if (reportingTask.getScheduledState() == org.apache.nifi.controller.ScheduledState.DISABLED) {
                        reportingTask.enable();
                    }
                    if (reportingTask.isRunning()) break;
                    reportingTask.start();
                }
            }
            this.notifyScheduledStateChange((ComponentNode)reportingTask, this.syncOptions, proposed.getScheduledState());
        }
        finally {
            reportingTask.resumeValidationTrigger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(FlowAnalysisRuleNode flowAnalysisRule, VersionedFlowAnalysisRule proposed, FlowSynchronizationOptions synchronizationOptions) throws FlowSynchronizationException, TimeoutException, InterruptedException, FlowAnalysisRuleInstantiationException {
        if (flowAnalysisRule == null && proposed == null) {
            return;
        }
        synchronizationOptions.getComponentScheduler().pause();
        try {
            if (flowAnalysisRule != null && flowAnalysisRule.isEnabled()) {
                flowAnalysisRule.disable();
            }
            if (proposed == null) {
                flowAnalysisRule.verifyCanDelete();
                this.context.getFlowManager().removeFlowAnalysisRule(flowAnalysisRule);
                LOG.info("Successfully synchronized {} by removing it from the flow", (Object)flowAnalysisRule);
            } else if (flowAnalysisRule == null) {
                FlowAnalysisRuleNode added = this.addFlowAnalysisRule(proposed);
                LOG.info("Successfully synchronized {} by adding it to the flow", (Object)added);
            } else {
                this.updateFlowAnalysisRule(flowAnalysisRule, proposed);
                LOG.info("Successfully synchronized {} by updating it to match proposed version", (Object)flowAnalysisRule);
            }
        }
        finally {
            synchronizationOptions.getComponentScheduler().resume();
        }
    }

    private FlowAnalysisRuleNode addFlowAnalysisRule(VersionedFlowAnalysisRule flowAnalysisRule) throws FlowAnalysisRuleInstantiationException {
        BundleCoordinate coordinate = this.toCoordinate(flowAnalysisRule.getBundle());
        FlowAnalysisRuleNode ruleNode = this.context.getFlowManager().createFlowAnalysisRule(flowAnalysisRule.getType(), flowAnalysisRule.getInstanceIdentifier(), coordinate, false);
        this.updateFlowAnalysisRule(ruleNode, flowAnalysisRule);
        return ruleNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlowAnalysisRule(FlowAnalysisRuleNode flowAnalysisRule, VersionedFlowAnalysisRule proposed) throws FlowAnalysisRuleInstantiationException {
        LOG.debug("Updating Flow Analysis Rule {}", (Object)flowAnalysisRule);
        flowAnalysisRule.pauseValidationTrigger();
        try {
            flowAnalysisRule.setName(proposed.getName());
            flowAnalysisRule.setComments(proposed.getComments());
            flowAnalysisRule.setEnforcementPolicy(proposed.getEnforcementPolicy());
            if (!this.isEqual(flowAnalysisRule.getBundleCoordinate(), proposed.getBundle())) {
                BundleCoordinate newBundleCoordinate = this.toCoordinate(proposed.getBundle());
                ArrayList descriptors = new ArrayList(flowAnalysisRule.getProperties().keySet());
                Set additionalUrls = flowAnalysisRule.getAdditionalClasspathResources(descriptors);
                this.context.getReloadComponent().reload(flowAnalysisRule, proposed.getType(), newBundleCoordinate, additionalUrls);
            }
            Set<String> sensitiveDynamicPropertyNames = this.getSensitiveDynamicPropertyNames((ComponentNode)flowAnalysisRule, proposed.getProperties(), proposed.getPropertyDescriptors().values());
            flowAnalysisRule.setProperties(proposed.getProperties(), false, sensitiveDynamicPropertyNames);
            switch (proposed.getScheduledState()) {
                case DISABLED: {
                    if (!flowAnalysisRule.isEnabled()) break;
                    flowAnalysisRule.disable();
                    break;
                }
                case ENABLED: {
                    if (flowAnalysisRule.isEnabled()) break;
                    flowAnalysisRule.enable();
                }
            }
            this.notifyScheduledStateChange((ComponentNode)flowAnalysisRule, this.syncOptions, proposed.getScheduledState());
        }
        finally {
            flowAnalysisRule.resumeValidationTrigger();
        }
    }

    private <T extends org.apache.nifi.components.VersionedComponent & Connectable> boolean matchesId(T component, String id) {
        return id.equals(((Connectable)component).getIdentifier()) || id.equals(component.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(((Connectable)component).getIdentifier())));
    }

    private boolean matchesGroupId(ProcessGroup group, String groupId) {
        return groupId.equals(group.getIdentifier()) || group.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(group.getIdentifier())).equals(groupId);
    }

    private void findAllProcessors(Set<VersionedProcessor> processors, Set<VersionedProcessGroup> childGroups, Map<String, VersionedProcessor> map) {
        for (VersionedProcessor processor : processors) {
            map.put(processor.getIdentifier(), processor);
        }
        for (VersionedProcessGroup childGroup : childGroups) {
            this.findAllProcessors(childGroup.getProcessors(), childGroup.getProcessGroups(), map);
        }
    }

    private void findAllControllerServices(Set<VersionedControllerService> controllerServices, Set<VersionedProcessGroup> childGroups, Map<String, VersionedControllerService> map) {
        for (VersionedControllerService service : controllerServices) {
            map.put(service.getIdentifier(), service);
        }
        for (VersionedProcessGroup childGroup : childGroups) {
            this.findAllControllerServices(childGroup.getControllerServices(), childGroup.getProcessGroups(), map);
        }
    }

    private void findAllConnections(Set<VersionedConnection> connections, Set<VersionedProcessGroup> childGroups, Map<String, VersionedConnection> map) {
        for (VersionedConnection connection : connections) {
            map.put(connection.getIdentifier(), connection);
        }
        for (VersionedProcessGroup childGroup : childGroups) {
            this.findAllConnections(childGroup.getConnections(), childGroup.getProcessGroups(), map);
        }
    }

    private void verifyCanRemoveMissingComponents(ProcessGroup processGroup, VersionedProcessGroup proposedGroup, boolean verifyConnectionRemoval) {
        String versionedId;
        if (verifyConnectionRemoval) {
            Map proposedConnectionsByVersionedId = proposedGroup.getConnections().stream().collect(Collectors.toMap(VersionedComponent::getIdentifier, Function.identity()));
            for (Connection connection2 : processGroup.getConnections()) {
                FlowFileQueue flowFileQueue;
                versionedId = connection2.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(connection2.getIdentifier()));
                VersionedConnection proposedConnection = (VersionedConnection)proposedConnectionsByVersionedId.get(versionedId);
                if (proposedConnection != null || (flowFileQueue = connection2.getFlowFileQueue()).isEmpty()) continue;
                throw new IllegalStateException(String.valueOf(processGroup) + " cannot be updated to the proposed flow because the proposed flow does not contain a match for " + String.valueOf(connection2) + " and the connection currently has data in the queue.");
            }
        }
        Map proposedGroupsByVersionedId = proposedGroup.getProcessGroups().stream().collect(Collectors.toMap(VersionedComponent::getIdentifier, Function.identity()));
        for (ProcessGroup childGroup : processGroup.getProcessGroups()) {
            versionedId = childGroup.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(childGroup.getIdentifier()));
            VersionedProcessGroup proposedChildGroup = (VersionedProcessGroup)proposedGroupsByVersionedId.get(versionedId);
            if (proposedChildGroup == null) {
                Connection removedConnection;
                if (!verifyConnectionRemoval || (removedConnection = (Connection)childGroup.findAllConnections().stream().filter(connection -> !connection.getFlowFileQueue().isEmpty()).findFirst().orElse(null)) == null) continue;
                throw new IllegalStateException(String.valueOf(processGroup) + " cannot be updated to the proposed flow because the proposed flow does not contain a match for " + String.valueOf(removedConnection) + " and the connection currently has data in the queue.");
            }
            this.verifyCanRemoveMissingComponents(childGroup, proposedChildGroup, verifyConnectionRemoval);
        }
    }

    private ControllerServiceNode getVersionedControllerService(ProcessGroup group, String versionedComponentId) {
        if (group == null) {
            return null;
        }
        for (ControllerServiceNode serviceNode : group.getControllerServices(false)) {
            String serviceNodeVersionedComponentId = serviceNode.getVersionedComponentId().orElse(NiFiRegistryFlowMapper.generateVersionedComponentId(serviceNode.getIdentifier()));
            if (!serviceNodeVersionedComponentId.equals(versionedComponentId)) continue;
            return serviceNode;
        }
        return this.getVersionedControllerService(group.getParent(), versionedComponentId);
    }

    private Map<String, String> getPropertyValues(ComponentNode componentNode) {
        HashMap<String, String> propertyValues = new HashMap<String, String>();
        if (componentNode.getRawPropertyValues() != null) {
            for (Map.Entry entry : componentNode.getRawPropertyValues().entrySet()) {
                propertyValues.put(((PropertyDescriptor)entry.getKey()).getName(), (String)entry.getValue());
            }
        }
        return propertyValues;
    }

    private record CreatedOrModifiedExtension(ComponentNode extension, Map<String, String> propertyValues) {
    }

    private record ParameterValueAndReferences(String value, List<String> assetIds) {
    }
}

