/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProcessorEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.RemoteProcessGroupEndpointMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;

public class FlowSnippetEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern FLOW_SNIPPET_INSTANCE_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/snippet-instance");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "POST".equalsIgnoreCase(method) && FLOW_SNIPPET_INSTANCE_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        FlowEntity responseEntity = (FlowEntity)clientResponse.getClientResponse().readEntity(FlowEntity.class);
        FlowDTO flowDto = responseEntity.getFlow();
        if (flowDto == null) {
            return clientResponse;
        }
        HashMap<String, Map> processorMap = new HashMap<String, Map>();
        HashMap<String, Map> remoteProcessGroupMap = new HashMap<String, Map>();
        for (NodeResponse nodeResponse : successfulResponses) {
            Map innerMap;
            FlowEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (FlowEntity)nodeResponse.getClientResponse().readEntity(FlowEntity.class);
            FlowDTO nodeContents = nodeResponseEntity.getFlow();
            for (ProcessorEntity nodeProcessor : nodeContents.getProcessors()) {
                innerMap = processorMap.computeIfAbsent(nodeProcessor.getId(), id -> new HashMap());
                innerMap.put(nodeResponse.getNodeId(), nodeProcessor);
            }
            for (RemoteProcessGroupEntity nodeRemoteProcessGroup : nodeContents.getRemoteProcessGroups()) {
                innerMap = remoteProcessGroupMap.computeIfAbsent(nodeRemoteProcessGroup.getId(), id -> new HashMap());
                innerMap.put(nodeResponse.getNodeId(), nodeRemoteProcessGroup);
            }
        }
        ProcessorEndpointMerger procMerger = new ProcessorEndpointMerger();
        for (ProcessorEntity processor : flowDto.getProcessors()) {
            String procId = processor.getId();
            Map mergeMap = (Map)processorMap.get(procId);
            procMerger.mergeResponses(processor, (Map<NodeIdentifier, ProcessorEntity>)mergeMap, successfulResponses, problematicResponses);
        }
        RemoteProcessGroupEndpointMerger remoteProcessGroupEndpointMerger = new RemoteProcessGroupEndpointMerger();
        for (RemoteProcessGroupEntity remoteProcessGroup : flowDto.getRemoteProcessGroups()) {
            String remoteProcessGroupId = remoteProcessGroup.getId();
            Map mergeMap = (Map)remoteProcessGroupMap.get(remoteProcessGroupId);
            remoteProcessGroupEndpointMerger.mergeResponses(remoteProcessGroup, (Map<NodeIdentifier, RemoteProcessGroupEntity>)mergeMap, successfulResponses, problematicResponses);
        }
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

