/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterContextMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterContextUpdateRequestDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;

public class ParameterContextUpdateEndpointMerger
extends AbstractSingleEntityEndpoint<ParameterContextUpdateRequestEntity>
implements EndpointResponseMerger {
    private static final Pattern PARAMETER_CONTEXT_UPDATE_REQUEST_URI = Pattern.compile("/nifi-api/parameter-contexts/[a-f0-9\\-]{36}/update-requests(/[a-f0-9\\-]{36})?");

    @Override
    public boolean canHandle(URI uri, String method) {
        return ("GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method)) && PARAMETER_CONTEXT_UPDATE_REQUEST_URI.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ParameterContextUpdateRequestEntity> getEntityClass() {
        return ParameterContextUpdateRequestEntity.class;
    }

    @Override
    protected void mergeResponses(ParameterContextUpdateRequestEntity clientEntity, Map<NodeIdentifier, ParameterContextUpdateRequestEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        ParameterContextUpdateRequestDTO clientUpdateRequestDto = clientEntity.getRequest();
        HashMap<String, AffectedComponentEntity> affectedComponentEntities = new HashMap<String, AffectedComponentEntity>();
        for (ParameterContextUpdateRequestEntity requestEntity : entityMap.values()) {
            ParameterContextUpdateRequestDTO updateRequestDto = requestEntity.getRequest();
            clientUpdateRequestDto.setComplete(clientUpdateRequestDto.isComplete() && updateRequestDto.isComplete());
            if (updateRequestDto.getFailureReason() != null) {
                clientUpdateRequestDto.setFailureReason(updateRequestDto.getFailureReason());
            }
            clientUpdateRequestDto.setLastUpdated(new Date(Math.min(clientUpdateRequestDto.getLastUpdated().getTime(), updateRequestDto.getLastUpdated().getTime())));
            clientUpdateRequestDto.setPercentCompleted(Math.min(clientUpdateRequestDto.getPercentCompleted(), updateRequestDto.getPercentCompleted()));
            for (AffectedComponentEntity entity2 : requestEntity.getRequest().getReferencingComponents()) {
                AffectedComponentEntity mergedAffectedComponentEntity = (AffectedComponentEntity)affectedComponentEntities.get(entity2.getId());
                if (mergedAffectedComponentEntity == null) {
                    affectedComponentEntities.put(entity2.getId(), entity2);
                    return;
                }
                ParameterContextMerger.merge(mergedAffectedComponentEntity, entity2);
            }
        }
        HashMap<NodeIdentifier, ParameterContextDTO> contextDtoMap = new HashMap<NodeIdentifier, ParameterContextDTO>();
        entityMap.forEach((nodeId, entity) -> contextDtoMap.put((NodeIdentifier)nodeId, entity.getRequest().getParameterContext()));
        ParameterContextMerger.merge(clientUpdateRequestDto.getParameterContext(), contextDtoMap);
        clientUpdateRequestDto.setReferencingComponents(new HashSet(affectedComponentEntities.values()));
    }
}

