/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.queue.ListFlowFileState;
import org.apache.nifi.web.api.dto.FlowFileSummaryDTO;
import org.apache.nifi.web.api.dto.ListingRequestDTO;
import org.apache.nifi.web.api.dto.QueueSizeDTO;
import org.apache.nifi.web.api.entity.ListingRequestEntity;

public class ListFlowFilesEndpointMerger
extends AbstractSingleDTOEndpoint<ListingRequestEntity, ListingRequestDTO> {
    public static final Pattern LISTING_REQUESTS_URI = Pattern.compile("/nifi-api/flowfile-queues/[a-f0-9\\-]{36}/listing-requests");
    public static final Pattern LISTING_REQUEST_URI = Pattern.compile("/nifi-api/flowfile-queues/[a-f0-9\\-]{36}/listing-requests/[a-f0-9\\-]{36}");

    @Override
    public boolean canHandle(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method)) && LISTING_REQUEST_URI.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && LISTING_REQUESTS_URI.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ListingRequestEntity> getEntityClass() {
        return ListingRequestEntity.class;
    }

    @Override
    protected ListingRequestDTO getDto(ListingRequestEntity entity) {
        return entity.getListingRequest();
    }

    @Override
    protected void mergeResponses(ListingRequestDTO clientDto, Map<NodeIdentifier, ListingRequestDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        Comparator comparator = (dto1, dto2) -> {
            int positionCompare = dto1.getPosition().compareTo(dto2.getPosition());
            if (positionCompare != 0) {
                return positionCompare;
            }
            String address1 = dto1.getClusterNodeAddress();
            String address2 = dto2.getClusterNodeAddress();
            if (address1 == null && address2 == null) {
                return 0;
            }
            if (address1 == null) {
                return 1;
            }
            if (address2 == null) {
                return -1;
            }
            return address1.compareTo(address2);
        };
        TreeSet<FlowFileSummaryDTO> flowFileSummaries = new TreeSet<FlowFileSummaryDTO>(comparator);
        ListFlowFileState state = null;
        int numStepsCompleted = 0;
        int numStepsTotal = 0;
        int objectCount = 0;
        long byteCount = 0L;
        boolean finished = true;
        for (Map.Entry<NodeIdentifier, ListingRequestDTO> entry : dtoMap.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            String nodeAddress = nodeIdentifier.getApiAddress() + ":" + nodeIdentifier.getApiPort();
            ListingRequestDTO nodeRequest = entry.getValue();
            ++numStepsTotal;
            if (Boolean.TRUE.equals(nodeRequest.getFinished())) {
                ++numStepsCompleted;
            }
            QueueSizeDTO nodeQueueSize = nodeRequest.getQueueSize();
            objectCount += nodeQueueSize.getObjectCount();
            byteCount += nodeQueueSize.getByteCount();
            if (!nodeRequest.getFinished().booleanValue()) {
                finished = false;
            }
            if (nodeRequest.getLastUpdated().after(clientDto.getLastUpdated())) {
                clientDto.setLastUpdated(nodeRequest.getLastUpdated());
            }
            ListFlowFileState nodeState = ListFlowFileState.valueOfDescription((String)nodeRequest.getState());
            if (state == null || state.compareTo((Enum)nodeState) > 0) {
                state = nodeState;
            }
            if (nodeRequest.getFlowFileSummaries() != null) {
                for (FlowFileSummaryDTO summaryDTO : nodeRequest.getFlowFileSummaries()) {
                    if (summaryDTO.getClusterNodeId() == null || summaryDTO.getClusterNodeAddress() == null) {
                        summaryDTO.setClusterNodeId(nodeIdentifier.getId());
                        summaryDTO.setClusterNodeAddress(nodeAddress);
                    }
                    flowFileSummaries.add(summaryDTO);
                    if (flowFileSummaries.size() <= clientDto.getMaxResults()) continue;
                    flowFileSummaries.pollLast();
                }
            }
            if (nodeRequest.getFailureReason() == null) continue;
            clientDto.setFailureReason(nodeRequest.getFailureReason());
        }
        ArrayList summaryDTOs = new ArrayList(flowFileSummaries);
        clientDto.setFlowFileSummaries(summaryDTOs);
        int percentCompleted = numStepsTotal == 0 ? 1 : numStepsCompleted / numStepsTotal;
        clientDto.setPercentCompleted(Integer.valueOf(percentCompleted));
        clientDto.setFinished(Boolean.valueOf(finished));
        clientDto.getQueueSize().setByteCount(byteCount);
        clientDto.getQueueSize().setObjectCount(objectCount);
    }
}

