/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.BulletinMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ControllerBulletinsEntity;

public class ControllerBulletinsEndpointMerger
extends AbstractSingleEntityEndpoint<ControllerBulletinsEntity>
implements EndpointResponseMerger {
    public static final Pattern CONTROLLER_BULLETINS_URI_PATTERN = Pattern.compile("/nifi-api/flow/controller/bulletins");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && CONTROLLER_BULLETINS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ControllerBulletinsEntity> getEntityClass() {
        return ControllerBulletinsEntity.class;
    }

    @Override
    protected void mergeResponses(ControllerBulletinsEntity clientEntity, Map<NodeIdentifier, ControllerBulletinsEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        HashMap<NodeIdentifier, List<BulletinEntity>> bulletinDtos = new HashMap<NodeIdentifier, List<BulletinEntity>>();
        HashMap<NodeIdentifier, List<BulletinEntity>> controllerServiceBulletinDtos = new HashMap<NodeIdentifier, List<BulletinEntity>>();
        HashMap<NodeIdentifier, List<BulletinEntity>> reportingTaskBulletinDtos = new HashMap<NodeIdentifier, List<BulletinEntity>>();
        HashMap<NodeIdentifier, List<BulletinEntity>> flowAnalysisRuleBulletinDtos = new HashMap<NodeIdentifier, List<BulletinEntity>>();
        HashMap<NodeIdentifier, List<BulletinEntity>> flowRegistryClientBulletinDtos = new HashMap<NodeIdentifier, List<BulletinEntity>>();
        HashMap parameterProviderBulletinDtos = new HashMap();
        for (Map.Entry<NodeIdentifier, ControllerBulletinsEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            ControllerBulletinsEntity entity = entry.getValue();
            String nodeAddress = nodeIdentifier.getApiAddress() + ":" + nodeIdentifier.getApiPort();
            if (entity.getBulletins() != null) {
                entity.getBulletins().forEach(bulletin -> {
                    if (bulletin.getNodeAddress() == null) {
                        bulletin.setNodeAddress(nodeAddress);
                    }
                    bulletinDtos.computeIfAbsent(nodeIdentifier, nodeId -> new ArrayList()).add(bulletin);
                });
            }
            if (entity.getControllerServiceBulletins() != null) {
                entity.getControllerServiceBulletins().forEach(bulletin -> {
                    if (bulletin.getNodeAddress() == null) {
                        bulletin.setNodeAddress(nodeAddress);
                    }
                    controllerServiceBulletinDtos.computeIfAbsent(nodeIdentifier, nodeId -> new ArrayList()).add(bulletin);
                });
            }
            if (entity.getReportingTaskBulletins() != null) {
                entity.getReportingTaskBulletins().forEach(bulletin -> {
                    if (bulletin.getNodeAddress() == null) {
                        bulletin.setNodeAddress(nodeAddress);
                    }
                    reportingTaskBulletinDtos.computeIfAbsent(nodeIdentifier, nodeId -> new ArrayList()).add(bulletin);
                });
            }
            if (entity.getFlowAnalysisRuleBulletins() != null) {
                entity.getFlowAnalysisRuleBulletins().forEach(bulletin -> {
                    if (bulletin.getNodeAddress() == null) {
                        bulletin.setNodeAddress(nodeAddress);
                    }
                    flowAnalysisRuleBulletinDtos.computeIfAbsent(nodeIdentifier, nodeId -> new ArrayList()).add(bulletin);
                });
            }
            if (entity.getFlowRegistryClientBulletins() != null) {
                entity.getFlowRegistryClientBulletins().forEach(bulletin -> {
                    if (bulletin.getNodeAddress() == null) {
                        bulletin.setNodeAddress(nodeAddress);
                    }
                    flowRegistryClientBulletinDtos.computeIfAbsent(nodeIdentifier, nodeId -> new ArrayList()).add(bulletin);
                });
            }
            if (entity.getParameterProviderBulletins() == null) continue;
            entity.getParameterProviderBulletins().forEach(bulletin -> {
                if (bulletin.getNodeAddress() == null) {
                    bulletin.setNodeAddress(nodeAddress);
                }
                parameterProviderBulletinDtos.computeIfAbsent(nodeIdentifier, nodeId -> new ArrayList()).add(bulletin);
            });
        }
        clientEntity.setBulletins(BulletinMerger.mergeBulletins(bulletinDtos, entityMap.size()));
        clientEntity.setControllerServiceBulletins(BulletinMerger.mergeBulletins(controllerServiceBulletinDtos, entityMap.size()));
        clientEntity.setReportingTaskBulletins(BulletinMerger.mergeBulletins(reportingTaskBulletinDtos, entityMap.size()));
        clientEntity.setFlowAnalysisRuleBulletins(BulletinMerger.mergeBulletins(flowAnalysisRuleBulletinDtos, entityMap.size()));
        clientEntity.setFlowRegistryClientBulletins(BulletinMerger.mergeBulletins(flowRegistryClientBulletinDtos, entityMap.size()));
        Collections.sort(clientEntity.getBulletins(), BulletinMerger.BULLETIN_COMPARATOR);
        Collections.sort(clientEntity.getControllerServiceBulletins(), BulletinMerger.BULLETIN_COMPARATOR);
        Collections.sort(clientEntity.getReportingTaskBulletins(), BulletinMerger.BULLETIN_COMPARATOR);
        Collections.sort(clientEntity.getFlowAnalysisRuleBulletins(), BulletinMerger.BULLETIN_COMPARATOR);
        Collections.sort(clientEntity.getParameterProviderBulletins(), BulletinMerger.BULLETIN_COMPARATOR);
        if (clientEntity.getBulletins().size() > 10) {
            clientEntity.setBulletins(clientEntity.getBulletins().subList(0, 10));
        }
        if (clientEntity.getControllerServiceBulletins().size() > 5) {
            clientEntity.setControllerServiceBulletins(clientEntity.getControllerServiceBulletins().subList(0, 5));
        }
        if (clientEntity.getReportingTaskBulletins().size() > 5) {
            clientEntity.setReportingTaskBulletins(clientEntity.getReportingTaskBulletins().subList(0, 5));
        }
        if (clientEntity.getFlowAnalysisRuleBulletins().size() > 5) {
            clientEntity.setFlowAnalysisRuleBulletins(clientEntity.getFlowAnalysisRuleBulletins().subList(0, 5));
        }
        if (clientEntity.getParameterProviderBulletins().size() > 5) {
            clientEntity.setParameterProviderBulletins(clientEntity.getParameterProviderBulletins().subList(0, 5));
        }
    }
}

