/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.AccessPolicyEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;

public class AccessPolicyEndpointMerger
extends AbstractSingleEntityEndpoint<AccessPolicyEntity>
implements EndpointResponseMerger {
    public static final Pattern ACCESS_POLICIES_URI_PATTERN = Pattern.compile("/nifi-api/policies");
    public static final Pattern ACCESS_POLICY_URI_PATTERN = Pattern.compile("/nifi-api/policies/[a-f0-9\\-]{36}");
    public static final Pattern ACCESS_POLICY_LOOKUP_URI_PATTERN = Pattern.compile("/nifi-api/policies/(?:read|write)/[a-z0-9\\-/]+");
    private final AccessPolicyEntityMerger accessPolicyEntityMerger = new AccessPolicyEntityMerger();

    @Override
    public boolean canHandle(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && ACCESS_POLICY_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        if ("GET".equalsIgnoreCase(method) && ACCESS_POLICY_LOOKUP_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && ACCESS_POLICIES_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<AccessPolicyEntity> getEntityClass() {
        return AccessPolicyEntity.class;
    }

    @Override
    protected void mergeResponses(AccessPolicyEntity clientEntity, Map<NodeIdentifier, AccessPolicyEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        this.accessPolicyEntityMerger.merge(clientEntity, entityMap);
    }
}

