/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.FunnelsEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FunnelEntity;
import org.apache.nifi.web.api.entity.FunnelsEntity;

public class FunnelsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern FUNNELS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/funnels");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && FUNNELS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        FunnelsEntity responseEntity = (FunnelsEntity)clientResponse.getClientResponse().readEntity(FunnelsEntity.class);
        Set funnelEntities = responseEntity.getFunnels();
        HashMap<String, Map<NodeIdentifier, FunnelEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, FunnelEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            FunnelsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (FunnelsEntity)nodeResponse.getClientResponse().readEntity(FunnelsEntity.class);
            Set nodeFunnelEntities = nodeResponseEntity.getFunnels();
            for (FunnelEntity nodeFunnelEntity : nodeFunnelEntities) {
                String nodeFunnelEntityId = nodeFunnelEntity.getId();
                HashMap<NodeIdentifier, FunnelEntity> innerMap = (HashMap<NodeIdentifier, FunnelEntity>)entityMap.get(nodeFunnelEntityId);
                if (innerMap == null) {
                    innerMap = new HashMap<NodeIdentifier, FunnelEntity>();
                    entityMap.put(nodeFunnelEntityId, innerMap);
                }
                innerMap.put(nodeResponse.getNodeId(), nodeFunnelEntity);
            }
        }
        FunnelsEntityMerger.mergeFunnels(funnelEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

