/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.FlowAnalysisRuleEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;

public class FlowAnalysisRuleEndpointMerger
extends AbstractSingleEntityEndpoint<FlowAnalysisRuleEntity>
implements EndpointResponseMerger {
    private static final Collection<Endpoint> SUPPORTED_ENDPOINTS = Arrays.asList(new Endpoint("/nifi-api/controller/flow-analysis-rules", "POST"), new Endpoint(Pattern.compile("/nifi-api/controller/flow-analysis-rules/[a-f0-9\\-]{36}"), "GET", "PUT", "DELETE"), new Endpoint(Pattern.compile("/nifi-api/controller/flow-analysis-rules/[a-f0-9\\-]{36}/run-status"), "PUT"));
    private final FlowAnalysisRuleEntityMerger flowAnalysisRuleEntityMerger = new FlowAnalysisRuleEntityMerger();

    @Override
    public boolean canHandle(URI uri, String method) {
        boolean canHandle = SUPPORTED_ENDPOINTS.stream().filter(supportedEndpoint -> supportedEndpoint.canHandle(uri, method)).findAny().isPresent();
        return canHandle;
    }

    @Override
    protected Class<FlowAnalysisRuleEntity> getEntityClass() {
        return FlowAnalysisRuleEntity.class;
    }

    @Override
    protected void mergeResponses(FlowAnalysisRuleEntity clientEntity, Map<NodeIdentifier, FlowAnalysisRuleEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        this.flowAnalysisRuleEntityMerger.merge(clientEntity, entityMap);
    }

    private static class Endpoint {
        final List<String> httpMethods;
        final String uri;
        final Pattern uriPattern;

        public Endpoint(String uri, String ... httpMethods) {
            this.httpMethods = Arrays.asList(httpMethods);
            this.uri = uri;
            this.uriPattern = null;
        }

        public Endpoint(Pattern uriPattern, String ... httpMethods) {
            this.httpMethods = Arrays.asList(httpMethods);
            this.uri = null;
            this.uriPattern = uriPattern;
        }

        public boolean canHandle(URI uri, String method) {
            boolean canHandle = this.httpMethods.stream().filter(httpMethod -> httpMethod.equalsIgnoreCase(method)).findAny().isPresent() && (this.uri != null && this.uri.equals(uri.getPath()) || this.uriPattern != null && this.uriPattern.matcher(uri.getPath()).matches());
            return canHandle;
        }
    }
}

