/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ClearBulletinsForGroupResultsEntity;

public class ClearBulletinsForGroupEndpointMerger
extends AbstractSingleEntityEndpoint<ClearBulletinsForGroupResultsEntity> {
    public static final Pattern CLEAR_BULLETINS_FOR_GROUP_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/[a-f0-9\\-]{36}/bulletins");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "POST".equalsIgnoreCase(method) && CLEAR_BULLETINS_FOR_GROUP_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ClearBulletinsForGroupResultsEntity> getEntityClass() {
        return ClearBulletinsForGroupResultsEntity.class;
    }

    @Override
    protected void mergeResponses(ClearBulletinsForGroupResultsEntity clientEntity, Map<NodeIdentifier, ClearBulletinsForGroupResultsEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        int totalBulletinsCleared = 0;
        for (ClearBulletinsForGroupResultsEntity entity : entityMap.values()) {
            totalBulletinsCleared += entity.getBulletinsCleared();
        }
        clientEntity.setBulletinsCleared(totalBulletinsCleared);
    }
}

