/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;

public abstract class AbstractSingleDTOEndpoint<EntityType extends Entity, DtoType>
implements EndpointResponseMerger {
    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        Entity responseEntity = (Entity)clientResponse.getClientResponse().readEntity(this.getEntityClass());
        DtoType dto = this.getDto(responseEntity);
        HashMap<NodeIdentifier, DtoType> dtoMap = new HashMap<NodeIdentifier, DtoType>();
        for (NodeResponse nodeResponse : successfulResponses) {
            Entity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (Entity)nodeResponse.getClientResponse().readEntity(this.getEntityClass());
            DtoType nodeDto = this.getDto(nodeResponseEntity);
            dtoMap.put(nodeResponse.getNodeId(), nodeDto);
        }
        this.mergeResponses(dto, dtoMap, successfulResponses, problematicResponses);
        return new NodeResponse(clientResponse, responseEntity);
    }

    protected abstract Class<EntityType> getEntityClass();

    protected abstract DtoType getDto(EntityType var1);

    protected abstract void mergeResponses(DtoType var1, Map<NodeIdentifier, DtoType> var2, Set<NodeResponse> var3, Set<NodeResponse> var4);
}

