/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.io.socket.ServerSocketConfiguration;
import org.apache.nifi.io.socket.SocketUtils;
import org.apache.nifi.security.util.TlsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketListener {
    private static final int DEFAULT_SHUTDOWN_LISTENER_SECONDS = 5;
    private static final Logger logger = LoggerFactory.getLogger(SocketListener.class);
    private volatile ExecutorService executorService;
    private volatile ServerSocket serverSocket;
    private final int numThreads;
    private final int port;
    private final ServerSocketConfiguration configuration;
    private final AtomicInteger shutdownListenerSeconds = new AtomicInteger(5);

    public SocketListener(int numThreads, int port, ServerSocketConfiguration configuration) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException("Number of threads may not be less than or equal to zero.");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Server socket configuration may not be null.");
        }
        this.numThreads = numThreads;
        this.port = port;
        this.configuration = configuration;
    }

    public abstract void dispatchRequest(Socket var1);

    public void start() throws IOException {
        if (this.isRunning()) {
            return;
        }
        try {
            this.serverSocket = SocketUtils.createServerSocket(this.port, this.configuration);
        }
        catch (TlsException e) {
            throw new IOException(e);
        }
        final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        ExecutorService runnableExecServiceRef = this.executorService = Executors.newFixedThreadPool(this.numThreads, new ThreadFactory(){
            private final AtomicLong threadCounter = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = defaultThreadFactory.newThread(r);
                newThread.setName("Process Cluster Protocol Request-" + this.threadCounter.incrementAndGet());
                return newThread;
            }
        });
        ServerSocket runnableServerSocketRef = this.serverSocket;
        Thread t = new Thread(() -> {
            while (!runnableExecServiceRef.isShutdown()) {
                Socket socket = null;
                try {
                    block7: {
                        try {
                            socket = runnableServerSocketRef.accept();
                            if (this.configuration.getSocketTimeout() == null) break block7;
                            socket.setSoTimeout(this.configuration.getSocketTimeout());
                        }
                        catch (SocketTimeoutException ste) {
                            SocketUtils.closeQuietly(socket);
                            continue;
                        }
                        catch (SocketException se) {
                            logger.warn("Failed to communicate with {}", (Object)(socket == null ? "Unknown Host" : socket.getInetAddress().getHostName()), (Object)se);
                            SocketUtils.closeQuietly(socket);
                            continue;
                        }
                        catch (Throwable t12) {
                            logger.warn("Socket Listener encountered exception", t12);
                            SocketUtils.closeQuietly(socket);
                            continue;
                        }
                    }
                    Socket finalSocket = socket;
                    runnableExecServiceRef.execute(() -> {
                        try {
                            this.dispatchRequest(finalSocket);
                        }
                        catch (Throwable t1) {
                            logger.warn("Dispatching socket request encountered exception", t1);
                        }
                        finally {
                            SocketUtils.closeQuietly(finalSocket);
                        }
                    });
                }
                catch (Throwable t12) {
                    logger.error("Socket Listener encountered exception", t12);
                    SocketUtils.closeQuietly(socket);
                }
            }
        });
        t.setName("Cluster Socket Listener");
        t.start();
        logger.info("Now listening for connections from nodes on port {}", (Object)this.port);
    }

    public boolean isRunning() {
        return this.executorService != null && !this.executorService.isShutdown();
    }

    public void stop() throws IOException {
        if (!this.isRunning()) {
            return;
        }
        try {
            if (this.getShutdownListenerSeconds() <= 0) {
                this.executorService.shutdownNow();
            } else {
                this.executorService.shutdown();
            }
            this.executorService.awaitTermination(this.getShutdownListenerSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.executorService.isTerminated()) {
                logger.info("Socket Listener has been terminated successfully.");
            } else {
                logger.warn("Socket Listener has not terminated properly.  There exists an uninterruptable thread that will take an indeterminate amount of time to stop.");
            }
        }
        SocketUtils.closeQuietly(this.serverSocket);
    }

    public int getShutdownListenerSeconds() {
        return this.shutdownListenerSeconds.get();
    }

    public void setShutdownListenerSeconds(int shutdownListenerSeconds) {
        this.shutdownListenerSeconds.set(shutdownListenerSeconds);
    }

    public ServerSocketConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getPort() {
        if (this.isRunning()) {
            return this.serverSocket.getLocalPort();
        }
        return this.port;
    }
}

