/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.distributed.cache.operations.CacheOperation;
import org.apache.nifi.distributed.cache.operations.StandardCacheOperation;
import org.apache.nifi.distributed.cache.server.protocol.CacheRequest;
import org.apache.nifi.distributed.cache.server.protocol.CacheVersionRequest;
import org.apache.nifi.logging.ComponentLog;

public class CacheRequestDecoder
extends ByteToMessageDecoder {
    private static final int HEADER_LENGTH = 4;
    private static final int LONG_LENGTH = 8;
    private static final int INT_LENGTH = 4;
    private static final int SHORT_LENGTH = 2;
    private final AtomicBoolean headerReceived = new AtomicBoolean();
    private final AtomicInteger protocolVersion = new AtomicInteger();
    private final ComponentLog log;
    private final int maxLength;
    private final CacheOperation[] supportedOperations;

    public CacheRequestDecoder(ComponentLog log, int maxLength, CacheOperation[] supportedOperations) {
        this.log = log;
        this.maxLength = maxLength;
        this.supportedOperations = supportedOperations;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> objects) {
        if (!this.headerReceived.get()) {
            this.readHeader(byteBuf, channelHandlerContext.channel().remoteAddress());
        }
        if (this.protocolVersion.get() == 0) {
            OptionalInt clientVersion = this.readInt(byteBuf);
            if (clientVersion.isPresent()) {
                int clientVersionFound = clientVersion.getAsInt();
                this.log.debug("Protocol Version [{}] Received [{}]", new Object[]{clientVersionFound, channelHandlerContext.channel().remoteAddress()});
                CacheVersionRequest cacheVersionRequest = new CacheVersionRequest(clientVersionFound);
                objects.add(cacheVersionRequest);
            }
        } else {
            byteBuf.markReaderIndex();
            Optional<CacheOperation> cacheOperation = this.readOperation(byteBuf);
            if (cacheOperation.isPresent()) {
                CacheOperation cacheOperationFound = cacheOperation.get();
                Optional<Object> cacheRequest = this.readRequest(cacheOperationFound, byteBuf);
                if (cacheRequest.isPresent()) {
                    Object cacheRequestFound = cacheRequest.get();
                    objects.add(cacheRequestFound);
                } else if (StandardCacheOperation.CLOSE.value().contentEquals(cacheOperationFound.value())) {
                    objects.add(new CacheRequest(cacheOperationFound, null));
                } else {
                    byteBuf.resetReaderIndex();
                    this.log.debug("Cache Operation [{}] request not processed", new Object[]{cacheOperationFound});
                }
            } else {
                byteBuf.resetReaderIndex();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        this.log.warn("Request Decoding Failed: Closing Connection [{}]", new Object[]{context.channel().remoteAddress(), cause});
        context.close();
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion.getAndSet(protocolVersion);
    }

    protected Optional<Object> readRequest(CacheOperation cacheOperation, ByteBuf byteBuf) {
        Optional<byte[]> bytes = this.readBytes(byteBuf);
        return bytes.map(value -> new CacheRequest(cacheOperation, (byte[])value));
    }

    protected Optional<byte[]> readBytes(ByteBuf byteBuf) {
        int lengthFound;
        int readableBytes;
        OptionalInt length = this.readInt(byteBuf);
        Optional<Object> bytesRead = length.isPresent() ? ((readableBytes = byteBuf.readableBytes()) >= (lengthFound = length.getAsInt()) ? Optional.of(this.readBytes(byteBuf, lengthFound)) : Optional.empty()) : Optional.empty();
        return bytesRead;
    }

    protected Optional<String> readUnicodeString(ByteBuf byteBuf) {
        String unicodeString;
        if (byteBuf.readableBytes() >= 2) {
            int length = byteBuf.readUnsignedShort();
            if (length > this.maxLength) {
                throw new IllegalArgumentException(String.format("Maximum Operation Length [%d] exceeded [%d]", this.maxLength, length));
            }
            unicodeString = byteBuf.readableBytes() >= length ? byteBuf.readCharSequence(length, StandardCharsets.UTF_8).toString() : null;
        } else {
            unicodeString = null;
        }
        return Optional.ofNullable(unicodeString);
    }

    protected OptionalInt readInt(ByteBuf byteBuf) {
        Integer integer;
        int readableBytes = byteBuf.readableBytes();
        if (readableBytes >= 4) {
            integer = byteBuf.readInt();
            if (integer > this.maxLength) {
                throw new IllegalArgumentException(String.format("Maximum Length [%d] exceeded [%d]", this.maxLength, integer));
            }
        } else {
            integer = null;
        }
        return integer == null ? OptionalInt.empty() : OptionalInt.of(integer);
    }

    protected OptionalLong readLong(ByteBuf byteBuf) {
        int readableBytes = byteBuf.readableBytes();
        return readableBytes >= 8 ? OptionalLong.of(byteBuf.readLong()) : OptionalLong.empty();
    }

    private byte[] readBytes(ByteBuf byteBuf, int length) {
        byte[] bytes = new byte[length];
        byteBuf.readBytes(bytes);
        return bytes;
    }

    private Optional<CacheOperation> readOperation(ByteBuf byteBuf) {
        Optional<String> clientOperation = this.readUnicodeString(byteBuf);
        return clientOperation.map(operation -> Arrays.stream(this.supportedOperations).filter(supportedOperation -> supportedOperation.value().contentEquals((CharSequence)operation)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cache Operation not supported [%d]", operation.length()))));
    }

    private void readHeader(ByteBuf byteBuf, SocketAddress remoteAddress) {
        if (byteBuf.readableBytes() >= 4) {
            byteBuf.readBytes(4);
            this.headerReceived.getAndSet(true);
            this.log.debug("Header Received [{}]", new Object[]{remoteAddress});
        }
    }
}

