/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.apache.nifi.distributed.cache.client.AtomicCacheEntry;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.adapter.InboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.InboundToken;

public class AtomicCacheEntryInboundAdapter<K, V>
implements InboundAdapter {
    private final K key;
    private final Deserializer<V> deserializer;
    private final ByteBuf byteBuf;
    private final InboundToken<V> inboundToken;
    private Long revision;
    private AtomicCacheEntry<K, V, Long> result;

    public AtomicCacheEntryInboundAdapter(K key, Deserializer<V> deserializer) {
        this.key = key;
        this.deserializer = deserializer;
        this.byteBuf = Unpooled.buffer();
        this.inboundToken = new InboundToken();
        this.revision = null;
        this.result = null;
    }

    public AtomicCacheEntry<K, V, Long> getResult() {
        return this.result;
    }

    @Override
    public boolean isComplete() {
        return this.inboundToken.isComplete();
    }

    @Override
    public void queue(byte[] bytes) {
        this.byteBuf.writeBytes(bytes);
    }

    @Override
    public void dequeue() throws IOException {
        if (this.revision == null && this.byteBuf.readableBytes() >= 8) {
            this.revision = this.byteBuf.readLong();
        }
        if (this.revision != null) {
            this.inboundToken.update(this.byteBuf, this.deserializer);
            if (this.inboundToken.isComplete()) {
                this.result = this.revision < 0L ? null : new AtomicCacheEntry(this.key, this.inboundToken.getValue(), (Object)this.revision);
            }
        }
    }
}

