/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.age;

import com.exceptionfactory.jagged.RecipientStanzaWriter;
import com.exceptionfactory.jagged.x25519.X25519RecipientStanzaWriterFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.nifi.processors.cipher.age.AbstractAgeKeyReader;
import org.apache.nifi.processors.cipher.age.AgeKeyIndicator;

public class AgePublicKeyReader
extends AbstractAgeKeyReader<RecipientStanzaWriter> {
    public AgePublicKeyReader() {
        super(AgeKeyIndicator.PUBLIC_KEY);
    }

    @Override
    protected List<RecipientStanzaWriter> readKeys(Set<String> keys) throws IOException {
        ArrayList<RecipientStanzaWriter> recipientStanzaWriters = new ArrayList<RecipientStanzaWriter>();
        for (String encodedPublicKey : keys) {
            try {
                RecipientStanzaWriter recipientStanzaWriter = this.getRecipientStanzaWriter(encodedPublicKey);
                recipientStanzaWriters.add(recipientStanzaWriter);
            }
            catch (Exception e) {
                throw new IOException("Parsing Public Key Recipients failed", e);
            }
        }
        return recipientStanzaWriters;
    }

    private RecipientStanzaWriter getRecipientStanzaWriter(String encodedPublicKey) throws GeneralSecurityException {
        return X25519RecipientStanzaWriterFactory.newRecipientStanzaWriter((CharSequence)encodedPublicKey);
    }
}

