/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.api;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;

public class C2Operation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private OperationType operation;
    private OperandType operand;
    private Map<String, Object> args;
    private Set<String> dependencies;

    @Schema(description="A unique identifier for the operation", accessMode=Schema.AccessMode.READ_ONLY)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Schema(description="The type of operation")
    public OperationType getOperation() {
        return this.operation;
    }

    public void setOperation(OperationType operation) {
        if (this.operand != null && !operation.isSupportedOperand(this.operand)) {
            throw new IllegalArgumentException(String.format("%s is not a valid operand for %s", new Object[]{this.operand, operation}));
        }
        this.operation = operation;
    }

    @Schema(description="The primary operand of the operation")
    public OperandType getOperand() {
        return this.operand;
    }

    public void setOperand(OperandType operand) {
        if (this.operation != null && !this.operation.isSupportedOperand(operand)) {
            throw new IllegalArgumentException(String.format("%s is not a valid operand for %s", new Object[]{operand, this.operation}));
        }
        this.operand = operand;
    }

    @Schema(description="This is an optional field and only provided when an operation has arguments in additional to the primary operand or optional parameters. Arguments are arbitrary key-value pairs whose interpretation is subject to the contextof the operation and operand. For example, given:operation=clear, operand=connection;the args might contain the name of the connection to clear.The syntax and semantics of these arguments is defined per operation inthe C2 protocol and possibly extended by an agent's implementation of theC2 protocol.")
    public Map<String, Object> getArgs() {
        return this.args;
    }

    public void setArgs(Map<String, Object> args) {
        this.args = args;
    }

    @Schema(description="Optional set of operation ids that this operation depends on. Executing this operation is conditional on the success of all dependency operations.")
    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<String> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        C2Operation operation1 = (C2Operation)o;
        return Objects.equals(this.identifier, operation1.identifier) && this.operation == operation1.operation && this.operand == operation1.operand && Objects.equals(this.args, operation1.args) && Objects.equals(this.dependencies, operation1.dependencies);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.operation, this.operand, this.args, this.dependencies});
    }

    public String toString() {
        return "C2Operation{identifier='" + this.identifier + "', operation=" + String.valueOf((Object)this.operation) + ", operand=" + String.valueOf((Object)this.operand) + ", args=" + String.valueOf(this.args) + ", dependencies=" + String.valueOf(this.dependencies) + "}";
    }
}

