/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.util.serial.SerialFactory;

public final class StateUtils {
    private static final Log log = LogFactory.getLog(StateUtils.class);
    public static final String ZIP_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_ALGORITHM = "DES";
    public static final String DEFAULT_ALGORITHM_PARAMS = "ECB/PKCS5Padding";
    public static final String INIT_PREFIX = "org.apache.myfaces.";
    public static final String USE_ENCRYPTION = "org.apache.myfaces.USE_ENCRYPTION";
    public static final String INIT_SECRET = "org.apache.myfaces.SECRET";
    public static final String INIT_ALGORITHM = "org.apache.myfaces.ALGORITHM";
    public static final String INIT_SECRET_KEY_CACHE = "org.apache.myfaces.SECRET.CACHE";
    public static final String INIT_ALGORITHM_IV = "org.apache.myfaces.ALGORITHM.IV";
    public static final String INIT_ALGORITHM_PARAM = "org.apache.myfaces.ALGORITHM.PARAMETERS";
    public static final String SERIAL_FACTORY = "org.apache.myfaces.SERIAL_FACTORY";
    private static final String COMPRESS_STATE_IN_CLIENT = "org.apache.myfaces.COMPRESS_STATE_IN_CLIENT";

    private StateUtils() {
    }

    private static void testConfiguration(ExternalContext ctx) {
        String algorithmParams = ctx.getInitParameter(INIT_ALGORITHM_PARAM);
        String iv = ctx.getInitParameter(INIT_ALGORITHM_IV);
        if (algorithmParams != null && algorithmParams.startsWith("CBC") && iv == null) {
            throw new FacesException("org.apache.myfaces.ALGORITHM.PARAMETERS parameter has been set with CBC mode, but no initialization vector has been set  with org.apache.myfaces.ALGORITHM.IV");
        }
    }

    public static boolean enableCompression(ExternalContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ExternalContext ctx");
        }
        return "true".equals(ctx.getInitParameter(COMPRESS_STATE_IN_CLIENT));
    }

    public static boolean isSecure(ExternalContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ExternalContext ctx");
        }
        return !"false".equals(ctx.getInitParameter(USE_ENCRYPTION));
    }

    public static final String construct(Object object, ExternalContext ctx) {
        byte[] bytes = StateUtils.getAsByteArray(object, ctx);
        if (StateUtils.enableCompression(ctx)) {
            bytes = StateUtils.compress(bytes);
        }
        if (StateUtils.isSecure(ctx)) {
            bytes = StateUtils.encrypt(bytes, ctx);
        }
        bytes = StateUtils.encode(bytes);
        try {
            return new String(bytes, ZIP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] getAsByteArray(Object object, ExternalContext ctx) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SerialFactory serialFactory = (SerialFactory)ctx.getApplicationMap().get(SERIAL_FACTORY);
        if (serialFactory == null) {
            throw new NullPointerException("serialFactory");
        }
        try {
            ObjectOutputStream writer = serialFactory.getObjectOutputStream(outputStream);
            writer.writeObject(object);
            byte[] bytes = outputStream.toByteArray();
            writer.close();
            outputStream.close();
            writer = null;
            outputStream = null;
            return bytes;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static byte[] encrypt(byte[] insecure, ExternalContext ctx) {
        return StateUtils.symmetric(insecure, ctx, 1);
    }

    public static final byte[] compress(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(baos);
            gzip.write(bytes, 0, bytes.length);
            gzip.finish();
            byte[] fewerBytes = baos.toByteArray();
            gzip.close();
            baos.close();
            gzip = null;
            baos = null;
            return fewerBytes;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] encode(byte[] bytes) {
        return new Base64().encode(bytes);
    }

    public static final Object reconstruct(String string, ExternalContext ctx) {
        try {
            byte[] bytes = string.getBytes(ZIP_CHARSET);
            bytes = StateUtils.decode(bytes);
            if (StateUtils.isSecure(ctx)) {
                bytes = StateUtils.decrypt(bytes, ctx);
            }
            if (StateUtils.enableCompression(ctx)) {
                bytes = StateUtils.decompress(bytes);
            }
            return StateUtils.getAsObject(bytes, ctx);
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] decode(byte[] bytes) {
        return new Base64().decode(bytes);
    }

    public static final byte[] decompress(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("byte[] bytes");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytes.length];
        try {
            int length;
            GZIPInputStream gis = new GZIPInputStream(bais);
            while ((length = gis.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            byte[] moreBytes = baos.toByteArray();
            baos.close();
            bais.close();
            gis.close();
            baos = null;
            bais = null;
            gis = null;
            return moreBytes;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static byte[] decrypt(byte[] secure, ExternalContext ctx) {
        return StateUtils.symmetric(secure, ctx, 2);
    }

    public static final Object getAsObject(byte[] bytes, ExternalContext ctx) {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        SerialFactory serialFactory = (SerialFactory)ctx.getApplicationMap().get(SERIAL_FACTORY);
        if (serialFactory == null) {
            throw new NullPointerException("serialFactory");
        }
        try {
            ObjectInputStream s = serialFactory.getObjectInputStream(input);
            Object object = s.readObject();
            s.close();
            input.close();
            s = null;
            input = null;
            return object;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        byte[] bytes = StateUtils.encode(args[0].getBytes(ZIP_CHARSET));
        System.out.println(new String(bytes, ZIP_CHARSET));
    }

    private static byte[] symmetric(byte[] data, SecretKey secretKey, String algorithm, String algorithmParams, byte[] iv, int mode) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm + "/" + algorithmParams);
            if (iv != null) {
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(mode, (Key)secretKey, ivSpec);
            } else {
                cipher.init(mode, secretKey);
            }
            if (log.isDebugEnabled()) {
                String action = mode == 1 ? "encrypting" : "decrypting";
                log.debug((Object)(action + " w/ " + algorithm + "/" + algorithmParams));
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private static byte[] symmetric(byte[] data, ExternalContext ctx, int mode) {
        if (ctx == null) {
            throw new NullPointerException("ExternalContext ctx");
        }
        StateUtils.testConfiguration(ctx);
        String _algorithm = StateUtils.findAlgorithm(ctx);
        String _algorithmParams = StateUtils.findAlgorithmParams(ctx);
        byte[] iv = StateUtils.findInitializationVector(ctx);
        Object object = ctx.getApplicationMap().get(INIT_SECRET_KEY_CACHE);
        if (object == null) {
            throw new NullPointerException("Could not find SecretKey in application scope using key 'org.apache.myfaces.SECRET.CACHE'");
        }
        if (!(object instanceof SecretKey)) {
            throw new ClassCastException("Did not find an instance of SecretKey in application scope using the key 'org.apache.myfaces.SECRET.CACHE'");
        }
        return StateUtils.symmetric(data, (SecretKey)object, _algorithm, _algorithmParams, iv, mode);
    }

    private static byte[] findInitializationVector(ExternalContext ctx) {
        byte[] iv = null;
        String _iv = ctx.getInitParameter(INIT_ALGORITHM_IV);
        if (_iv != null) {
            iv = new Base64().decode(_iv.getBytes());
        }
        return iv;
    }

    private static String findAlgorithmParams(ExternalContext ctx) {
        String algorithmParams = ctx.getInitParameter(INIT_ALGORITHM_PARAM);
        if (algorithmParams == null) {
            algorithmParams = DEFAULT_ALGORITHM_PARAMS;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using algorithm paramaters " + algorithmParams));
        }
        return algorithmParams;
    }

    private static String findAlgorithm(ExternalContext ctx) {
        return StateUtils.findAlgorithm(ctx.getInitParameter(INIT_ALGORITHM));
    }

    private static String findAlgorithm(ServletContext ctx) {
        return StateUtils.findAlgorithm(ctx.getInitParameter(INIT_ALGORITHM));
    }

    private static String findAlgorithm(String initParam) {
        if (initParam == null) {
            initParam = DEFAULT_ALGORITHM;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using algorithm " + initParam));
        }
        return initParam;
    }

    public static void initSecret(ServletContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ServletContext ctx");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Storing SecretKey @ org.apache.myfaces.SECRET.CACHE");
        }
        ctx.setAttribute(INIT_SECRET_KEY_CACHE, (Object)new SecretKeySpec(StateUtils.findSecret(ctx), StateUtils.findAlgorithm(ctx)));
    }

    private static byte[] findSecret(ServletContext ctx) {
        String _secret = ctx.getInitParameter(INIT_SECRET);
        byte[] bytes = null;
        if (_secret == null) {
            int length = 8;
            bytes = new byte[length];
            new Random().nextBytes(bytes);
            if (log.isDebugEnabled()) {
                log.debug((Object)("generated random password of length " + length));
            }
        } else {
            bytes = new Base64().decode(_secret.getBytes());
        }
        return bytes;
    }
}

