/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.shared_impl.renderkit.html.util.UnicodeEncoder;

public class HtmlResponseWriterImpl
extends ResponseWriter {
    private static final Log log = LogFactory.getLog(HtmlResponseWriterImpl.class);
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final String UTF8 = "UTF-8";
    private boolean _writeDummyForm = false;
    private Set _dummyFormParams = null;
    private Writer _writer;
    private String _contentType;
    private String _characterEncoding;
    private String _startElementName;
    private Boolean _isScript;
    private Boolean _isStyle;
    private Boolean _isTextArea;
    private UIComponent _startElementUIComponent;
    private boolean _startTagOpen;
    private static final Set s_emptyHtmlElements = new HashSet();
    private static final String CDATA_START = "<![CDATA[ \n";
    private static final String COMMENT_START = "<!--\n";
    private static final String CDATA_COMMENT_END = "\n//]]>";
    private static final String CDATA_END = "\n]]>";
    private static final String COMMENT_COMMENT_END = "\n//-->";
    private static final String COMMENT_END = "\n-->";

    public HtmlResponseWriterImpl(Writer writer, String contentType, String characterEncoding) throws FacesException {
        this._writer = writer;
        this._contentType = contentType;
        if (this._contentType == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No content type given, using default content type text/html");
            }
            this._contentType = DEFAULT_CONTENT_TYPE;
        }
        if (characterEncoding == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No character encoding given, using default character encoding ISO-8859-1");
            }
            this._characterEncoding = DEFAULT_CHARACTER_ENCODING;
        } else {
            try {
                new String("myfaces".getBytes(), characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unsupported encoding: " + characterEncoding);
            }
            this._characterEncoding = characterEncoding.toUpperCase();
        }
    }

    public static boolean supportsContentType(String contentType) {
        String[] supportedContentTypes = HtmlRendererUtils.getSupportedContentTypes();
        for (int i = 0; i < supportedContentTypes.length; ++i) {
            String supportedContentType = supportedContentTypes[i];
            if (supportedContentType.indexOf(contentType) == -1) continue;
            return true;
        }
        return false;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void flush() throws IOException {
        this.closeStartTagIfNecessary();
    }

    public void startDocument() {
    }

    public void endDocument() throws IOException {
        this._writer.flush();
    }

    public void startElement(String name, UIComponent uiComponent) throws IOException {
        if (name == null) {
            throw new NullPointerException("elementName name must not be null");
        }
        this.closeStartTagIfNecessary();
        this._writer.write(60);
        this._writer.write(name);
        this.resetStartedElement();
        this._startElementName = name;
        this._startElementUIComponent = uiComponent;
        this._startTagOpen = true;
    }

    private void closeStartTagIfNecessary() throws IOException {
        if (this._startTagOpen) {
            if (s_emptyHtmlElements.contains(this._startElementName.toLowerCase())) {
                this._writer.write(" />");
                this.resetStartedElement();
            } else {
                this._writer.write(62);
                if (this.isScriptOrStyle()) {
                    if (HtmlRendererUtils.isXHTMLContentType(this._contentType)) {
                        if (HtmlRendererUtils.isAllowedCdataSection(FacesContext.getCurrentInstance())) {
                            this._writer.write(CDATA_START);
                        }
                    } else {
                        this._writer.write(COMMENT_START);
                    }
                }
            }
            this._startTagOpen = false;
        }
    }

    private void resetStartedElement() {
        this._startElementName = null;
        this._startElementUIComponent = null;
        this._isScript = null;
        this._isStyle = null;
        this._isTextArea = null;
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("elementName name must not be null");
        }
        if (log.isWarnEnabled() && this._startElementName != null && !name.equals(this._startElementName) && log.isWarnEnabled()) {
            log.warn((Object)("HTML nesting warning on closing " + name + ": element " + this._startElementName + (this._startElementUIComponent == null ? "" : " rendered by component : " + RendererUtils.getPathToComponent(this._startElementUIComponent)) + " not explicitly closed"));
        }
        if (this._startTagOpen) {
            this.closeStartTagIfNecessary();
            if (this._startElementName != null) {
                this.writeEndTag(name);
            }
        } else if (!s_emptyHtmlElements.contains(name.toLowerCase())) {
            this.writeEndTag(name);
        }
        this.resetStartedElement();
    }

    private void writeEndTag(String name) throws IOException {
        if (this.isScriptOrStyle()) {
            if (HtmlRendererUtils.isXHTMLContentType(this._contentType)) {
                if (HtmlRendererUtils.isAllowedCdataSection(FacesContext.getCurrentInstance())) {
                    if (this.isScript()) {
                        this._writer.write(CDATA_COMMENT_END);
                    } else {
                        this._writer.write(CDATA_END);
                    }
                }
            } else if (this.isScript()) {
                this._writer.write(COMMENT_COMMENT_END);
            } else {
                this._writer.write(COMMENT_END);
            }
        }
        this._writer.write("</");
        this._writer.write(name);
        this._writer.write(62);
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException("attributeName name must not be null");
        }
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                this._writer.write(32);
                this._writer.write(name);
                this._writer.write("=\"");
                this._writer.write(name);
                this._writer.write(34);
            }
        } else {
            String strValue = value == null ? "" : value.toString();
            this._writer.write(32);
            this._writer.write(name);
            this._writer.write("=\"");
            this._writer.write(HTMLEncoder.encode(strValue, false, false, !UTF8.equals(this._characterEncoding)));
            this._writer.write(34);
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException("attributeName name must not be null");
        }
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        String strValue = value.toString();
        this._writer.write(32);
        this._writer.write(name);
        this._writer.write("=\"");
        if (strValue.toLowerCase().startsWith("javascript:")) {
            this._writer.write(HTMLEncoder.encode(strValue, false, false, !UTF8.equals(this._characterEncoding)));
        } else {
            this._writer.write(strValue);
        }
        this._writer.write(34);
    }

    public void writeComment(Object value) throws IOException {
        if (value == null) {
            throw new NullPointerException("comment name must not be null");
        }
        this.closeStartTagIfNecessary();
        this._writer.write("<!--");
        this._writer.write(value.toString());
        this._writer.write("-->");
    }

    public void writeText(Object value, String componentPropertyName) throws IOException {
        if (value == null) {
            throw new NullPointerException("Text must not be null.");
        }
        this.closeStartTagIfNecessary();
        String strValue = value.toString();
        if (this.isScriptOrStyle()) {
            if (UTF8.equals(this._characterEncoding)) {
                this._writer.write(strValue);
            } else {
                this._writer.write(UnicodeEncoder.encode(strValue));
            }
        } else {
            this._writer.write(HTMLEncoder.encode(strValue, false, false, !UTF8.equals(this._characterEncoding)));
        }
    }

    public void writeText(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException("cbuf name must not be null");
        }
        if (cbuf.length < off + len) {
            throw new IndexOutOfBoundsException(off + len + " > " + cbuf.length);
        }
        this.closeStartTagIfNecessary();
        if (this.isScriptOrStyle()) {
            String strValue = new String(cbuf, off, len);
            if (UTF8.equals(this._characterEncoding)) {
                this._writer.write(strValue);
            } else {
                this._writer.write(UnicodeEncoder.encode(strValue));
            }
        } else if (this.isTextarea()) {
            HTMLEncoder.encode(cbuf, off, len, false, false, !UTF8.equals(this._characterEncoding), this._writer);
        } else {
            HTMLEncoder.encode(cbuf, off, len, true, true, !UTF8.equals(this._characterEncoding), this._writer);
        }
    }

    private boolean isScriptOrStyle() {
        this.initializeStartedTagInfo();
        return this._isStyle != null && this._isStyle != false || this._isScript != null && this._isScript != false;
    }

    private boolean isScript() {
        this.initializeStartedTagInfo();
        return this._isScript != null && this._isScript != false;
    }

    private boolean isTextarea() {
        this.initializeStartedTagInfo();
        return this._isTextArea != null && this._isTextArea != false;
    }

    private void initializeStartedTagInfo() {
        if (this._startElementName != null) {
            if (this._isScript == null) {
                if (this._startElementName.equalsIgnoreCase("script")) {
                    this._isScript = Boolean.TRUE;
                    this._isStyle = Boolean.FALSE;
                    this._isTextArea = Boolean.FALSE;
                } else {
                    this._isScript = Boolean.FALSE;
                }
            }
            if (this._isStyle == null) {
                if (this._startElementName.equalsIgnoreCase("style")) {
                    this._isStyle = Boolean.TRUE;
                    this._isTextArea = Boolean.FALSE;
                } else {
                    this._isStyle = Boolean.FALSE;
                }
            }
            if (this._isTextArea == null) {
                this._isTextArea = this._startElementName.equalsIgnoreCase("textarea") ? Boolean.TRUE : Boolean.FALSE;
            }
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        HtmlResponseWriterImpl newWriter = new HtmlResponseWriterImpl(writer, this.getContentType(), this.getCharacterEncoding());
        newWriter._writeDummyForm = this._writeDummyForm;
        newWriter._dummyFormParams = this._dummyFormParams;
        return newWriter;
    }

    public void close() throws IOException {
        this.closeStartTagIfNecessary();
        this._writer.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = new String(cbuf, off, len);
        if (UTF8.equals(this._characterEncoding)) {
            this._writer.write(strValue);
        } else {
            this._writer.write(UnicodeEncoder.encode(strValue));
        }
    }

    public void write(int c) throws IOException {
        this.closeStartTagIfNecessary();
        this._writer.write(c);
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = new String(cbuf);
        if (UTF8.equals(this._characterEncoding)) {
            this._writer.write(strValue);
        } else {
            this._writer.write(UnicodeEncoder.encode(strValue));
        }
    }

    public void write(String str) throws IOException {
        this.closeStartTagIfNecessary();
        if (str.length() > 0) {
            if (UTF8.equals(this._characterEncoding)) {
                this._writer.write(str);
            } else {
                this._writer.write(UnicodeEncoder.encode(str));
            }
        }
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = str.substring(off, off + len);
        if (UTF8.equals(this._characterEncoding)) {
            this._writer.write(strValue);
        } else {
            this._writer.write(UnicodeEncoder.encode(strValue));
        }
    }

    public void writeText(Object object, UIComponent component, String string) throws IOException {
        this.writeText(object, string);
    }

    static {
        s_emptyHtmlElements.add("area");
        s_emptyHtmlElements.add("br");
        s_emptyHtmlElements.add("base");
        s_emptyHtmlElements.add("basefont");
        s_emptyHtmlElements.add("col");
        s_emptyHtmlElements.add("frame");
        s_emptyHtmlElements.add("hr");
        s_emptyHtmlElements.add("img");
        s_emptyHtmlElements.add("input");
        s_emptyHtmlElements.add("isindex");
        s_emptyHtmlElements.add("link");
        s_emptyHtmlElements.add("meta");
        s_emptyHtmlElements.add("param");
    }
}

