/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.InputSource;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.configuration.ConfigException;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.configuration.ObfuscatorConfig;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.ObfuscatorFilter;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.compression.CompressionFilter;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.keywords.SpecialKeywordsFilter;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.obfuscation.ObfuscationFilter;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.output.OutputGenerator;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.javascript15parser.AnnotatedToken;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.javascript15parser.JSParser15;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.javascript15parser.ParseException;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.uixtools.FileProcessor;

public class Obfuscator
extends FileProcessor {
    private Vector _filters = new Vector();
    private ObfuscatorFilter _keywordsFilter = new SpecialKeywordsFilter();
    private ObfuscationFilter _obfuscationFilter = new ObfuscationFilter();
    private OutputGenerator _outputGenerator = new OutputGenerator();
    private ObfuscatorConfig _config;
    private JSParser15 _jsParser;
    private boolean _obfuscate;
    private boolean _replaceCharLiterals;
    private boolean _stripComments;
    private boolean _stripNewlines;
    private boolean _stripSpecialKeywords;
    private boolean _stripWhitespaces;

    public Obfuscator(boolean obfuscate, boolean stripComments, boolean stripWhitespaces, boolean stripNewlines, boolean stripSpecialKeywords, boolean replaceCharLiterals, ObfuscatorConfig config) throws ConfigException {
        super("js", false);
        this._obfuscate = obfuscate;
        this._stripComments = stripComments;
        this._stripWhitespaces = stripWhitespaces;
        this._stripNewlines = stripNewlines;
        this._stripSpecialKeywords = stripSpecialKeywords;
        this._replaceCharLiterals = replaceCharLiterals;
        this._config = config;
    }

    private void init(InputSource in) {
        boolean obfuscate = in.skipObfuscation() ? false : this._obfuscate;
        boolean stripComments = in.skipStripComments() ? false : this._stripComments;
        boolean stripWhitespaces = in.skipStripWhitespaces() ? false : this._stripWhitespaces;
        boolean stripNewLines = in.skipStripNewlines() ? false : this._stripNewlines;
        boolean stripSpecialKeywords = in.skipStripSpecialKeywords() ? false : this._stripSpecialKeywords;
        this._filters.clear();
        if (stripSpecialKeywords) {
            this._filters.add(this._keywordsFilter);
        }
        if (stripWhitespaces || stripNewLines || stripComments) {
            this._filters.add(new CompressionFilter(stripComments, stripWhitespaces, stripNewLines));
        }
        if (obfuscate) {
            this._filters.add(this._obfuscationFilter);
        }
        this._filters.add(this._outputGenerator);
    }

    private void initParser(InputStream in) {
        if (this._jsParser == null) {
            this._jsParser = new JSParser15(in);
        } else {
            this._jsParser.ReInit(in);
        }
    }

    public void process(InputSource in, OutputStream out) throws ParseException {
        this.init(in);
        this._outputGenerator.setOutputStream(out);
        AnnotatedToken token = this.tokenize(in.getInputStream());
        for (ObfuscatorFilter filter : this._filters) {
            token = filter.filter(token);
        }
    }

    protected void processFile(File in, File out) throws Exception {
        if (this._obfuscate) {
            FileInputStream inStream = new FileInputStream(in);
            FileOutputStream outStream = new FileOutputStream(out);
            String fileName = in.getName();
            InputSource inpSource = new InputSource(inStream, this._config.skipObfuscation(fileName), this._config.skipStripComments(fileName), this._config.skipStripWhitespaces(fileName), this._config.skipStripNewlines(fileName), this._config.skipStripSpecialKeywords(fileName));
            this.process(inpSource, outStream);
            inStream.close();
            outStream.close();
        } else {
            FileUtils.touch((File)out);
            FileUtils.copyFile((File)in, (File)out);
        }
    }

    private AnnotatedToken tokenize(InputStream in) throws ParseException {
        this.initParser(in);
        return (AnnotatedToken)this._jsParser.Program();
    }
}

