/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.http.ArrayUtil;
import org.apache.mina.http.DecoderState;
import org.apache.mina.http.HttpException;
import org.apache.mina.http.HttpRequestImpl;
import org.apache.mina.http.HttpServerCodec;
import org.apache.mina.http.api.HttpEndOfContent;
import org.apache.mina.http.api.HttpMethod;
import org.apache.mina.http.api.HttpStatus;
import org.apache.mina.http.api.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerDecoder
implements ProtocolDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServerCodec.class);
    private static final String DECODER_STATE_ATT = "http.ds";
    private static final String PARTIAL_HEAD_ATT = "http.ph";
    private static final String BODY_REMAINING_BYTES = "http.brb";
    public static final Pattern REQUEST_LINE_PATTERN = Pattern.compile(" ");
    public static final Pattern QUERY_STRING_PATTERN = Pattern.compile("\\?");
    public static final Pattern PARAM_STRING_PATTERN = Pattern.compile("\\&|;");
    public static final Pattern KEY_VALUE_PATTERN = Pattern.compile("=");
    public static final Pattern RAW_VALUE_PATTERN = Pattern.compile("\\r\\n\\r\\n");
    public static final Pattern HEADERS_BODY_PATTERN = Pattern.compile("\\r\\n");
    public static final Pattern HEADER_VALUE_PATTERN = Pattern.compile(":");
    public static final Pattern COOKIE_SEPARATOR_PATTERN = Pattern.compile(";");

    public void decode(IoSession session, IoBuffer msg, ProtocolDecoderOutput out) {
        DecoderState state = (DecoderState)((Object)session.getAttribute((Object)DECODER_STATE_ATT));
        if (null == state) {
            session.setAttribute((Object)DECODER_STATE_ATT, (Object)DecoderState.NEW);
            state = (DecoderState)((Object)session.getAttribute((Object)DECODER_STATE_ATT));
        }
        switch (state) {
            case HEAD: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("decoding HEAD");
                }
                ByteBuffer oldBuffer = (ByteBuffer)session.getAttribute((Object)PARTIAL_HEAD_ATT);
                msg = IoBuffer.allocate((int)(oldBuffer.remaining() + msg.remaining())).put(oldBuffer).put(msg).flip();
            }
            case NEW: {
                HttpRequestImpl rq;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("decoding NEW");
                }
                if ((rq = this.parseHttpRequestHead(msg.buf())) == null) {
                    ByteBuffer partial = ByteBuffer.allocate(msg.remaining());
                    partial.put(msg.buf());
                    partial.flip();
                    session.setAttribute((Object)PARTIAL_HEAD_ATT, (Object)partial);
                    session.setAttribute((Object)DECODER_STATE_ATT, (Object)DecoderState.HEAD);
                    break;
                }
                out.write((Object)rq);
                String contentLen = rq.getHeader("content-length");
                if (contentLen != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("found content len : {}", (Object)contentLen);
                    }
                    session.setAttribute((Object)BODY_REMAINING_BYTES, (Object)Integer.valueOf(contentLen));
                    session.setAttribute((Object)DECODER_STATE_ATT, (Object)DecoderState.BODY);
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("request without content");
                    }
                    session.setAttribute((Object)DECODER_STATE_ATT, (Object)DecoderState.NEW);
                    out.write((Object)new HttpEndOfContent());
                    break;
                }
            }
            case BODY: {
                int chunkSize;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("decoding BODY: {} bytes", (Object)msg.remaining());
                }
                if ((chunkSize = msg.remaining()) != 0) {
                    IoBuffer wb = IoBuffer.allocate((int)msg.remaining());
                    wb.put(msg);
                    wb.flip();
                    out.write((Object)wb);
                }
                msg.position(msg.limit());
                int remaining = (Integer)session.getAttribute((Object)BODY_REMAINING_BYTES);
                if ((remaining -= chunkSize) <= 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("end of HTTP body");
                    }
                    session.setAttribute((Object)DECODER_STATE_ATT, (Object)DecoderState.NEW);
                    session.removeAttribute((Object)BODY_REMAINING_BYTES);
                    out.write((Object)new HttpEndOfContent());
                    break;
                }
                session.setAttribute((Object)BODY_REMAINING_BYTES, (Object)remaining);
                break;
            }
            default: {
                throw new HttpException(HttpStatus.CLIENT_ERROR_BAD_REQUEST, "Unknonwn decoder state : " + (Object)((Object)state));
            }
        }
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public void dispose(IoSession session) throws Exception {
    }

    private HttpRequestImpl parseHttpRequestHead(ByteBuffer buffer) {
        String raw = new String(buffer.array(), 0, buffer.limit());
        String[] headersAndBody = RAW_VALUE_PATTERN.split(raw, -1);
        if (headersAndBody.length <= 1) {
            return null;
        }
        String[] headerFields = HEADERS_BODY_PATTERN.split(headersAndBody[0]);
        headerFields = ArrayUtil.dropFromEndWhile(headerFields, "");
        String requestLine = headerFields[0];
        HashMap<String, String> generalHeaders = new HashMap<String, String>();
        for (int i = 1; i < headerFields.length; ++i) {
            String[] header = HEADER_VALUE_PATTERN.split(headerFields[i]);
            generalHeaders.put(header[0].toLowerCase(), header[1].trim());
        }
        String[] elements = REQUEST_LINE_PATTERN.split(requestLine);
        HttpMethod method = HttpMethod.valueOf(elements[0]);
        HttpVersion version = HttpVersion.fromString(elements[2]);
        String[] pathFrags = QUERY_STRING_PATTERN.split(elements[1]);
        String requestedPath = pathFrags[0];
        String queryString = pathFrags.length == 2 ? pathFrags[1] : "";
        buffer.position(headersAndBody[0].length() + 4);
        return new HttpRequestImpl(version, method, requestedPath, queryString, generalHeaders);
    }
}

