/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.echoclient;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import org.apache.mina.api.AbstractIoHandler;
import org.apache.mina.api.IoFilter;
import org.apache.mina.api.IoFuture;
import org.apache.mina.api.IoHandler;
import org.apache.mina.api.IoSession;
import org.apache.mina.examples.echoserver.NioEchoServer;
import org.apache.mina.transport.nio.NioTcpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioEchoClient {
    private static final Logger LOG = LoggerFactory.getLogger(NioEchoServer.class);

    public static void main(String[] args) {
        LOG.info("starting echo client");
        NioTcpClient client = new NioTcpClient();
        client.setFilters(new IoFilter[0]);
        client.setIoHandler((IoHandler)new AbstractIoHandler(){

            public void sessionOpened(IoSession session) {
                LOG.info("session opened {}", (Object)session);
            }

            public void messageReceived(IoSession session, Object message) {
                LOG.info("message received {}", message);
                if (message instanceof ByteBuffer) {
                    LOG.info("echoing");
                    session.write(message);
                }
            }

            public void messageSent(IoSession session, Object message) {
                LOG.info("message sent {}", message);
            }

            public void sessionClosed(IoSession session) {
                LOG.info("session closed {}", (Object)session);
            }
        });
        try {
            IoFuture future = client.connect((SocketAddress)new InetSocketAddress("localhost", 9999));
            try {
                IoSession session = (IoSession)future.get();
                LOG.info("session connected : {}", (Object)session);
            }
            catch (ExecutionException e) {
                LOG.error("cannot connect : ", (Throwable)e);
            }
            LOG.debug("Running the client for 25 sec");
            Thread.sleep(25000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

