/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.coap;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.api.AbstractIoFutureListener;
import org.apache.mina.api.AbstractIoHandler;
import org.apache.mina.api.IoFilter;
import org.apache.mina.api.IoFuture;
import org.apache.mina.api.IoFutureListener;
import org.apache.mina.api.IoHandler;
import org.apache.mina.api.IoSession;
import org.apache.mina.coap.CoapCode;
import org.apache.mina.coap.CoapMessage;
import org.apache.mina.coap.CoapOption;
import org.apache.mina.coap.codec.CoapDecoder;
import org.apache.mina.coap.codec.CoapEncoder;
import org.apache.mina.coap.resource.AbstractResourceHandler;
import org.apache.mina.coap.resource.CoapResponse;
import org.apache.mina.coap.resource.ResourceHandler;
import org.apache.mina.coap.resource.ResourceRegistry;
import org.apache.mina.codec.ProtocolDecoder;
import org.apache.mina.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.query.Request;
import org.apache.mina.filter.query.RequestFilter;
import org.apache.mina.transport.nio.NioUdpClient;

public class CoapClient {
    static final ResourceRegistry reg = new ResourceRegistry();

    public static void main(String[] args) {
        String status = "status message";
        System.err.println("status message".length());
        final RequestFilter rq = new RequestFilter();
        NioUdpClient client = new NioUdpClient();
        client.setFilters(new IoFilter[]{new ProtocolCodecFilter((ProtocolEncoder)new CoapEncoder(), (ProtocolDecoder)new CoapDecoder()), rq});
        client.setIoHandler((IoHandler)new Handler());
        reg.register((ResourceHandler)new AbstractResourceHandler(){

            public CoapResponse handle(CoapMessage request, IoSession session) {
                if (request.getCode() == CoapCode.GET.getCode()) {
                    return new CoapResponse(CoapCode.CONTENT.getCode(), "status message".getBytes(), new CoapOption[0]);
                }
                return new CoapResponse(CoapCode.METHOD_NOT_ALLOWED.getCode(), null, new CoapOption[0]);
            }

            public String getTittle() {
                return "Status report";
            }

            public String getPath() {
                return "st";
            }
        });
        IoFuture cf = client.connect((SocketAddress)new InetSocketAddress(args[0], Integer.parseInt(args[1])));
        cf.register((IoFutureListener)new AbstractIoFutureListener<IoSession>(){

            public void completed(IoSession session) {
                IoFuture response = rq.request(session, (Request)CoapMessage.post((String)"register?id=1234567890ABCDEF", (boolean)true, (byte[])"true".getBytes()), 10000L);
                response.register((IoFutureListener)new AbstractIoFutureListener<CoapMessage>(){

                    public void completed(CoapMessage result) {
                        if (result.getCode() == CoapCode.CREATED.getCode()) {
                            System.err.println("registered !" + result);
                        } else {
                            System.err.println("registration error : " + result.getCode());
                        }
                    }
                });
            }
        });
        try {
            Thread.sleep(50000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class Handler
    extends AbstractIoHandler {
        private Handler() {
        }

        public void messageReceived(IoSession session, Object message) {
            System.err.println("rcvd : " + message);
            CoapMessage msg = (CoapMessage)message;
            if (msg.getCode() == CoapCode.GET.getCode() || msg.getCode() == CoapCode.POST.getCode() || msg.getCode() == CoapCode.PUT.getCode() || msg.getCode() == CoapCode.DELETE.getCode()) {
                CoapMessage resp = reg.respond(msg, session);
                session.write((Object)resp);
            }
        }

        public void messageSent(IoSession session, Object message) {
            System.err.println("sent : " + message);
        }

        public void exceptionCaught(IoSession session, Exception cause) {
            System.err.println("exception !");
            cause.printStackTrace();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            session.close(true);
        }
    }
}

