/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.imagine.step3.server;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.example.imagine.step1.codec.ImageCodecFactory;
import org.apache.mina.example.imagine.step3.server.ImageServerIoHandler;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.integration.jmx.IoFilterMBean;
import org.apache.mina.integration.jmx.IoServiceMBean;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class ImageServer {
    public static final int PORT = 33789;

    public static void main(String[] args) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ImageServerIoHandler handler = new ImageServerIoHandler(mBeanServer);
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        IoServiceMBean acceptorMBean = new IoServiceMBean((IoService)acceptor);
        ObjectName acceptorName = new ObjectName(acceptor.getClass().getPackage().getName() + ":type=acceptor,name=" + acceptor.getClass().getSimpleName());
        mBeanServer.registerMBean(acceptorMBean, acceptorName);
        ProtocolCodecFilter protocolFilter = new ProtocolCodecFilter((ProtocolCodecFactory)new ImageCodecFactory(false));
        IoFilterMBean protocolFilterMBean = new IoFilterMBean((IoFilter)protocolFilter);
        ObjectName protocolFilterName = new ObjectName(protocolFilter.getClass().getPackage().getName() + ":type=protocolfilter,name=" + protocolFilter.getClass().getSimpleName());
        mBeanServer.registerMBean(protocolFilterMBean, protocolFilterName);
        acceptor.getFilterChain().addLast("protocol", (IoFilter)protocolFilter);
        DefaultIoFilterChainBuilder filterChainBuilder = acceptor.getFilterChain();
        filterChainBuilder.addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)Executors.newCachedThreadPool()));
        acceptor.setHandler((IoHandler)handler);
        acceptor.bind((SocketAddress)new InetSocketAddress(33789));
        System.out.println("Step 3 server is listenig at port 33789");
    }
}

