/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.rce;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.buffer.matcher.ClassNameMatcher;
import org.apache.mina.core.buffer.matcher.FullClassNameMatcher;
import org.apache.mina.core.buffer.matcher.RegexpClassNameMatcher;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class MinaServer {
    private static final int PORT = 9123;

    public static void main(String[] args) throws IOException {
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        ObjectSerializationCodecFactory codec = new ObjectSerializationCodecFactory();
        codec.accept((ClassNameMatcher)new RegexpClassNameMatcher("java.util.Collections.*"));
        codec.accept((ClassNameMatcher)new RegexpClassNameMatcher("org.apache.commons.collections4.*"));
        codec.accept((ClassNameMatcher)new RegexpClassNameMatcher("java.lang.*"));
        codec.accept((ClassNameMatcher)new FullClassNameMatcher(new String[]{"javax.management.BadAttributeValueExpException", "java.util.ArrayList", "java.util.HashMap"}));
        acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)codec));
        acceptor.setHandler((IoHandler)new ServerHandler());
        acceptor.bind((SocketAddress)new InetSocketAddress(9123));
        System.out.println("Mina Server started on port 9123");
    }

    private static class ServerHandler
    extends IoHandlerAdapter {
        private ServerHandler() {
        }

        public void messageReceived(IoSession session, Object message) {
            System.out.println("Received: " + message);
            session.write((Object)("Server Response: " + message));
        }
    }
}

