/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.sumup;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.sumup.message.AddMessage;
import org.apache.mina.example.sumup.message.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionHandler
extends IoHandlerAdapter {
    private static final String SUM_KEY = "sum";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSessionHandler.class);

    public void sessionOpened(IoSession session) {
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 60);
        session.setAttribute((Object)SUM_KEY, (Object)0);
    }

    public void messageReceived(IoSession session, Object message) {
        int value;
        AddMessage am = (AddMessage)message;
        int sum = (Integer)session.getAttribute((Object)SUM_KEY);
        long expectedSum = (long)sum + (long)(value = am.getValue());
        if (expectedSum > Integer.MAX_VALUE || expectedSum < Integer.MIN_VALUE) {
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(false);
            session.write((Object)rm);
        } else {
            sum = (int)expectedSum;
            session.setAttribute((Object)SUM_KEY, (Object)sum);
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(true);
            rm.setValue(sum);
            session.write((Object)rm);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        LOGGER.info("Disconnecting the idle.");
        session.close(true);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close(true);
    }
}

