/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.proxy;

import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyIoHandler
extends IoHandlerAdapter {
    private static final Charset CHARSET = Charset.forName("iso8859-1");
    public static final String OTHER_IO_SESSION = AbstractProxyIoHandler.class.getName() + ".OtherIoSession";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProxyIoHandler.class);

    public void sessionCreated(IoSession session) throws Exception {
        session.suspendRead();
        session.suspendWrite();
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (session.getAttribute((Object)OTHER_IO_SESSION) != null) {
            IoSession sess = (IoSession)session.getAttribute((Object)OTHER_IO_SESSION);
            sess.setAttribute((Object)OTHER_IO_SESSION, null);
            sess.close(false);
            session.setAttribute((Object)OTHER_IO_SESSION, null);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        IoBuffer rb = (IoBuffer)message;
        IoBuffer wb = IoBuffer.allocate((int)rb.remaining());
        rb.mark();
        wb.put(rb);
        wb.flip();
        ((IoSession)session.getAttribute((Object)OTHER_IO_SESSION)).write((Object)wb);
        rb.reset();
        LOGGER.info(rb.getString(CHARSET.newDecoder()));
    }
}

