/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.sumup;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.sumup.message.AddMessage;
import org.apache.mina.example.sumup.message.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionHandler
extends IoHandlerAdapter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final int[] values;
    private boolean finished;

    public ClientSessionHandler(int[] values) {
        this.values = values;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void sessionOpened(IoSession session) {
        for (int i = 0; i < this.values.length; ++i) {
            AddMessage m = new AddMessage();
            m.setSequence(i);
            m.setValue(this.values[i]);
            session.write((Object)m);
        }
    }

    public void messageReceived(IoSession session, Object message) {
        ResultMessage rm = (ResultMessage)message;
        if (rm.isOk()) {
            if (rm.getSequence() == this.values.length - 1) {
                this.logger.info("The sum: " + rm.getValue());
                session.close();
                this.finished = true;
            }
        } else {
            this.logger.warn("Server error, disconnecting...");
            session.close();
            this.finished = true;
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }
}

