/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.httpserver.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;

public class HttpResponseMessage {
    public static final int HTTP_STATUS_SUCCESS = 200;
    public static final int HTTP_STATUS_NOT_FOUND = 404;
    private Map headers = new HashMap();
    private ByteArrayOutputStream body = new ByteArrayOutputStream(1024);
    private int responseCode = 200;

    public HttpResponseMessage() {
        this.headers.put("Server", "HttpServer ($Revision: 451854 $ $Date: 2006-10-02 11:30:11 +0900 (\uc6d4, 02 10\uc6d4 2006) $)");
        this.headers.put("Cache-Control", "private");
        this.headers.put("Content-Type", "text/html; charset=iso-8859-1");
        this.headers.put("Connection", "keep-alive");
        this.headers.put("Keep-Alive", "200");
        this.headers.put("Date", new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date()));
        this.headers.put("Last-Modified", new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date()));
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void setContentType(String contentType) {
        this.headers.put("Content-Type", contentType);
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void appendBody(byte[] b) {
        try {
            this.body.write(b);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void appendBody(String s) {
        try {
            this.body.write(s.getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public ByteBuffer getBody() {
        return ByteBuffer.wrap((byte[])this.body.toByteArray());
    }

    public int getBodyLength() {
        return this.body.size();
    }
}

