/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.httpserver.codec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.httpserver.codec.HttpRequestMessage;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoderAdapter;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import org.apache.mina.util.CharsetUtil;

public class HttpRequestDecoder
extends MessageDecoderAdapter {
    private static final byte[] CONTENT_LENGTH = new String("Content-Length:").getBytes();
    private CharsetDecoder decoder = CharsetUtil.getDefaultCharset().newDecoder();
    private HttpRequestMessage request = null;

    public MessageDecoderResult decodable(IoSession session, ByteBuffer in) {
        try {
            return this.messageComplete(in) ? MessageDecoderResult.OK : MessageDecoderResult.NEED_DATA;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return MessageDecoderResult.NOT_OK;
        }
    }

    public MessageDecoderResult decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        HttpRequestMessage m = this.decodeBody(in);
        if (m == null) {
            return MessageDecoderResult.NEED_DATA;
        }
        out.write((Object)m);
        return MessageDecoderResult.OK;
    }

    private boolean messageComplete(ByteBuffer in) throws Exception {
        int last = in.remaining() - 1;
        if (in.remaining() < 4) {
            return false;
        }
        if (in.get(0) == 71 && in.get(1) == 69 && in.get(2) == 84) {
            return in.get(last) == 10 && in.get(last - 1) == 13 && in.get(last - 2) == 10 && in.get(last - 3) == 13;
        }
        if (in.get(0) == 80 && in.get(1) == 79 && in.get(2) == 83 && in.get(3) == 84) {
            int i;
            int eoh = -1;
            for (i = last; i > 2; --i) {
                if (in.get(i) != 10 || in.get(i - 1) != 13 || in.get(i - 2) != 10 || in.get(i - 3) != 13) continue;
                eoh = i + 1;
                break;
            }
            if (eoh == -1) {
                return false;
            }
            for (i = 0; i < last; ++i) {
                boolean found = false;
                for (int j = 0; j < CONTENT_LENGTH.length; ++j) {
                    if (in.get(i + j) != CONTENT_LENGTH[j]) {
                        found = false;
                        break;
                    }
                    found = true;
                }
                if (!found) continue;
                StringBuilder contentLength = new StringBuilder();
                for (int j = i + CONTENT_LENGTH.length; j < last && in.get(j) != 13; ++j) {
                    contentLength.append(new String(new byte[]{in.get(j)}));
                }
                return Integer.parseInt(contentLength.toString().trim()) + eoh == in.remaining();
            }
        }
        return false;
    }

    private HttpRequestMessage decodeBody(ByteBuffer in) {
        this.request = new HttpRequestMessage();
        try {
            this.request.setHeaders(this.parseRequest(new StringReader(in.getString(this.decoder))));
            return this.request;
        }
        catch (CharacterCodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Map parseRequest(Reader is) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        BufferedReader rdr = new BufferedReader(is);
        try {
            String line = rdr.readLine();
            String[] url = line.split(" ");
            if (url.length < 3) {
                return map;
            }
            map.put("URI", new String[]{line});
            map.put("Method", new String[]{url[0].toUpperCase()});
            map.put("Context", new String[]{url[1].substring(1)});
            map.put("Protocol", new String[]{url[2]});
            while ((line = rdr.readLine()) != null && line.length() > 0) {
                String[] tokens = line.split(": ");
                map.put(tokens[0], new String[]{tokens[1]});
            }
            if (url[0].equalsIgnoreCase("POST")) {
                int len = Integer.parseInt(((String[])map.get("Content-Length"))[0]);
                char[] buf = new char[len];
                if (rdr.read(buf) == len) {
                    line = String.copyValueOf(buf);
                }
            } else if (url[0].equalsIgnoreCase("GET")) {
                int idx = url[1].indexOf(63);
                if (idx != -1) {
                    map.put("Context", new String[]{url[1].substring(1, idx)});
                    line = url[1].substring(idx + 1);
                } else {
                    line = null;
                }
            }
            if (line != null) {
                String[] match = line.split("\\&");
                block7: for (int i = 0; i < match.length; ++i) {
                    String[] params = new String[1];
                    String[] tokens = match[i].split("=");
                    switch (tokens.length) {
                        case 0: {
                            map.put("@".concat(match[i]), new String[0]);
                            continue block7;
                        }
                        case 1: {
                            map.put("@".concat(tokens[0]), new String[0]);
                            continue block7;
                        }
                        default: {
                            String name = "@".concat(tokens[0]);
                            if (map.containsKey(name)) {
                                params = (String[])map.get(name);
                                String[] tmp = new String[params.length + 1];
                                for (int j = 0; j < params.length; ++j) {
                                    tmp[j] = params[j];
                                }
                                params = null;
                                params = tmp;
                            }
                            params[params.length - 1] = tokens[1].trim();
                            map.put(name, params);
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return map;
    }
}

