/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.report.AbstractConsoleReporter;
import org.apache.maven.surefire.report.AbstractFileReporter;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.MulticastingReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.report.TestSetStatistics;
import org.apache.maven.surefire.report.XMLReporter;
import org.apache.maven.surefire.util.internal.ByteBuffer;

public class TestSetRunListener
implements RunListener,
Reporter,
ConsoleOutputReceiver,
ConsoleLogger {
    private final TestSetStatistics testSetStatistics;
    private final RunStatistics globalStatistics;
    private final MulticastingReporter multicastingReporter;
    private final List testStdOut = Collections.synchronizedList(new ArrayList());
    private final List testStdErr = Collections.synchronizedList(new ArrayList());

    public TestSetRunListener(AbstractConsoleReporter consoleReporter, AbstractFileReporter fileReporter, XMLReporter xmlReporter, Reporter reporter, RunStatistics globalStats) {
        ArrayList<Reporter> reportes = new ArrayList<Reporter>();
        if (consoleReporter != null) {
            reportes.add(consoleReporter);
        }
        if (fileReporter != null) {
            reportes.add(fileReporter);
        }
        if (xmlReporter != null) {
            reportes.add(xmlReporter);
        }
        if (reporter != null) {
            reportes.add(reporter);
        }
        this.multicastingReporter = new MulticastingReporter(reportes);
        this.testSetStatistics = new TestSetStatistics();
        this.globalStatistics = globalStats;
    }

    public void info(String message) {
        this.multicastingReporter.writeMessage(message);
    }

    public void writeMessage(String message) {
        this.info(message);
    }

    public void writeMessage(byte[] b, int off, int len) {
        this.multicastingReporter.writeMessage(b, off, len);
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        ByteBuffer byteBuffer = new ByteBuffer(buf, off, len);
        if (stdout) {
            this.testStdOut.add(byteBuffer);
        } else {
            this.testStdErr.add(byteBuffer);
        }
        this.multicastingReporter.writeMessage(buf, off, len);
    }

    public void testSetStarting(ReportEntry report) {
        this.multicastingReporter.testSetStarting(report);
    }

    public void clearCapture() {
        this.testStdErr.clear();
        this.testStdOut.clear();
    }

    public void testSetCompleted(ReportEntry report) {
        this.multicastingReporter.testSetCompleted(report);
        this.multicastingReporter.reset();
        this.globalStatistics.add(this.testSetStatistics);
        this.testSetStatistics.reset();
    }

    public void testStarting(ReportEntry report) {
        this.multicastingReporter.testStarting(report);
    }

    public void testSucceeded(ReportEntry report) {
        this.testSetStatistics.incrementCompletedCount();
        this.multicastingReporter.testSucceeded(report);
        this.clearCapture();
    }

    public void testError(ReportEntry reportEntry) {
        this.multicastingReporter.testError(reportEntry, this.getAsString(this.testStdOut), this.getAsString(this.testStdErr));
        this.testSetStatistics.incrementErrorsCount();
        this.testSetStatistics.incrementCompletedCount();
        this.globalStatistics.addErrorSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapture();
    }

    public void testError(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testError(reportEntry, stdOutLog, stdErrLog);
        this.testSetStatistics.incrementErrorsCount();
        this.testSetStatistics.incrementCompletedCount();
        this.globalStatistics.addErrorSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapture();
    }

    public void testFailed(ReportEntry reportEntry) {
        this.multicastingReporter.testFailed(reportEntry, this.getAsString(this.testStdOut), this.getAsString(this.testStdErr));
        this.testSetStatistics.incrementFailureCount();
        this.testSetStatistics.incrementCompletedCount();
        this.globalStatistics.addFailureSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapture();
    }

    public void testFailed(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testFailed(reportEntry, stdOutLog, stdErrLog);
        this.testSetStatistics.incrementFailureCount();
        this.testSetStatistics.incrementCompletedCount();
        this.globalStatistics.addFailureSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapture();
    }

    public void testSkipped(ReportEntry report) {
        this.clearCapture();
        this.testSetStatistics.incrementSkippedCount();
        this.testSetStatistics.incrementCompletedCount();
        this.multicastingReporter.testSkipped(report);
    }

    public void testAssumptionFailure(ReportEntry report) {
        this.testSkipped(report);
    }

    public void reset() {
        this.multicastingReporter.reset();
    }

    public String getAsString(List byteBufferList) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iter = byteBufferList.iterator();
        while (iter.hasNext()) {
            ByteBuffer byteBuffer = (ByteBuffer)iter.next();
            stringBuffer.append(byteBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

